/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.hocr.operations;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;

@Operation(id="Document.OCRExtract", category="Files", label="Extract text from an image", description="Use 'tesseract' to extract text (OCR) from an image.", aliases={"Blob.OCRExtract"})
public class OCRExtract {
    public static final String ID = "Document.OCRExtract";
    public static final String CONVERTER = "hocr_tesseract";
    @Context
    protected CoreSession session;
    @Context
    protected ConversionService service;
    @Param(name="language", description="Language(s) to use for tesseract engine", required=false)
    protected String language = "eng";
    @Param(name="psm", description="Page and Script Options", required=false)
    protected String psm = null;
    @Param(name="oem", description="Text Detection Engine", required=false)
    protected String oem = null;

    protected Map<String, Serializable> params() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("language", (Serializable)((Object)this.language));
        if (this.psm != null) {
            params.put("psm", (Serializable)((Object)this.psm));
        }
        if (this.oem != null) {
            params.put("oem", (Serializable)((Object)this.oem));
        }
        return params;
    }

    @OperationMethod
    public Blob run(DocumentModel doc) throws IOException {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            return null;
        }
        return this.service.convert(CONVERTER, bh, this.params()).getBlob();
    }

    @OperationMethod
    public Blob run(Blob blob) throws IOException {
        return this.service.convert(CONVERTER, (BlobHolder)new SimpleBlobHolder(blob), this.params()).getBlob();
    }

    @OperationMethod
    public BlobList run(BlobList blobs) throws IOException {
        BlobList bl = new BlobList();
        for (Blob blob : blobs) {
            bl.add((Object)this.run(blob));
        }
        return bl;
    }
}

