/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.hocr.converter;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineConverter;
import org.nuxeo.runtime.api.Framework;

public class CommandLineBlobConverter
extends CommandLineConverter {
    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        cmdBlobParams.put("sourceFilePath", blobHolder.getBlob());
        if (parameters != null && !parameters.isEmpty()) {
            Iterator<Map.Entry<String, Serializable>> iter = parameters.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, Serializable> entry = iter.next();
                if (!(entry.getValue() instanceof Blob)) continue;
                cmdBlobParams.put(entry.getKey(), (Blob)entry.getValue());
                iter.remove();
            }
        }
        return cmdBlobParams;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String tmpDir = this.getTmpDirectory(parameters);
        Path tmpDirPath = tmpDir != null ? Paths.get(tmpDir, new String[0]) : null;
        try {
            Path outDirPath = tmpDirPath != null ? Files.createTempDirectory(tmpDirPath, null, new FileAttribute[0]) : Framework.createTempDirectory(null, (FileAttribute[])new FileAttribute[0]);
            HashMap<String, String> cmdStringParams = new HashMap<String, String>();
            cmdStringParams.put("outDirPath", outDirPath.toString());
            String targetFileName = (String)((Object)parameters.get("targetFileName"));
            Path targetFilePath = targetFileName == null ? Files.createTempFile(outDirPath, null, null, new FileAttribute[0]) : Paths.get(outDirPath.toString(), targetFileName);
            cmdStringParams.put("targetFilePath", targetFilePath.toString());
            if (targetFileName == null) {
                Files.delete(targetFilePath);
            }
            for (Map.Entry entry : this.initParameters.entrySet()) {
                if (RESERVED_PARAMETERS.contains(entry.getKey())) continue;
                cmdStringParams.put((String)entry.getKey(), (String)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : parameters.entrySet()) {
                if (RESERVED_PARAMETERS.contains(entry.getKey())) continue;
                cmdStringParams.put((String)entry.getKey(), (String)entry.getValue());
            }
            return cmdStringParams;
        }
        catch (IOException e) {
            throw new ConversionException(e.getMessage(), (Throwable)e);
        }
    }
}

