/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.crowd;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.AuthenticationState;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticatorImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelperImpl;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractorImpl;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.ClientResourceLocator;
import com.atlassian.crowd.service.client.CrowdClient;
import com.atlassian.crowd.service.client.ResourceLocator;
import java.io.IOException;
import java.io.StringReader;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.auth.crowd.user.CrowdUserInfo;
import org.nuxeo.ecm.platform.ui.web.auth.LoginScreenHelper;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPluginLogoutExtension;
import org.nuxeo.ecm.platform.ui.web.auth.plugins.FormAuthenticator;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.service.UserMapperService;

public class CrowdAuthenticationPlugin
extends FormAuthenticator
implements LoginProviderLinkComputer,
NuxeoAuthenticationPluginLogoutExtension {
    private static final Log log = LogFactory.getLog(CrowdAuthenticationPlugin.class);
    public static final String CROWD_CONFIG_PROPS_KEY = "configProps";
    public static final String CROWD_CONFIG_FILE_KEY = "configFile";
    public static final String CROWD_CONFIG_DIR_KEY = "configDirectory";
    public static final String CROWD_MAPPING_NAME_KEY = "mappingName";
    public static final String CROWD_AUTH_PLUGIN_KEY = "pluginName";
    public static final String CROWD_AUTH_LOGGING_KEY = "logging";
    public static final String CROWD_AUTH_ALL_GROUPS = "checkAllGroups";
    public static final String USERINFO_KEY = "CROWD_USERINFO";
    public static final String DEFAULT_MAPPING_NAME = "crowd";
    private String crowdConfigFile = "crowd.properties";
    private String crowdConfigDir = null;
    private String mappingName = "crowd";
    private String pluginName = "CROWD_AUTH";
    private boolean logging = false;
    private CrowdClient client;
    private ClientProperties clientProperties;
    private CrowdHttpAuthenticatorImpl httpAuthenticator;

    public void initPlugin(Map<String, String> parameters) {
        super.initPlugin(parameters);
        this.logging = "true".equalsIgnoreCase(parameters.get(CROWD_AUTH_LOGGING_KEY));
        if (parameters.containsKey(CROWD_AUTH_PLUGIN_KEY)) {
            this.pluginName = parameters.get(CROWD_AUTH_PLUGIN_KEY);
        }
        if (parameters.containsKey(CROWD_CONFIG_PROPS_KEY)) {
            String cProps = parameters.get(CROWD_CONFIG_PROPS_KEY);
            Properties props = new Properties();
            try {
                props.load(new StringReader(cProps));
                this.clientProperties = ClientPropertiesImpl.newInstanceFromProperties((Properties)props);
            }
            catch (IOException iox) {
                log.error((Object)"Error loading Crowd configuration properties from configProps");
            }
        }
        if (this.clientProperties == null) {
            if (parameters.containsKey(CROWD_CONFIG_FILE_KEY)) {
                this.crowdConfigFile = parameters.get(CROWD_CONFIG_FILE_KEY);
            }
            if (parameters.containsKey(CROWD_CONFIG_DIR_KEY)) {
                this.crowdConfigDir = parameters.get(CROWD_CONFIG_DIR_KEY);
            }
            ClientResourceLocator res = new ClientResourceLocator(this.crowdConfigFile);
            if (this.crowdConfigDir != null) {
                res = new ClientResourceLocator(this.crowdConfigFile, this.crowdConfigDir);
            }
            try {
                res.getProperties();
            }
            catch (Exception ex) {
                log.error((Object)"Unable to load Crowd configuration properties", (Throwable)ex);
                throw new RuntimeException("Atlassian Crowd not configured");
            }
            this.clientProperties = ClientPropertiesImpl.newInstanceFromResourceLocator((ResourceLocator)res);
        }
        if (parameters.containsKey(CROWD_MAPPING_NAME_KEY)) {
            this.mappingName = parameters.get(CROWD_MAPPING_NAME_KEY);
        }
        RestCrowdClientFactory factory = new RestCrowdClientFactory();
        CrowdHttpTokenHelper tokenHelper = CrowdHttpTokenHelperImpl.getInstance((CrowdHttpValidationFactorExtractor)CrowdHttpValidationFactorExtractorImpl.getInstance());
        this.client = factory.newInstance(this.clientProperties);
        this.httpAuthenticator = new CrowdHttpAuthenticatorImpl(this.client, this.clientProperties, tokenHelper);
        if (StringUtils.isNotBlank((CharSequence)parameters.get("name"))) {
            LoginScreenHelper.registerSingleProviderLoginScreenConfig((String)parameters.get("name"), (String)parameters.get("icon"), null, (String)parameters.get("label"), (String)parameters.get("description"), (LoginProviderLinkComputer)this);
        }
    }

    public String computeUrl(HttpServletRequest req, String requestedUrl) {
        return this.clientProperties.getApplicationAuthenticationURL();
    }

    private void logCrowd(String reason, Exception e, String user, boolean warn) {
        if (!(warn || this.logging || log.isDebugEnabled())) {
            return;
        }
        StringBuilder buf = new StringBuilder(reason);
        if (e != null) {
            buf.append(" [").append(e.getMessage()).append("]");
        }
        if (user != null) {
            buf.append(" user: ").append(user);
        }
        if (warn || this.logging) {
            log.warn((Object)buf.toString(), (Throwable)e);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)buf.toString(), (Throwable)e);
        }
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest req, HttpServletResponse resp) {
        User crowdUser;
        boolean createOrUpdate;
        block29: {
            createOrUpdate = true;
            crowdUser = null;
            AuthenticationState state = null;
            try {
                state = this.httpAuthenticator.checkAuthenticated(req, resp);
            }
            catch (OperationFailedException e) {
                this.logCrowd("Failure checking authentication state", (Exception)((Object)e), null, true);
                req.setAttribute("org.nuxeo.ecm.login.error", (Object)"connection.error");
                return null;
            }
            if (!state.isAuthenticated()) {
                UserIdentificationInfo creds = this.getBasicAuth(req, resp);
                if (creds == null) {
                    String method = req.getMethod();
                    if (!"POST".equals(method)) {
                        log.debug((Object)("Request method is " + method + ", only accepting POST"));
                        return null;
                    }
                    String userName = req.getParameter(this.usernameKey);
                    String password = req.getParameter(this.passwordKey);
                    if (req.getParameter("form_submitted_marker") != null && (userName == null || userName.length() == 0)) {
                        req.setAttribute("org.nuxeo.ecm.login.error", (Object)"username.missing");
                    }
                    if (userName == null || userName.length() == 0) {
                        log.debug((Object)"No user found in form request");
                        return null;
                    }
                    creds = new UserIdentificationInfo(userName, password);
                }
                this.logCrowd("Authenticating Request", null, creds.getUserName(), false);
                try {
                    crowdUser = this.httpAuthenticator.authenticate(req, resp, creds.getUserName(), creds.getPassword());
                    if (log.isDebugEnabled() && crowdUser == null) {
                        log.debug((Object)("No such user in Crowd: " + creds.getUserName()));
                        break block29;
                    }
                    this.logCrowd("User Authenticated", null, creds.getUserName(), false);
                }
                catch (ExpiredCredentialException e) {
                    this.logCrowd("Credential Expired", (Exception)((Object)e), creds.getUserName(), false);
                    req.setAttribute("org.nuxeo.ecm.login.error", (Object)"expired");
                }
                catch (InactiveAccountException e) {
                    this.logCrowd("Inactive Account", (Exception)((Object)e), creds.getUserName(), false);
                    req.setAttribute("org.nuxeo.ecm.login.error", (Object)"inactive");
                }
                catch (ApplicationPermissionException e) {
                    this.logCrowd("Invalid Application Permission", (Exception)((Object)e), creds.getUserName(), true);
                    req.setAttribute("org.nuxeo.ecm.login.error", (Object)"invalid");
                }
                catch (InvalidAuthenticationException e) {
                    this.logCrowd("Invalid Authentication", (Exception)((Object)e), creds.getUserName(), false);
                }
                catch (OperationFailedException e) {
                    this.logCrowd("Operation Failed", (Exception)((Object)e), creds.getUserName(), true);
                    req.setAttribute("org.nuxeo.ecm.login.error", (Object)"connection.error");
                }
                catch (InvalidTokenException e) {
                    this.logCrowd("Invalid Token", (Exception)((Object)e), creds.getUserName(), false);
                }
                catch (ApplicationAccessDeniedException e) {
                    this.logCrowd("Application Access Denied", (Exception)((Object)e), creds.getUserName(), true);
                }
            } else {
                createOrUpdate = false;
                Principal p = (Principal)state.getAuthenticatedPrincipal().orNull();
                if (p == null) {
                    return null;
                }
                try {
                    this.logCrowd("Authorizing Request", null, p.getName(), false);
                    crowdUser = this.client.getUser(p.getName());
                }
                catch (UserNotFoundException e) {
                    this.logCrowd("User Not Found", (Exception)((Object)e), p.getName(), false);
                }
                catch (OperationFailedException e) {
                    this.logCrowd("Operation Failed", (Exception)((Object)e), p.getName(), true);
                    req.setAttribute("org.nuxeo.ecm.login.error", (Object)"connection.error");
                }
                catch (ApplicationPermissionException e) {
                    this.logCrowd("Invalid Application Permission", (Exception)((Object)e), p.getName(), true);
                }
                catch (InvalidAuthenticationException e) {
                    this.logCrowd("Invalid Authentication", (Exception)((Object)e), p.getName(), false);
                }
            }
        }
        if (crowdUser == null) {
            return null;
        }
        this.logCrowd("Authorized User", null, crowdUser.toString(), false);
        try {
            CrowdUserInfo info = this.getCrowdUser(crowdUser);
            info.setRoles(this.getGroups(crowdUser));
            req.setAttribute(USERINFO_KEY, (Object)info);
            UserMapperService ums = (UserMapperService)Framework.getService(UserMapperService.class);
            ums.getOrCreateAndUpdateNuxeoPrincipal(this.mappingName, (Object)info, createOrUpdate, createOrUpdate, null);
            return info;
        }
        catch (UserNotFoundException e) {
            this.logCrowd("User Not Found", (Exception)((Object)e), crowdUser.getName(), false);
        }
        catch (InvalidAuthenticationException e) {
            this.logCrowd("Invalid Authentication", (Exception)((Object)e), crowdUser.getName(), false);
        }
        catch (OperationFailedException e) {
            this.logCrowd("Operation Failed", (Exception)((Object)e), crowdUser.getName(), true);
            req.setAttribute("org.nuxeo.ecm.login.error", (Object)"connection.error");
        }
        catch (ApplicationPermissionException e) {
            this.logCrowd("Invalid Application Permission", (Exception)((Object)e), crowdUser.getName(), true);
        }
        return null;
    }

    public UserIdentificationInfo getBasicAuth(HttpServletRequest req, HttpServletResponse resp) {
        String auth = req.getHeader("authorization");
        if (auth != null && auth.toLowerCase().startsWith("basic")) {
            int idx = auth.indexOf(32);
            String b64userPassword = auth.substring(idx + 1);
            byte[] clearUp = Base64.decodeBase64((String)b64userPassword);
            String userCredentials = new String(clearUp);
            int idxOfColon = userCredentials.indexOf(58);
            if (idxOfColon > 0 && idxOfColon < userCredentials.length() - 1) {
                String username = userCredentials.substring(0, idxOfColon);
                String password = userCredentials.substring(idxOfColon + 1);
                return new UserIdentificationInfo(username, password);
            }
            return null;
        }
        return null;
    }

    private CrowdUserInfo getCrowdUser(User token) throws InvalidAuthenticationException, UserNotFoundException, OperationFailedException, ApplicationPermissionException {
        return CrowdUserInfo.builder().withUserName(token.getName()).withEmail(token.getEmailAddress()).withFirstName(token.getFirstName()).withLastName(token.getLastName()).withCompany(token.getDisplayName()).withAuthPluginName(this.pluginName).withPassword(token.getExternalId()).build();
    }

    private Set<String> getGroups(User user) throws UserNotFoundException, OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        HashSet<String> allRoles = new HashSet<String>();
        int start = 0;
        int batch = 100;
        List groups = null;
        while (start == allRoles.size()) {
            groups = this.client.getGroupsForUser(user.getName(), start, batch);
            start += batch;
            for (Group g : groups) {
                allRoles.add(g.getName());
            }
            if (!allRoles.isEmpty()) continue;
            break;
        }
        return allRoles;
    }

    public Boolean handleLogout(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            try {
                this.httpAuthenticator.logout(request, response);
            }
            catch (Exception e) {
                this.logCrowd("Error logging out with Crowd", e, null, false);
            }
        }
        return Boolean.FALSE;
    }
}

