/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.crowd.user;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;

public class CrowdUserInfo
extends UserIdentificationInfo {
    private static final long serialVersionUID = 6894397878763275157L;
    protected String firstName;
    protected String lastName;
    protected String company;
    protected String email;
    protected Set<String> roles;

    private CrowdUserInfo(String emailAsUserName, String password) {
        super(emailAsUserName, password);
    }

    public CrowdUserInfo(String emailAsUserName, String password, String firstName, String lastName, String email, String company) {
        super(emailAsUserName, password);
        if (emailAsUserName == null || StringUtils.isEmpty((CharSequence)emailAsUserName)) {
            throw new IllegalStateException("A valid username should always be provided");
        }
        this.firstName = firstName;
        this.lastName = lastName;
        this.company = company;
        this.email = email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCompany() {
        return this.company;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CrowdUserInfo [email=").append(this.email).append(", firstName=").append(this.firstName).append(", lastName=").append(this.lastName).append(", company=").append(this.company).append(", roles=").append(this.roles).append("]");
        return builder.toString();
    }

    public static CrowdUserInfoBuilder builder() {
        return new CrowdUserInfoBuilder();
    }

    public static class CrowdUserInfoBuilder {
        protected String token;
        protected String userName;
        protected String password;
        protected String authPluginName;
        protected String company;
        protected String lastName;
        protected String firstName;
        protected String email;

        private CrowdUserInfoBuilder() {
        }

        public CrowdUserInfoBuilder withToken(String token) {
            this.token = token;
            return this;
        }

        public CrowdUserInfoBuilder withUserName(String userName) {
            this.userName = userName;
            return this;
        }

        public CrowdUserInfoBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public CrowdUserInfoBuilder withAuthPluginName(String authPluginName) {
            this.authPluginName = authPluginName;
            return this;
        }

        public CrowdUserInfoBuilder withCompany(String company) {
            this.company = company;
            return this;
        }

        public CrowdUserInfoBuilder withLastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public CrowdUserInfoBuilder withFirstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public CrowdUserInfoBuilder withEmail(String email) {
            this.email = email;
            return this;
        }

        public CrowdUserInfo build() {
            CrowdUserInfo info = new CrowdUserInfo(this.userName, this.password, this.firstName, this.lastName, this.email, this.company);
            info.setToken(this.token);
            info.setAuthPluginName(this.authPluginName);
            return info;
        }
    }
}

