/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.auth.crowd.user;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.auth.crowd.user.CrowdUserInfo;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.usermapper.extension.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdUserMapper
implements UserMapper {
    private static final Logger log = LoggerFactory.getLogger(CrowdUserMapper.class);
    protected static String userSchemaName = "user";
    protected static String userIdField = "userId";
    protected static String groupSchemaName = "group";
    protected boolean checkAllGroups = false;
    protected boolean logging = false;
    protected UserManager userManager;

    public void init(Map<String, String> params) throws Exception {
        this.userManager = (UserManager)Framework.getService(UserManager.class);
        userSchemaName = this.userManager.getUserSchemaName();
        userIdField = this.userManager.getUserIdField();
        groupSchemaName = this.userManager.getGroupSchemaName();
        log.warn("User mapper activated: " + params);
        if (params != null) {
            this.logging = Boolean.parseBoolean(params.get("logging"));
            this.checkAllGroups = Boolean.parseBoolean(params.get("checkAllGroups"));
            if (this.checkAllGroups) {
                this.logCrowd("Adding and removing Crowd users from all groups, including system-defined entries", null, null, false);
            } else {
                this.logCrowd("Adding Crowd users to all groups, but only removing from Crowd-created groups", null, null, false);
            }
        }
    }

    private void logCrowd(String reason, Exception e, Object user, boolean warn) {
        if (!(warn || this.logging || log.isDebugEnabled())) {
            return;
        }
        StringBuilder buf = new StringBuilder(reason);
        if (e != null) {
            buf.append(" [").append(e.getMessage()).append("]");
        }
        if (user != null) {
            buf.append(": ").append(user.toString());
        }
        if (warn || this.logging) {
            log.warn(buf.toString(), (Throwable)e);
        } else if (log.isDebugEnabled()) {
            log.debug(buf.toString(), (Throwable)e);
        }
    }

    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject) {
        return this.getOrCreateAndUpdateNuxeoPrincipal(userObject, true, true, null);
    }

    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject, boolean createIfNeeded, boolean update, Map<String, Serializable> params) {
        if (userObject == null) {
            this.logCrowd("No user object found to map", null, null, true);
            return null;
        }
        return (NuxeoPrincipal)Framework.doPrivileged(() -> {
            Object userId;
            CrowdUserInfo userInfo = (CrowdUserInfo)((Object)((Object)userObject));
            if (log.isDebugEnabled()) {
                this.logCrowd("Mapping user info", null, (Object)userInfo, false);
            }
            DocumentModel userDoc = this.findUser(userInfo);
            HashSet existingGroups = new HashSet();
            if (userDoc == null && createIfNeeded) {
                this.logCrowd("Creating user", null, (Object)userInfo, false);
                userDoc = this.createUser(userInfo);
            } else if (userDoc != null) {
                List userGroups;
                NuxeoPrincipal np;
                userId = (String)((Object)userDoc.getPropertyValue(userIdField));
                if (userId != null && (np = this.userManager.getPrincipal((String)userId)) != null && (userGroups = np.getGroups()) != null && !userGroups.isEmpty()) {
                    existingGroups.addAll(userGroups);
                }
            } else {
                this.logCrowd("No user mapping found", null, (Object)userInfo, true);
                return null;
            }
            if (createIfNeeded || update) {
                for (String role : userInfo.getRoles()) {
                    this.findOrCreateGroup(role, userInfo);
                    existingGroups.remove(role);
                }
                if (!existingGroups.isEmpty()) {
                    this.logCrowd("Removing from groups: " + existingGroups, null, (Object)userInfo, false);
                    for (String toRemove : existingGroups) {
                        this.removeFromGroup(toRemove, userInfo);
                    }
                }
            }
            if (update) {
                this.logCrowd("Updating user", null, (Object)userInfo, false);
                this.updateUser(userDoc, userInfo);
            }
            userId = (String)((Object)userDoc.getPropertyValue(userIdField));
            return this.userManager.getPrincipal((String)userId);
        });
    }

    private DocumentModel findOrCreateGroup(String role, CrowdUserInfo user) {
        List users;
        DocumentModel groupDoc = this.findGroup(role);
        if (groupDoc == null) {
            groupDoc = this.userManager.getBareGroupModel();
            groupDoc.setPropertyValue(this.userManager.getGroupIdField(), (Serializable)((Object)role));
            groupDoc.setProperty(groupSchemaName, "groupname", (Object)role);
            groupDoc.setProperty(groupSchemaName, "grouplabel", (Object)(role + " group"));
            groupDoc.setProperty(groupSchemaName, "description", (Object)("Crowd/" + user.getAuthPluginName()));
            groupDoc = this.userManager.createGroup(groupDoc);
        }
        if (!(users = this.userManager.getUsersInGroupAndSubGroups(role)).contains(user.getUserName())) {
            users.add(user.getUserName());
            groupDoc.setProperty(groupSchemaName, this.userManager.getGroupMembersField(), (Object)users);
            this.userManager.updateGroup(groupDoc);
        }
        return groupDoc;
    }

    private DocumentModel removeFromGroup(String role, CrowdUserInfo user) {
        String desc;
        DocumentModel groupDoc = this.findGroup(role);
        if (groupDoc == null) {
            return null;
        }
        if (!(this.checkAllGroups || (desc = (String)groupDoc.getProperty(groupSchemaName, "description")) != null && desc.equals("Crowd/" + user.getAuthPluginName()))) {
            this.logCrowd("Not removing Crowd user from: " + groupDoc.getProperty(groupSchemaName, "groupname") + ", not directly assigned", null, (Object)user, false);
            return null;
        }
        List users = this.userManager.getUsersInGroupAndSubGroups(role);
        if (users.contains(user.getUserName())) {
            users.remove(user.getUserName());
            groupDoc.setProperty(groupSchemaName, this.userManager.getGroupMembersField(), (Object)users);
            this.userManager.updateGroup(groupDoc);
        }
        return groupDoc;
    }

    private DocumentModel findGroup(String role) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put(this.userManager.getGroupIdField(), role);
        DocumentModelList groups = this.userManager.searchGroups(query, null);
        if (groups.isEmpty()) {
            return null;
        }
        return (DocumentModel)groups.get(0);
    }

    private DocumentModel findUser(UserIdentificationInfo userInfo) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put(userIdField, userInfo.getUserName());
        DocumentModelList users = this.userManager.searchUsers(query, null);
        if (users.isEmpty()) {
            return null;
        }
        return (DocumentModel)users.get(0);
    }

    private DocumentModel createUser(CrowdUserInfo userInfo) {
        DocumentModel userDoc;
        try {
            userDoc = this.userManager.getBareUserModel();
            userDoc.setPropertyValue(userIdField, (Serializable)((Object)userInfo.getUserName()));
            userDoc.setPropertyValue(this.userManager.getUserEmailField(), (Serializable)((Object)userInfo.getEmail()));
            userDoc = this.userManager.createUser(userDoc);
        }
        catch (NuxeoException e) {
            String message = "Error while creating user [" + userInfo.getUserName() + "] in UserManager";
            this.logCrowd("Error creating user", (Exception)((Object)e), (Object)userInfo, true);
            throw new RuntimeException(message);
        }
        return userDoc;
    }

    private void updateUser(DocumentModel userDoc, CrowdUserInfo userInfo) {
        userDoc.setPropertyValue(userIdField, (Serializable)((Object)userInfo.getUserName()));
        userDoc.setPropertyValue(this.userManager.getUserEmailField(), (Serializable)((Object)userInfo.getEmail()));
        userDoc.setProperty(userSchemaName, "firstName", (Object)userInfo.getFirstName());
        userDoc.setProperty(userSchemaName, "lastName", (Object)userInfo.getLastName());
        userDoc.setProperty(userSchemaName, "password", (Object)userInfo.getPassword());
        userDoc.setProperty(userSchemaName, "company", (Object)userInfo.getCompany());
        this.userManager.updateUser(userDoc);
    }

    public Object wrapNuxeoPrincipal(NuxeoPrincipal principal, Object nativePrincipal, Map<String, Serializable> params) {
        throw new UnsupportedOperationException();
    }

    public void release() {
    }
}

