/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.smart.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.smart.query.SmartQuery;

public abstract class IncrementalSmartQuery
implements SmartQuery {
    private static final long serialVersionUID = 1L;
    protected String existingQueryPart;
    protected String logicalOperator;
    protected Boolean addNotOperator;
    protected Boolean openParenthesis;
    protected Boolean closeParenthesis;
    protected String selectedRowName;
    protected String leftExpression;
    protected String conditionalOperator;
    protected Boolean escapeValue;
    protected Object value;
    protected Boolean booleanValue;
    protected String stringValue;
    protected List<String> stringListValue;
    protected String[] stringArrayValue;
    protected Date datetimeValue;
    protected Date otherDatetimeValue;
    protected Date dateValue;
    protected Date otherDateValue;
    protected Long integerValue;
    protected Double floatValue;

    public IncrementalSmartQuery(String existingQueryPart) {
        this.existingQueryPart = existingQueryPart;
    }

    public String getExistingQueryPart() {
        return this.existingQueryPart;
    }

    public void setExistingQueryPart(String existingQueryPart) {
        this.existingQueryPart = existingQueryPart;
    }

    public boolean getShowLogicalOperator() {
        return this.existingQueryPart != null && this.existingQueryPart.trim().length() != 0;
    }

    public String getLogicalOperator() {
        return this.logicalOperator;
    }

    public void setLogicalOperator(String logicalOperator) {
        this.logicalOperator = logicalOperator;
    }

    public boolean getShowAddNotOperator() {
        return true;
    }

    public Boolean getAddNotOperator() {
        return this.addNotOperator;
    }

    public void setAddNotOperator(Boolean addNotOperator) {
        this.addNotOperator = addNotOperator;
    }

    public boolean getShowOpenParenthesis() {
        return true;
    }

    public Boolean getOpenParenthesis() {
        return this.openParenthesis;
    }

    public void setOpenParenthesis(Boolean openParenthesis) {
        this.openParenthesis = openParenthesis;
    }

    public boolean getShowCloseParenthesis() {
        int numberClosed;
        int numberOpened;
        return this.existingQueryPart != null && (numberOpened = StringUtils.countMatches((String)this.existingQueryPart, (String)"(")) > (numberClosed = StringUtils.countMatches((String)this.existingQueryPart, (String)")"));
    }

    public Boolean getCloseParenthesis() {
        return this.closeParenthesis;
    }

    public void setCloseParenthesis(Boolean closeParenthesis) {
        this.closeParenthesis = closeParenthesis;
    }

    public String getSelectedRowName() {
        return this.selectedRowName;
    }

    public void setSelectedRowName(String selectedRowName) {
        this.selectedRowName = selectedRowName;
        this.leftExpression = null;
        this.conditionalOperator = null;
        this.clearValues();
    }

    public List<String> getSelectedRowNames() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.selectedRowName != null) {
            res.add(this.selectedRowName);
        }
        return res;
    }

    public String getLeftExpression() {
        return this.leftExpression;
    }

    public void setLeftExpression(String leftExpression) {
        this.leftExpression = leftExpression;
    }

    public String getConditionalOperator() {
        return this.conditionalOperator;
    }

    public void setConditionalOperator(String conditionalOperator) {
        this.conditionalOperator = conditionalOperator;
        this.clearValues();
    }

    public Boolean getEscapeValue() {
        return this.escapeValue;
    }

    public void setEscapeValue(Boolean escapeValue) {
        this.escapeValue = escapeValue;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public void setBooleanValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
        this.setValue(booleanValue);
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String stringValue) {
        this.stringValue = stringValue;
        this.setValue(stringValue);
    }

    public List<String> getStringListValue() {
        return this.stringListValue;
    }

    public void setStringListValue(List<String> stringListValue) {
        this.stringListValue = stringListValue;
        this.setValue(stringListValue);
    }

    public String[] getStringArrayValue() {
        return this.stringArrayValue;
    }

    public void setStringArrayValue(String[] stringArrayValue) {
        this.stringArrayValue = stringArrayValue;
        this.setValue(stringArrayValue);
    }

    public Date getDatetimeValue() {
        return this.datetimeValue;
    }

    public void setDatetimeValue(Date datetimeValue) {
        this.datetimeValue = datetimeValue;
        this.setValue(datetimeValue);
    }

    public Date getOtherDatetimeValue() {
        return this.otherDatetimeValue;
    }

    public void setOtherDatetimeValue(Date otherDatetimeValue) {
        this.otherDatetimeValue = otherDatetimeValue;
        this.setValue(otherDatetimeValue);
    }

    public Date getDateValue() {
        return this.dateValue;
    }

    public void setDateValue(Date dateValue) {
        this.dateValue = dateValue;
        this.setValue(dateValue);
    }

    public Date getOtherDateValue() {
        return this.otherDateValue;
    }

    public void setOtherDateValue(Date otherDateValue) {
        this.otherDateValue = otherDateValue;
        this.setValue(otherDateValue);
    }

    public Long getIntegerValue() {
        return this.integerValue;
    }

    public void setIntegerValue(Long integerValue) {
        this.integerValue = integerValue;
        this.setValue(integerValue);
    }

    public Double getFloatValue() {
        return this.floatValue;
    }

    public void setFloatValue(Double floatValue) {
        this.floatValue = floatValue;
        this.setValue(floatValue);
    }

    protected void clear() {
        this.logicalOperator = null;
        this.addNotOperator = null;
        this.openParenthesis = null;
        this.closeParenthesis = null;
        this.selectedRowName = null;
        this.leftExpression = null;
        this.conditionalOperator = null;
        this.clearValues();
    }

    protected void clearValues() {
        this.escapeValue = null;
        this.value = null;
        this.booleanValue = null;
        this.stringValue = null;
        this.stringListValue = null;
        this.stringArrayValue = null;
        this.datetimeValue = null;
        this.otherDatetimeValue = null;
        this.dateValue = null;
        this.otherDateValue = null;
        this.integerValue = null;
        this.floatValue = null;
    }
}

