/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.smart.query.jsf;

import java.io.Serializable;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.smart.query.HistoryList;
import org.nuxeo.ecm.platform.smart.query.SmartQuery;
import org.nuxeo.ecm.platform.smart.query.jsf.IncrementalSmartNXQLQuery;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="smartNXQLQueryActions")
@Scope(value=ScopeType.PAGE)
public class SmartNXQLQueryActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int HISTORY_CAPACITY = 20;
    protected String queryPart;
    protected HistoryList<String> queryPartHistory;
    protected HistoryList<String> redoQueryPartHistory;
    protected IncrementalSmartNXQLQuery currentSmartQuery;
    @Deprecated
    protected List<String> selectedLayoutColumns;
    @Deprecated
    protected List<SortInfo> searchSortInfos;
    @RequestParameter
    @Deprecated
    protected Boolean updateQueryPart;
    @RequestParameter
    protected String queryPartComponentId;

    @Deprecated
    public String getQueryPart() {
        return this.queryPart;
    }

    public void setQueryPart(String queryPart) {
        this.queryPart = queryPart;
        this.addToQueryPartHistory(queryPart);
    }

    @Deprecated
    public List<String> getSelectedLayoutColumns() {
        return this.selectedLayoutColumns;
    }

    @Deprecated
    public void setSelectedLayoutColumns(List<String> selectedLayoutColumns) {
        this.selectedLayoutColumns = selectedLayoutColumns;
    }

    @Deprecated
    public void resetSelectedLayoutColumns() {
        this.setSelectedLayoutColumns(null);
    }

    @Deprecated
    public List<SortInfo> getSearchSortInfos() {
        return this.searchSortInfos;
    }

    @Deprecated
    public void setSearchSortInfos(List<SortInfo> searchSortInfos) {
        this.searchSortInfos = searchSortInfos;
    }

    public void initCurrentSmartQuery(String existingQueryPart, boolean resetHistory) {
        this.currentSmartQuery = new IncrementalSmartNXQLQuery(existingQueryPart);
        if (resetHistory) {
            this.queryPartHistory = null;
            this.addToQueryPartHistory(existingQueryPart);
        }
    }

    public void initCurrentSmartQuery(String existingQueryPart) {
        this.initCurrentSmartQuery(existingQueryPart, true);
    }

    public SmartQuery getCurrentSmartQuery() {
        if (this.currentSmartQuery == null) {
            this.initCurrentSmartQuery("", true);
        }
        return this.currentSmartQuery;
    }

    public void queryPartChanged(AjaxBehaviorEvent event) {
        UIComponent comp = event.getComponent();
        if (!(comp instanceof EditableValueHolder)) {
            throw new ClientException("Component not found");
        }
        EditableValueHolder queryComp = (EditableValueHolder)comp;
        String newQuery = (String)queryComp.getSubmittedValue();
        queryComp.setValue((Object)newQuery);
        this.currentSmartQuery.setExistingQueryPart(newQuery);
        this.addToQueryPartHistory(newQuery);
    }

    protected void setQueryPart(ActionEvent event, String newQuery, boolean rebuildSmartQuery) throws ClientException {
        if (this.currentSmartQuery != null) {
            UIComponent component = event.getComponent();
            if (component == null) {
                return;
            }
            EditableValueHolder queryPartComp = (EditableValueHolder)ComponentUtils.getComponent((UIComponent)component, (String)this.queryPartComponentId, EditableValueHolder.class);
            if (queryPartComp != null) {
                queryPartComp.setSubmittedValue((Object)newQuery);
                queryPartComp.setValue((Object)newQuery);
                if (rebuildSmartQuery) {
                    this.initCurrentSmartQuery(newQuery, false);
                } else {
                    this.currentSmartQuery.setExistingQueryPart(newQuery);
                }
                this.addToQueryPartHistory(newQuery);
            } else {
                throw new ClientException("Component not found");
            }
        }
    }

    public void buildQueryPart(ActionEvent event) throws ClientException {
        if (this.currentSmartQuery != null) {
            String newQuery = this.currentSmartQuery.buildQuery();
            this.setQueryPart(event, newQuery, true);
        }
    }

    public void clearQueryPart(ActionEvent event) throws ClientException {
        this.setQueryPart(event, "", false);
    }

    protected String getCurrentQueryPart() {
        if (this.currentSmartQuery != null) {
            return this.currentSmartQuery.getExistingQueryPart();
        }
        return null;
    }

    protected boolean hasQueryPartHistory(HistoryList<String> history) {
        if (history == null || history.isEmpty()) {
            return false;
        }
        String lastQueryPart = (String)history.getLast();
        return history.size() != 1 || !lastQueryPart.equals(this.getCurrentQueryPart());
    }

    public boolean getCanUndoQueryPartChanges() {
        return this.hasQueryPartHistory(this.queryPartHistory);
    }

    public boolean getCanRedoQueryPartChanges() {
        return this.hasQueryPartHistory(this.redoQueryPartHistory);
    }

    public void undoHistoryChanges(ActionEvent event, HistoryList<String> history, HistoryList<String> redoHistory) throws ClientException {
        if (!this.hasQueryPartHistory(history)) {
            return;
        }
        String lastQueryPart = (String)history.getLast();
        history.removeLast();
        String currentQueryPart = this.getCurrentQueryPart();
        if (!lastQueryPart.equals(currentQueryPart)) {
            this.setQueryPart(event, lastQueryPart, false);
        } else if (history.size() > 0) {
            lastQueryPart = (String)history.getLast();
            this.setQueryPart(event, lastQueryPart, false);
            history.removeLast();
        }
        if (redoHistory != null) {
            this.addToHistory(currentQueryPart, redoHistory);
        }
    }

    public void undoQueryPartChanges(ActionEvent event) throws ClientException {
        if (this.redoQueryPartHistory == null) {
            this.redoQueryPartHistory = new HistoryList(20);
        }
        this.undoHistoryChanges(event, this.queryPartHistory, this.redoQueryPartHistory);
    }

    public void redoQueryPartChanges(ActionEvent event) throws ClientException {
        this.undoHistoryChanges(event, this.redoQueryPartHistory, null);
    }

    protected void addToHistory(String queryPart, HistoryList<String> queryPartHistory) {
        if (queryPartHistory == null) {
            return;
        }
        if (queryPart == null) {
            queryPart = "";
        }
        if (queryPartHistory.size() == 0) {
            queryPartHistory.addLast((Object)queryPart);
        } else {
            String lastQueryPart = (String)queryPartHistory.getLast();
            if (!queryPart.equals(lastQueryPart)) {
                queryPartHistory.addLast((Object)queryPart);
            }
        }
    }

    protected void addToQueryPartHistory(String queryPart) {
        if (this.queryPartHistory == null) {
            this.queryPartHistory = new HistoryList(20);
        }
        this.addToHistory(queryPart, this.queryPartHistory);
    }

    public void validateQueryPart(FacesContext context, UIComponent component, Object value) {
        if (value == null) {
            return;
        }
        if (!(value instanceof String)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"error.smart.query.invalidQuery"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
        String query = (String)value;
        if (StringUtils.isBlank((String)query)) {
            return;
        }
        if (!IncrementalSmartNXQLQuery.isValid(query)) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"error.smart.query.invalidQuery"), null);
            context.addMessage(null, message);
            throw new ValidatorException(message);
        }
    }

    public boolean isAjaxRequest() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return context.getPartialViewContext().isAjaxRequest();
        }
        return false;
    }

    public String getWhereClause(String queryPart, boolean followedByClause) {
        if (StringUtils.isBlank((String)queryPart)) {
            if (followedByClause) {
                return "WHERE ";
            }
            return "";
        }
        return "WHERE (" + queryPart + ")" + (followedByClause ? " AND " : "");
    }

    public boolean isInitialized() {
        return this.currentSmartQuery != null;
    }

    @Observer(value={"searchSelected"}, create=false)
    @BypassInterceptors
    public void resetCurrentSmartQuery() {
        this.currentSmartQuery = null;
    }
}

