/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.smart.query.jsf;

import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.SQLQueryParser;
import org.nuxeo.ecm.core.search.api.client.querymodel.Escaper;
import org.nuxeo.ecm.core.search.api.client.querymodel.LuceneMinimalEscaper;
import org.nuxeo.ecm.platform.smart.query.IncrementalSmartQuery;

public class IncrementalSmartNXQLQuery
extends IncrementalSmartQuery {
    private static final long serialVersionUID = 1L;
    public static final String GENERIC_QUERY_SELECT = "SELECT * FROM DOCUMENT WHERE ";
    public static final Escaper escaper = new LuceneMinimalEscaper();
    final SimpleDateFormat isoDate = new SimpleDateFormat("yyyy-MM-dd");
    final SimpleDateFormat isoTimeStamp = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    public IncrementalSmartNXQLQuery(String existingQueryPart) {
        super(existingQueryPart);
    }

    @Override
    public String buildQuery() {
        StringBuilder builder = new StringBuilder();
        if (this.existingQueryPart != null) {
            builder.append(this.existingQueryPart);
            builder.append(" ");
        }
        if (this.leftExpression != null && this.conditionalOperator != null) {
            if (this.logicalOperator != null) {
                builder.append(this.logicalOperator);
                builder.append(" ");
            }
            if (Boolean.TRUE.equals(this.openParenthesis)) {
                builder.append("(");
            }
            if (Boolean.TRUE.equals(this.addNotOperator) || SPECIAL_OPERATORS.NOT_STARTSWITH.getStringValue().equals(this.conditionalOperator)) {
                builder.append("NOT ");
            }
            if (this.leftExpression != null) {
                builder.append(this.leftExpression);
                builder.append(" ");
            }
            if (this.conditionalOperator != null) {
                if (SPECIAL_OPERATORS.CONTAINS.getStringValue().equals(this.conditionalOperator)) {
                    builder.append("LIKE");
                } else if (SPECIAL_OPERATORS.NOT_CONTAINS.getStringValue().equals(this.conditionalOperator)) {
                    builder.append("NOT LIKE");
                } else if (SPECIAL_OPERATORS.NOT_STARTSWITH.getStringValue().equals(this.conditionalOperator)) {
                    builder.append("STARTSWITH");
                } else {
                    builder.append(this.conditionalOperator);
                }
                builder.append(" ");
            }
            if (this.value != null) {
                Object[] values;
                if (this.booleanValue != null) {
                    if (Boolean.TRUE.equals(this.booleanValue)) {
                        builder.append(1);
                    } else {
                        builder.append(0);
                    }
                } else if (this.stringValue != null) {
                    if (SPECIAL_OPERATORS.CONTAINS.getStringValue().equals(this.conditionalOperator) || SPECIAL_OPERATORS.NOT_CONTAINS.getStringValue().equals(this.conditionalOperator)) {
                        builder.append("'%");
                        if (Boolean.TRUE.equals(this.escapeValue)) {
                            builder.append(String.format("%s", escaper.escape(this.stringValue)));
                        } else {
                            builder.append(this.stringValue);
                        }
                        builder.append("%'");
                    } else if (Boolean.TRUE.equals(this.escapeValue)) {
                        builder.append(String.format("'%s'", escaper.escape(this.stringValue)));
                    } else {
                        builder.append(String.format("'%s'", this.stringValue));
                    }
                } else if (this.stringListValue != null) {
                    values = new String[this.stringListValue.size()];
                    values = this.stringListValue.toArray(values);
                    if (Boolean.TRUE.equals(this.escapeValue)) {
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = String.format("'%s'", escaper.escape((String)values[i]));
                        }
                    } else {
                        for (int i = 0; i < values.length; ++i) {
                            values[i] = String.format("'%s'", values[i]);
                        }
                    }
                    builder.append(String.format("(%s)", StringUtils.join((Object[])values, (String)",")));
                } else if (this.stringArrayValue != null) {
                    values = new String[this.stringArrayValue.length];
                    if (Boolean.TRUE.equals(this.escapeValue)) {
                        for (int i = 0; i < this.stringArrayValue.length; ++i) {
                            values[i] = String.format("'%s'", escaper.escape(this.stringArrayValue[i]));
                        }
                    } else {
                        for (int i = 0; i < this.stringArrayValue.length; ++i) {
                            values[i] = String.format("'%s'", this.stringArrayValue[i]);
                        }
                    }
                    builder.append(String.format("(%s)", StringUtils.join((Object[])values, (String)",")));
                } else if (this.datetimeValue != null) {
                    builder.append(String.format("TIMESTAMP '%s'", this.isoTimeStamp.format(this.datetimeValue.getTime())));
                    if (this.otherDatetimeValue != null) {
                        builder.append(" AND ");
                        builder.append(String.format("TIMESTAMP '%s'", this.isoTimeStamp.format(this.otherDatetimeValue.getTime())));
                    }
                } else if (this.dateValue != null) {
                    builder.append(String.format("DATE '%s'", this.isoDate.format(this.dateValue.getTime())));
                    if (this.otherDateValue != null) {
                        builder.append(" AND ");
                        builder.append(String.format("DATE '%s'", this.isoDate.format(this.otherDateValue.getTime())));
                    }
                } else if (this.integerValue != null) {
                    builder.append(this.integerValue);
                } else if (this.floatValue != null) {
                    builder.append(this.floatValue);
                } else {
                    builder.append(this.value.toString());
                }
            }
            if (Boolean.TRUE.equals(this.closeParenthesis)) {
                builder.append(")");
            }
        }
        String newValue = builder.toString().trim();
        this.clear();
        this.existingQueryPart = newValue;
        return this.existingQueryPart;
    }

    @Override
    public boolean isValid() {
        return IncrementalSmartNXQLQuery.isValid(this.existingQueryPart);
    }

    public static boolean isValid(String queryPart) {
        String query = GENERIC_QUERY_SELECT + queryPart;
        try {
            SQLQueryParser.parse((String)query);
        }
        catch (QueryParseException e) {
            return false;
        }
        return true;
    }

    public static enum SPECIAL_OPERATORS {
        CONTAINS("CONTAINS"),
        BETWEEN("BETWEEN"),
        NOT_CONTAINS("NOT CONTAINS"),
        NOT_STARTSWITH("NOT STARTSWITH");

        String stringValue;

        private SPECIAL_OPERATORS(String stringValue) {
            this.stringValue = stringValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

