/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration.webengine;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.user.registration.AlreadyProcessedRegistrationException;
import org.nuxeo.ecm.user.registration.UserRegistrationException;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/userRegistration")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="userRegistration")
public class UserRegistrationObject
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(UserRegistrationObject.class);

    @GET
    @Path(value="validate/{requestId}")
    public Object validateTrialForm(@PathParam(value="requestId") String requestId) throws Exception {
        UserRegistrationService usr = (UserRegistrationService)Framework.getLocalService(UserRegistrationService.class);
        String redirectUrl = this.ctx.getServerURL() + "/" + BaseURL.getWebAppName();
        try {
            Map<String, Serializable> additionalInfo = this.buildAdditionalInfos();
            Map registrationData = usr.validateRegistration(requestId, additionalInfo);
            DocumentModel regDoc = (DocumentModel)registrationData.get("registrationDoc");
            String docId = (String)((Object)regDoc.getPropertyValue("docinfo:documentId"));
            if (!StringUtils.isEmpty((String)docId)) {
                redirectUrl = new DocumentUrlFinder(docId).getDocumentUrl();
            }
        }
        catch (AlreadyProcessedRegistrationException ape) {
            log.info((Object)"Try to validate an already processed registration");
        }
        catch (UserRegistrationException ue) {
            log.warn((Object)"Unable to validate registration request", (Throwable)ue);
            return this.getView("ValidationErrorTemplate").arg("exceptionMsg", (Object)ue.getMessage());
        }
        catch (ClientException e) {
            log.error((Object)"Error while validating registration request", (Throwable)e);
            return this.getView("ValidationErrorTemplate").arg("error", (Object)e);
        }
        return this.redirect("/" + BaseURL.getWebAppName() + "/logout");
    }

    protected Map<String, Serializable> buildAdditionalInfos() {
        return new HashMap<String, Serializable>();
    }

    protected class DocumentUrlFinder
    extends UnrestrictedSessionRunner {
        protected String docId;
        protected String documentUrl;

        public DocumentUrlFinder(String docId) throws Exception {
            super(((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository().getName());
            this.docId = docId;
        }

        public String getDocumentUrl() throws ClientException {
            this.runUnrestricted();
            return this.documentUrl;
        }

        public void run() throws ClientException {
            DocumentModel target = this.session.getDocument((DocumentRef)new IdRef(this.docId));
            this.documentUrl = DocumentModelFunctions.documentUrl(null, (DocumentModel)target, (String)"view_documents", null, (boolean)true, (HttpServletRequest)UserRegistrationObject.this.ctx.getRequest());
        }
    }
}

