/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration.actions;

import java.io.Serializable;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.user.registration.RegistrationRules;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="userRegistrationConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserRegistrationConfigurationActions
implements Serializable {
    private static Log log = LogFactory.getLog(UserRegistrationConfigurationActions.class);
    private static final long serialVersionUID = 53124326502194L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient UserRegistrationService userRegistrationService;
    protected DocumentModel selectedConfigurationDocument;
    protected String selectedConfiguration = "default_registration";

    public String getSelectedConfiguration() {
        return this.selectedConfiguration;
    }

    public Set<String> getConfigurationsName() {
        return this.userRegistrationService.getConfigurationsName();
    }

    public void setSelectedConfiguration(String selectedConfiguration) {
        this.selectedConfiguration = selectedConfiguration;
        this.selectedConfigurationDocument = null;
    }

    public RegistrationRules getRules(String configurationName) throws ClientException {
        return this.userRegistrationService.getRegistrationRules(configurationName);
    }

    public DocumentModel getConfigurationDocument() throws ClientException {
        if (this.selectedConfigurationDocument == null) {
            this.selectedConfigurationDocument = this.userRegistrationService.getRegistrationRulesDocument(this.documentManager, this.selectedConfiguration);
        }
        return this.selectedConfigurationDocument;
    }

    public void saveConfiguration() {
        try {
            this.documentManager.saveDocument(this.selectedConfigurationDocument);
            this.selectedConfigurationDocument = null;
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.save.configuration.registration"), new Object[0]);
        }
        catch (ClientException e) {
            log.warn((Object)("Unable to save configuration document: " + e.getMessage()));
            log.info((Object)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.unable.save.configuration.registration"), new Object[0]);
        }
    }

    @Observer(value={"documentChanged"})
    public void resetState() {
        this.selectedConfiguration = "default_registration";
        this.selectedConfigurationDocument = null;
    }
}

