/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.registration.RegistrationUserFactory;
import org.nuxeo.ecm.user.registration.UserRegistrationException;
import org.nuxeo.runtime.api.Framework;

public class DefaultRegistrationUserFactory
implements RegistrationUserFactory {
    private static final Log log = LogFactory.getLog(DefaultRegistrationUserFactory.class);

    @Override
    public NuxeoPrincipal createUser(CoreSession session, DocumentModel registrationDoc) throws ClientException, UserRegistrationException {
        NuxeoPrincipal user = this.doCreateUser(session, registrationDoc);
        this.doPostUserCreation(session, registrationDoc, user);
        return user;
    }

    @Override
    public void doPostUserCreation(CoreSession session, DocumentModel registrationDoc, NuxeoPrincipal user) throws ClientException, UserRegistrationException {
    }

    @Override
    public NuxeoPrincipal doCreateUser(CoreSession session, DocumentModel registrationDoc) throws ClientException, UserRegistrationException {
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        String email = (String)((Object)registrationDoc.getPropertyValue("userinfo:email"));
        if (email == null) {
            throw new UserRegistrationException("Email address must be specififed");
        }
        String login = (String)((Object)registrationDoc.getPropertyValue("userinfo:login"));
        NuxeoPrincipal user = userManager.getPrincipal(login);
        if (user == null) {
            DocumentModel newUserDoc = userManager.getBareUserModel();
            newUserDoc.setPropertyValue("username", registrationDoc.getPropertyValue("userinfo:login"));
            newUserDoc.setPropertyValue("password", registrationDoc.getPropertyValue("userinfo:password"));
            newUserDoc.setPropertyValue("firstName", registrationDoc.getPropertyValue("userinfo:firstName"));
            newUserDoc.setPropertyValue("lastName", registrationDoc.getPropertyValue("userinfo:lastName"));
            newUserDoc.setPropertyValue("email", registrationDoc.getPropertyValue("userinfo:email"));
            newUserDoc.setPropertyValue("company", registrationDoc.getPropertyValue("userinfo:company"));
            userManager.createUser(newUserDoc);
            user = userManager.getPrincipal(login);
            log.info((Object)("New user created:" + user.getName()));
        } else if (!email.equals(((NuxeoPrincipalImpl)user).getEmail())) {
            throw new UserRegistrationException("This login is not available");
        }
        return user;
    }

    @Override
    public DocumentModel doAddDocumentPermission(CoreSession session, DocumentModel registrationDoc) throws ClientException {
        String docId = (String)((Object)registrationDoc.getPropertyValue("docinfo:documentId"));
        if (StringUtils.isEmpty((String)docId)) {
            log.info((Object)"No document rights needed");
            return null;
        }
        String login = (String)((Object)registrationDoc.getPropertyValue("userinfo:login"));
        String permission = (String)((Object)registrationDoc.getPropertyValue("docinfo:permission"));
        if (StringUtils.isEmpty((String)permission)) {
            throw new UserRegistrationException("Permission must be specified");
        }
        DocumentModel document = session.getDocument((DocumentRef)new IdRef(docId));
        if (!document.getACP().getAccess(login, permission).toBoolean()) {
            ACE ace = new ACE(login, permission, true);
            document.getACP().getOrCreateACL("local").add(0, (Object)ace);
            session.setACP(document.getRef(), document.getACP(), true);
        } else {
            log.info((Object)String.format("User %s already have %s on doc %s", login, permission, docId));
        }
        return document;
    }

    @Override
    public void doPostAddDocumentPermission(CoreSession session, DocumentModel registrationDoc, DocumentModel document) throws ClientException {
    }
}

