/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.invite.RegistrationRules;
import org.nuxeo.ecm.user.invite.UserInvitationComponent;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationConfiguration;
import org.nuxeo.ecm.user.invite.UserRegistrationException;
import org.nuxeo.ecm.user.invite.UserRegistrationInfo;
import org.nuxeo.ecm.user.registration.DefaultRegistrationUserFactory;
import org.nuxeo.ecm.user.registration.DocumentRegistrationInfo;
import org.nuxeo.ecm.user.registration.RegistrationUserFactory;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.runtime.api.Framework;

public class UserRegistrationComponent
extends UserInvitationComponent
implements UserRegistrationService {
    protected static Log log = LogFactory.getLog(UserRegistrationService.class);
    private static final String REGISTRATION_SUBMITTED_EVENT = "registrationSubmitted";
    private static final String REGISTRATION_ACCEPTED_EVENT = "registrationAccepted";
    private static final String REGISTRATION_REJECTED_EVENT = "registrationRejected";
    private static final String REGISTRATION_VALIDATED_EVENT = "registrationValidated";

    @Override
    public String submitRegistrationRequest(UserRegistrationInfo userInfo, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod, boolean autoAccept) throws ClientException {
        return this.submitRegistrationRequest("default_registration", userInfo, new DocumentRegistrationInfo(), additionnalInfo, validationMethod, autoAccept);
    }

    @Override
    public String submitRegistrationRequest(String configurationName, UserRegistrationInfo userInfo, DocumentRegistrationInfo docInfo, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod, boolean autoAccept) throws ClientException, UserRegistrationException {
        RegistrationCreator creator = new RegistrationCreator(configurationName, userInfo, docInfo, additionnalInfo, validationMethod);
        creator.runUnrestricted();
        String registrationUuid = creator.getRegistrationUuid();
        boolean userAlreadyExists = null != ((UserManager)Framework.getLocalService(UserManager.class)).getPrincipal(userInfo.getLogin());
        RegistrationRules registrationRules = this.getRegistrationRules(configurationName);
        boolean byPassAdminValidation = autoAccept;
        byPassAdminValidation |= userAlreadyExists && registrationRules.allowDirectValidationForExistingUser();
        if (byPassAdminValidation |= registrationRules.allowDirectValidationForExistingUser() && registrationRules.allowDirectValidationForNonExistingUser()) {
            if (!additionnalInfo.containsKey("enterPasswordUrl")) {
                String enterPasswordUrl;
                String baseUrl = Framework.getProperty((String)"nuxeo.url");
                String string = baseUrl = StringUtils.isBlank((String)baseUrl) ? "/" : baseUrl;
                if (!baseUrl.endsWith("/")) {
                    baseUrl = baseUrl + "/";
                }
                if ((enterPasswordUrl = this.getConfiguration(configurationName).getEnterPasswordUrl()).startsWith("/")) {
                    enterPasswordUrl = enterPasswordUrl.substring(1);
                }
                additionnalInfo.put("enterPasswordUrl", (Serializable)((Object)baseUrl.concat(enterPasswordUrl)));
            }
            this.acceptRegistrationRequest(registrationUuid, additionnalInfo);
        }
        return registrationUuid;
    }

    @Override
    public Map<String, Serializable> validateRegistrationAndSendEmail(String requestId, Map<String, Serializable> additionnalInfo) throws ClientException, UserRegistrationException {
        Map registrationInfo = this.validateRegistration(requestId, additionnalInfo);
        HashMap<String, Serializable> input = new HashMap<String, Serializable>();
        input.putAll(registrationInfo);
        input.put("info", (Serializable)((Object)additionnalInfo));
        StringWriter writer = new StringWriter();
        UserRegistrationConfiguration configuration = this.getConfiguration((DocumentModel)registrationInfo.get("registrationDoc"));
        try {
            this.rh.getRenderingEngine().render(configuration.getSuccessEmailTemplate(), input, (Writer)writer);
        }
        catch (Exception e) {
            throw new ClientException("Error during rendering email", (Throwable)e);
        }
        String emailAdress = ((NuxeoPrincipalImpl)registrationInfo.get("registeredUser")).getEmail();
        String body = writer.getBuffer().toString();
        String title = configuration.getValidationEmailTitle();
        if (!Framework.isTestModeSet()) {
            try {
                this.generateMail(emailAdress, null, title, body);
            }
            catch (Exception e) {
                throw new ClientException("Error while sending mail : ", (Throwable)e);
            }
        } else {
            this.testRendering = body;
        }
        return registrationInfo;
    }

    @Override
    public void addRightsOnDoc(CoreSession session, DocumentModel registrationDoc) throws ClientException {
        UserRegistrationConfiguration configuration = this.getConfiguration(registrationDoc);
        DocumentModel document = ((DefaultRegistrationUserFactory)this.getRegistrationUserFactory(configuration)).doAddDocumentPermission(session, registrationDoc);
        if (document != null) {
            ((RegistrationUserFactory)this.getRegistrationUserFactory(configuration)).doPostAddDocumentPermission(session, registrationDoc, document);
        }
    }

    public String getNameEventRegistrationSubmitted() {
        return REGISTRATION_SUBMITTED_EVENT;
    }

    public String getNameEventRegistrationAccepted() {
        return REGISTRATION_ACCEPTED_EVENT;
    }

    public String getNameEventRegistrationRejected() {
        return REGISTRATION_REJECTED_EVENT;
    }

    public String getNameEventRegistrationValidated() {
        return REGISTRATION_VALIDATED_EVENT;
    }

    protected class RegistrationCreator
    extends UnrestrictedSessionRunner {
        protected UserRegistrationInfo userInfo;
        protected DocumentRegistrationInfo docInfo;
        protected Map<String, Serializable> additionnalInfo;
        protected String registrationUuid;
        protected UserInvitationService.ValidationMethod validationMethod;
        protected UserRegistrationConfiguration configuration;

        public String getRegistrationUuid() {
            return this.registrationUuid;
        }

        public RegistrationCreator(String configurationName, UserRegistrationInfo userInfo, DocumentRegistrationInfo docInfo, Map<String, Serializable> additionnalInfo, UserInvitationService.ValidationMethod validationMethod) {
            super(UserRegistrationComponent.this.getTargetRepositoryName());
            this.userInfo = userInfo;
            this.additionnalInfo = additionnalInfo;
            this.validationMethod = validationMethod;
            this.docInfo = docInfo;
            this.configuration = UserRegistrationComponent.this.getConfiguration(configurationName);
        }

        public void run() throws ClientException {
            String title = "registration request for " + this.userInfo.getLogin() + " (" + this.userInfo.getEmail() + " " + this.userInfo.getCompany() + ") ";
            String name = IdUtils.generateId((String)(title + "-" + System.currentTimeMillis()));
            String targetPath = UserRegistrationComponent.this.getOrCreateRootDocument(this.session, this.configuration.getName()).getPathAsString();
            DocumentModel doc = this.session.createDocumentModel(this.configuration.getRequestDocType());
            doc.setPathInfo(targetPath, name);
            doc.setPropertyValue("dc:title", (Serializable)((Object)title));
            doc.setPropertyValue("userinfo:login", (Serializable)((Object)this.userInfo.getLogin()));
            doc.setPropertyValue("userinfo:password", (Serializable)((Object)this.userInfo.getPassword()));
            doc.setPropertyValue("userinfo:firstName", (Serializable)((Object)this.userInfo.getFirstName()));
            doc.setPropertyValue("userinfo:lastName", (Serializable)((Object)this.userInfo.getLastName()));
            doc.setPropertyValue("userinfo:email", (Serializable)((Object)this.userInfo.getEmail()));
            doc.setPropertyValue("userinfo:company", (Serializable)((Object)this.userInfo.getCompany()));
            doc.setPropertyValue("registration:validationMethod", (Serializable)((Object)this.validationMethod.toString()));
            doc.setPropertyValue("docinfo:documentId", (Serializable)((Object)this.docInfo.getDocumentId()));
            doc.setPropertyValue("docinfo:permission", (Serializable)((Object)this.docInfo.getPermission()));
            doc.setPropertyValue("docinfo:documentTitle", (Serializable)((Object)this.docInfo.getDocumentTitle()));
            for (String key : this.additionnalInfo.keySet()) {
                try {
                    doc.setPropertyValue(key, this.additionnalInfo.get(key));
                }
                catch (PropertyException e) {}
            }
            doc = this.session.createDocument(doc);
            this.registrationUuid = doc.getId();
            UserRegistrationComponent.this.sendEvent(this.session, doc, UserRegistrationComponent.this.getNameEventRegistrationSubmitted());
            this.session.save();
        }
    }
}

