/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration.actions;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationInfo;
import org.nuxeo.ecm.user.registration.DocumentRegistrationInfo;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="userRegistrationActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserRegistrationActions
implements Serializable {
    private static final long serialVersionUID = 53468164827894L;
    private static Log log = LogFactory.getLog(UserRegistrationActions.class);
    public static final String MULTIPLE_EMAILS_SEPARATOR = ";";
    public static final String REQUEST_DOCUMENT_LIST = "CURRENT_USER_REQUESTS";
    public static final String REQUESTS_DOCUMENT_LIST_CHANGED = "requestDocumentsChanged";
    protected UserRegistrationInfo userinfo = new UserRegistrationInfo();
    protected DocumentRegistrationInfo docinfo = new DocumentRegistrationInfo();
    protected String multipleEmails;
    protected String comment;
    protected boolean copyOwner = false;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient ContentViewActions contentViewActions;
    @In(create=true)
    protected transient UserRegistrationService userRegistrationService;

    public UserRegistrationInfo getUserinfo() {
        return this.userinfo;
    }

    public DocumentRegistrationInfo getDocinfo() {
        return this.docinfo;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isCopyOwner() {
        return this.copyOwner;
    }

    public void setCopyOwner(boolean copyOwner) {
        this.copyOwner = copyOwner;
    }

    public UserRegistrationActions getData() {
        return this;
    }

    public String getDocType() throws ClientException {
        return this.getDocType("default_registration");
    }

    public String getDocType(String name) throws ClientException {
        return this.userRegistrationService.getConfiguration(name).getRequestDocType();
    }

    public String getValidationBaseUrl(String name) throws ClientException {
        return BaseURL.getBaseURL() + this.userRegistrationService.getConfiguration(name).getValidationRelUrl();
    }

    public String getEnterPasswordUrl(String name) throws ClientException {
        return BaseURL.getBaseURL() + this.userRegistrationService.getConfiguration(name).getEnterPasswordUrl();
    }

    public String getInvitationLayout(String name) {
        return this.userRegistrationService.getConfiguration(name).getInvitationLayout();
    }

    public String getListingLocalContentView(String name) {
        return this.userRegistrationService.getConfiguration(name).getListingLocalContentView();
    }

    public String getMultipleEmails() {
        return this.multipleEmails;
    }

    public void setMultipleEmails(String multipleEmails) {
        this.multipleEmails = multipleEmails;
    }

    public String getValidationBaseUrl() throws ClientException {
        return this.getValidationBaseUrl("default_registration");
    }

    public String getEnterPasswordUrl() throws ClientException {
        return this.getEnterPasswordUrl("default_registration");
    }

    public void acceptRegistrationRequest(DocumentModel request) {
        try {
            HashMap<String, String> additionalInfo = new HashMap<String, String>();
            additionalInfo.put("enterPasswordUrl", this.getEnterPasswordUrl());
            String docId = (String)((Object)request.getPropertyValue("docinfo:documentId"));
            IdRef docRef = new IdRef(docId);
            DocumentModel doc = this.documentManager.getDocument((DocumentRef)docRef);
            String docUrl = DocumentModelFunctions.documentUrl((DocumentModel)doc);
            additionalInfo.put("docUrl", docUrl);
            this.userRegistrationService.acceptRegistrationRequest(request.getId(), additionalInfo);
            Events.instance().raiseEvent(REQUESTS_DOCUMENT_LIST_CHANGED, new Object[0]);
        }
        catch (ClientException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, e.getMessage(), new Object[0]);
        }
    }

    public void rejectRegistrationRequest(DocumentModel request) {
        try {
            HashMap<String, String> additionalInfo = new HashMap<String, String>();
            additionalInfo.put("validationBaseURL", this.getValidationBaseUrl());
            this.userRegistrationService.rejectRegistrationRequest(request.getId(), additionalInfo);
            Events.instance().raiseEvent(REQUESTS_DOCUMENT_LIST_CHANGED, new Object[0]);
        }
        catch (ClientException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, e.getMessage(), new Object[0]);
        }
    }

    public void submitUserRegistration(String configurationName) {
        try {
            this.docinfo.setDocumentId(this.navigationContext.getCurrentDocument().getId());
            this.docinfo.setDocumentTitle(this.navigationContext.getCurrentDocument().getTitle());
            this.doSubmitUserRegistration(configurationName);
            this.resetPojos();
            Events.instance().raiseEvent(REQUESTS_DOCUMENT_LIST_CHANGED, new Object[0]);
        }
        catch (ClientException e) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, e.getMessage(), new Object[0]);
        }
    }

    public void submitMultipleUserRegistration(String configurationName) throws AddressException {
        InternetAddress[] emails;
        if (StringUtils.isBlank((String)this.multipleEmails)) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.registration.multiple.empty"), new Object[0]);
            return;
        }
        this.docinfo.setDocumentId(this.navigationContext.getCurrentDocument().getId());
        for (InternetAddress email : emails = this.splitAddresses(this.multipleEmails)) {
            this.userinfo.setLogin(email.getAddress());
            this.userinfo.setEmail(email.getAddress());
            log.debug((Object)("Request email: " + email + " with multiple invitation."));
            this.doSubmitUserRegistration(configurationName);
        }
        this.resetPojos();
        Events.instance().raiseEvent(REQUESTS_DOCUMENT_LIST_CHANGED, new Object[0]);
    }

    protected InternetAddress[] splitAddresses(String emails) throws AddressException {
        return StringUtils.isNotBlank((String)emails) ? InternetAddress.parse((String)emails.replace(MULTIPLE_EMAILS_SEPARATOR, ","), (boolean)false) : new InternetAddress[]{};
    }

    public void validateMultipleUser(FacesContext context, UIComponent component, Object value) {
        if (value instanceof String) {
            try {
                this.splitAddresses((String)value);
                return;
            }
            catch (AddressException e) {
                // empty catch block
            }
        }
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.request.error.multiple.emails"), null);
        context.addMessage(null, message);
        throw new ValidatorException(message);
    }

    public boolean getCanValidate() {
        boolean canDelete = !this.documentsListsManager.isWorkingListEmpty(REQUEST_DOCUMENT_LIST);
        for (DocumentModel doc : this.documentsListsManager.getWorkingList(REQUEST_DOCUMENT_LIST)) {
            canDelete &= this.isDocumentValidable(doc);
        }
        return canDelete;
    }

    protected boolean isDocumentValidable(DocumentModel doc) {
        try {
            return "accepted".equals(doc.getCurrentLifeCycleState());
        }
        catch (ClientException e) {
            log.warn((Object)("Unable to get lifecycle state for " + doc.getId() + ": " + e.getMessage()));
            log.debug((Object)e);
            return false;
        }
    }

    public boolean getCanDelete() {
        boolean canDelete = !this.documentsListsManager.isWorkingListEmpty(REQUEST_DOCUMENT_LIST);
        for (DocumentModel doc : this.documentsListsManager.getWorkingList(REQUEST_DOCUMENT_LIST)) {
            canDelete &= this.isDocumentDeletable(doc);
        }
        return canDelete;
    }

    protected boolean isDocumentDeletable(DocumentModel doc) {
        try {
            return !"validated".equals(doc.getCurrentLifeCycleState());
        }
        catch (ClientException e) {
            log.warn((Object)("Unable to get lifecycle state for " + doc.getId() + ": " + e.getMessage()));
            log.debug((Object)e);
            return false;
        }
    }

    public boolean getCanRevive() {
        boolean canRevive = !this.documentsListsManager.isWorkingListEmpty(REQUEST_DOCUMENT_LIST);
        for (DocumentModel doc : this.documentsListsManager.getWorkingList(REQUEST_DOCUMENT_LIST)) {
            canRevive &= this.isDocumentRevivable(doc);
        }
        return canRevive;
    }

    protected boolean isDocumentRevivable(DocumentModel doc) {
        try {
            return "accepted".equals(doc.getCurrentLifeCycleState());
        }
        catch (ClientException e) {
            log.warn((Object)("Unable to get lifecycle state for " + doc.getId() + ": " + e.getMessage()));
            log.info((Object)e);
            return false;
        }
    }

    public void validateUserRegistration() {
        if (!this.documentsListsManager.isWorkingListEmpty(REQUEST_DOCUMENT_LIST)) {
            try {
                for (DocumentModel registration : this.documentsListsManager.getWorkingList(REQUEST_DOCUMENT_LIST)) {
                    this.userRegistrationService.validateRegistration(registration.getId(), new HashMap());
                }
                Events.instance().raiseEvent(REQUESTS_DOCUMENT_LIST_CHANGED, new Object[0]);
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.validate.request"), new Object[0]);
                this.documentsListsManager.resetWorkingList(REQUEST_DOCUMENT_LIST);
            }
            catch (ClientException e) {
                log.warn((Object)("Unable to validate registration: " + e.getMessage()));
                log.info((Object)e);
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.unable.validate.request"), new Object[0]);
            }
        }
    }

    public void reviveUserRegistration() {
        if (!this.documentsListsManager.isWorkingListEmpty(REQUEST_DOCUMENT_LIST)) {
            try {
                this.userRegistrationService.reviveRegistrationRequests(this.documentManager, this.documentsListsManager.getWorkingList(REQUEST_DOCUMENT_LIST));
                Events.instance().raiseEvent(REQUESTS_DOCUMENT_LIST_CHANGED, new Object[0]);
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.revive.request"), new Object[0]);
                this.documentsListsManager.resetWorkingList(REQUEST_DOCUMENT_LIST);
            }
            catch (ClientException e) {
                log.warn((Object)("Unable to revive user: " + e.getMessage()));
                log.info((Object)e);
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.unable.revive.request"), new Object[0]);
            }
        }
    }

    public void deleteUserRegistration() {
        if (!this.documentsListsManager.isWorkingListEmpty(REQUEST_DOCUMENT_LIST)) {
            try {
                this.userRegistrationService.deleteRegistrationRequests(this.documentManager, this.documentsListsManager.getWorkingList(REQUEST_DOCUMENT_LIST));
                Events.instance().raiseEvent(REQUESTS_DOCUMENT_LIST_CHANGED, new Object[0]);
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.delete.request"), new Object[0]);
                this.documentsListsManager.resetWorkingList(REQUEST_DOCUMENT_LIST);
            }
            catch (ClientException e) {
                log.warn((Object)("Unable to delete user request:" + e.getMessage()));
                log.info((Object)e);
                this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.unable.delete.request"), new Object[0]);
            }
        }
    }

    protected void doSubmitUserRegistration(String configurationName) {
        if (StringUtils.isBlank((String)configurationName)) {
            configurationName = "default_registration";
        }
        try {
            this.userRegistrationService.submitRegistrationRequest(configurationName, this.userinfo, this.docinfo, this.getAdditionalsParameters(), UserInvitationService.ValidationMethod.EMAIL, false);
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.user.invited.success"), new Object[0]);
        }
        catch (ClientException e) {
            log.info((Object)("Unable to register user: " + e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.unable.invite.user"), new Object[0]);
        }
    }

    protected Map<String, Serializable> getAdditionalsParameters() {
        HashMap<String, Serializable> additionalsInfo = new HashMap<String, Serializable>();
        try {
            additionalsInfo.put("docinfo:documentTitle", (Serializable)((Object)this.navigationContext.getCurrentDocument().getTitle()));
            if (this.copyOwner) {
                additionalsInfo.put("registration:copyTo", (Serializable)((Object)((NuxeoPrincipal)this.documentManager.getPrincipal()).getEmail()));
            }
            additionalsInfo.put("registration:comment", (Serializable)((Object)this.comment));
        }
        catch (ClientException e) {
            log.debug((Object)e, (Throwable)e);
        }
        return additionalsInfo;
    }

    @Observer(value={"documentChanged"})
    public void resetPojos() {
        this.userinfo = new UserRegistrationInfo();
        this.docinfo = new DocumentRegistrationInfo();
        this.multipleEmails = "";
        this.copyOwner = false;
        this.comment = "";
    }

    @Observer(value={"requestDocumentsChanged"})
    public void refreshContentViewCache() {
        this.contentViewActions.refreshOnSeamEvent(REQUESTS_DOCUMENT_LIST_CHANGED);
        this.contentViewActions.resetPageProviderOnSeamEvent(REQUESTS_DOCUMENT_LIST_CHANGED);
    }
}

