/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.user.invite.DefaultInvitationUserFactory;
import org.nuxeo.ecm.user.invite.UserRegistrationException;
import org.nuxeo.ecm.user.registration.RegistrationUserFactory;

public class DefaultRegistrationUserFactory
extends DefaultInvitationUserFactory
implements RegistrationUserFactory {
    private static final Log log = LogFactory.getLog(DefaultRegistrationUserFactory.class);

    @Override
    public DocumentModel doAddDocumentPermission(CoreSession session, DocumentModel registrationDoc) throws ClientException {
        String docId = (String)((Object)registrationDoc.getPropertyValue("docinfo:documentId"));
        if (StringUtils.isEmpty((String)docId)) {
            log.info((Object)"No document rights needed");
            return null;
        }
        String login = (String)((Object)registrationDoc.getPropertyValue("userinfo:login"));
        String permission = (String)((Object)registrationDoc.getPropertyValue("docinfo:permission"));
        if (StringUtils.isEmpty((String)permission)) {
            throw new UserRegistrationException("Permission must be specified");
        }
        DocumentModel document = session.getDocument((DocumentRef)new IdRef(docId));
        if (!document.getACP().getAccess(login, permission).toBoolean()) {
            ACE ace = new ACE(login, permission, true);
            document.getACP().getOrCreateACL("local").add(0, (Object)ace);
            session.setACP(document.getRef(), document.getACP(), true);
        } else {
            log.info((Object)String.format("User %s already have %s on doc %s", login, permission, docId));
        }
        return document;
    }

    @Override
    public void doPostAddDocumentPermission(CoreSession session, DocumentModel registrationDoc, DocumentModel document) throws ClientException {
    }
}

