/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.powerpoint.utils.apachepoi;

import freemarker.template.TemplateException;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import nuxeo.powerpoint.utils.api.PowerPointUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ooxml.POIXMLProperties;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.rendering.RenderingService;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.openxmlformats.schemas.presentationml.x2006.main.CTEmbeddedFontList;
import org.openxmlformats.schemas.presentationml.x2006.main.CTEmbeddedFontListEntry;

public class PowerPointUtilsWithApachePOI
implements PowerPointUtils {
    @Override
    public JSONObject getProperties(Blob blob) {
        JSONObject obj = new JSONObject();
        try (XMLSlideShow ppt = new XMLSlideShow(blob.getStream());){
            Dimension dim = ppt.getPageSize();
            obj.put("Width", dim.width);
            obj.put("Height", dim.height);
            obj.put("AutoCompressPictures", ppt.getCTPresentation().getAutoCompressPictures());
            obj.put("CompatMode", ppt.getCTPresentation().getCompatMode());
            POIXMLProperties props = ppt.getProperties();
            POIXMLProperties.CoreProperties coreProps = props.getCoreProperties();
            obj.put("Category", (Object)coreProps.getCategory());
            obj.put("ContentStatus", (Object)coreProps.getContentStatus());
            obj.put("ContentType", (Object)coreProps.getContentType());
            obj.put("Created", (Object)DATE_FORMAT.format(coreProps.getCreated()));
            obj.put("Creator", (Object)coreProps.getCreator());
            obj.put("Description", (Object)coreProps.getDescription());
            obj.put("Identifier", (Object)coreProps.getIdentifier());
            obj.put("Keywords", (Object)coreProps.getKeywords());
            obj.put("LastModifiedByUser", (Object)coreProps.getLastModifiedByUser());
            obj.put("LastPrinted", (Object)DATE_FORMAT.format(coreProps.getLastPrinted()));
            obj.put("Modified", (Object)DATE_FORMAT.format(coreProps.getModified()));
            obj.put("Revision", (Object)coreProps.getRevision());
            obj.put("Subject", (Object)coreProps.getSubject());
            obj.put("Title", (Object)coreProps.getTitle());
            POIXMLProperties.ExtendedProperties extProps = props.getExtendedProperties();
            obj.put("CountCharacters", extProps.getCharacters());
            obj.put("CountHiddenSlides", extProps.getHiddenSlides());
            obj.put("CountLines", extProps.getLines());
            obj.put("CountMMClips", extProps.getMMClips());
            obj.put("CountNotes", extProps.getNotes());
            obj.put("CountPages", extProps.getPages());
            obj.put("CountParagraphs", extProps.getParagraphs());
            obj.put("CountSlides", ppt.getSlides().size());
            obj.put("CountTotalTime", extProps.getTotalTime());
            obj.put("CountWords", extProps.getWords());
            obj.put("Application", (Object)extProps.getApplication());
            obj.put("AppVersion", (Object)extProps.getAppVersion());
            obj.put("Company", (Object)extProps.getCompany());
            obj.put("HyperlinkBase", (Object)extProps.getHyperlinkBase());
            obj.put("Manager", (Object)extProps.getManager());
            obj.put("PresentationFormat", (Object)extProps.getPresentationFormat());
            obj.put("Template", (Object)extProps.getTemplate());
            JSONArray arr = new JSONArray();
            for (XSLFSlide slide : ppt.getSlides()) {
                JSONObject slideInfo = new JSONObject();
                slideInfo.put("SlideNumber", slide.getSlideNumber());
                slideInfo.put("Title", (Object)(slide.getTitle() == null ? "" : slide.getTitle()));
                slideInfo.put("Theme", (Object)slide.getTheme().getName());
                slideInfo.put("Master", (Object)slide.getSlideLayout().getName());
                arr.put((Object)slideInfo);
            }
            obj.put("Slidesinfo", (Object)arr);
            arr = new JSONArray();
            for (XSLFSlideMaster master : ppt.getSlideMasters()) {
                XSLFTheme masterThemeObj = master.getTheme();
                String masterTheme = masterThemeObj.getName();
                JSONArray arrLayouts = new JSONArray();
                for (XSLFSlideLayout layout : master.getSlideLayouts()) {
                    arrLayouts.put((Object)layout.getName());
                }
                JSONObject oneTheme = new JSONObject();
                oneTheme.put("Name", (Object)masterTheme);
                oneTheme.put("Layouts", (Object)arrLayouts);
                oneTheme.put("MasterFont", (Object)masterThemeObj.getMajorFont());
                oneTheme.put("MinorFont", (Object)masterThemeObj.getMinorFont());
                arr.put((Object)oneTheme);
            }
            obj.put("MasterSlides", (Object)arr);
            CTEmbeddedFontList fontList = ppt.getCTPresentation().getEmbeddedFontLst();
            arr = new JSONArray();
            if (fontList != null) {
                for (CTEmbeddedFontListEntry entry : fontList.getEmbeddedFontList()) {
                    arr.put((Object)entry.getFont().getTypeface());
                }
            }
            obj.put("EmbeddedFonts", (Object)arr);
            arr = new JSONArray();
            obj.put("Fonts", (Object)arr);
        }
        catch (IOException | JSONException e) {
            throw new NuxeoException("Failed to get slides deck properties", e);
        }
        return obj;
    }

    @Override
    public BlobList splitPresentation(Blob blob) throws IOException {
        BlobList result = new BlobList();
        if (blob == null) {
            return result;
        }
        try (XMLSlideShow ppt = new XMLSlideShow(blob.getStream());){
            int slidesCount = ppt.getSlides().size();
            for (int i = 0; i < slidesCount; ++i) {
                Blob oneSlidePres = this.getSlide(blob, i);
                result.add((Object)oneSlidePres);
            }
        }
        return result;
    }

    @Override
    public BlobList splitPresentation(DocumentModel input, String xpath) throws IOException {
        BlobList blobs = this.splitPresentation(PowerPointUtils.getBlob(input, xpath));
        return blobs;
    }

    @Override
    public Blob merge(BlobList blobs, boolean reuseMasters, String fileName) {
        throw new UnsupportedOperationException("Merging slides is not supported with Apache POI, use Aspose instead.");
    }

    @Override
    public Blob merge(DocumentModelList docs, String xpath, boolean reuseMasters, String fileName) {
        throw new UnsupportedOperationException("Merging slides is not supported with Apache POI, use Aspose instead.");
    }

    @Override
    public Blob getSlide(Blob blob, int slideNumber) throws IOException {
        Blob result = null;
        if (blob == null) {
            return result;
        }
        String pptMimeType = PowerPointUtils.getBlobMimeType(blob);
        File originalFile = blob.getFile();
        try (XMLSlideShow ppt = new XMLSlideShow(blob.getStream());){
            if (slideNumber < 0 || slideNumber >= ppt.getSlides().size()) {
                throw new NuxeoException("Invalid slide number: " + slideNumber);
            }
            result = Blobs.createBlobWithExtension((String)".pptx");
            File newFile = result.getFile();
            FileUtils.copyFile((File)originalFile, (File)newFile);
            try (FileInputStream is = new FileInputStream(newFile);
                 XMLSlideShow copy = new XMLSlideShow((InputStream)is);){
                for (int iBefore = 0; iBefore < slideNumber; ++iBefore) {
                    copy.removeSlide(0);
                }
                int tempSlidesCount = copy.getSlides().size();
                for (int iAfter = 1; iAfter < tempSlidesCount; ++iAfter) {
                    copy.removeSlide(1);
                }
                try (FileOutputStream out = new FileOutputStream(newFile);){
                    copy.write((OutputStream)out);
                }
                result.setMimeType(pptMimeType);
                String fileNameBase = blob.getFilename();
                fileNameBase = FilenameUtils.getBaseName((String)fileNameBase);
                fileNameBase = StringUtils.appendIfMissing((String)fileNameBase, (CharSequence)"-", (CharSequence[])new CharSequence[0]);
                result.setFilename(fileNameBase + (slideNumber + 1) + ".pptx");
            }
        }
        return result;
    }

    @Override
    public Blob getSlide(DocumentModel input, String xpath, int slideNumber) throws IOException {
        return this.getSlide(PowerPointUtils.getBlob(input, xpath), slideNumber);
    }

    @Override
    public BlobList getThumbnails(Blob blob, int maxWidth, String format, boolean onlyVisible) throws IOException {
        BlobList result = new BlobList();
        if (blob == null) {
            return null;
        }
        try (XMLSlideShow ppt = new XMLSlideShow(blob.getStream());){
            for (XSLFSlide slide : ppt.getSlides()) {
                if (onlyVisible && slide.getXmlObject().isSetShow() && !slide.getXmlObject().getShow()) continue;
                Blob thumb = this.getThumbnail(slide, maxWidth, format);
                result.add((Object)thumb);
            }
        }
        return result;
    }

    @Override
    public BlobList getThumbnails(DocumentModel doc, String xpath, int maxWidth, String format, boolean onlyVisible) throws IOException {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            xpath = "file:content";
        }
        Blob blob = (Blob)doc.getPropertyValue(xpath);
        BlobList blobs = this.getThumbnails(blob, maxWidth, format, onlyVisible);
        return blobs;
    }

    @Override
    public Blob getThumbnail(Blob blob, int slideNumber, int maxWidth, String format) throws IOException {
        Blob result = null;
        if (blob == null) {
            return result;
        }
        try (XMLSlideShow ppt = new XMLSlideShow(blob.getStream());){
            result = this.getThumbnail((XSLFSlide)ppt.getSlides().get(slideNumber), maxWidth, format);
        }
        return result;
    }

    @Override
    public Blob getThumbnail(DocumentModel doc, String xpath, int slideNumber, int maxWidth, String format) throws IOException {
        return this.getThumbnail(PowerPointUtils.getBlob(doc, xpath), slideNumber, maxWidth, format);
    }

    public Map<String, XSLFSlideMaster> getSlideMasters(XMLSlideShow slideShow) {
        HashMap<String, XSLFSlideMaster> namesAndMasters = new HashMap<String, XSLFSlideMaster>();
        for (XSLFSlideMaster master : slideShow.getSlideMasters()) {
            for (XSLFSlideLayout layout : master.getSlideLayouts()) {
                namesAndMasters.put(layout.getName(), master);
            }
        }
        return namesAndMasters;
    }

    @Override
    public Blob renderWithTemplate(DocumentModel doc, Blob template, String newFileName) throws Exception {
        Blob result = null;
        File templateFile = template.getFile();
        result = Blobs.createBlobWithExtension((String)".pptx");
        File resultFile = result.getFile();
        try (FileInputStream is = new FileInputStream(templateFile.getAbsolutePath());
             FileOutputStream os = new FileOutputStream(resultFile.getAbsolutePath());){
            try (XMLSlideShow ppt = new XMLSlideShow((InputStream)is);){
                for (XSLFSlide slide : ppt.getSlides()) {
                    for (XSLFShape shape : slide.getShapes()) {
                        XSLFTextShape textShape;
                        String text;
                        String newText;
                        if (!(shape instanceof XSLFTextShape) || (newText = this.replaceText(text = (textShape = (XSLFTextShape)shape).getText(), doc)).equals(text)) continue;
                        textShape.setText(newText);
                    }
                }
                ppt.write((OutputStream)os);
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (newFileName == null) {
            newFileName = template.getFilename();
        }
        if (newFileName == null) {
            newFileName = doc.getTitle();
        }
        if (!StringUtils.endsWithIgnoreCase((CharSequence)newFileName, (CharSequence)".pptx")) {
            newFileName = (String)newFileName + ".pptx";
        }
        result.setFilename((String)newFileName);
        result.setMimeType("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        return result;
    }

    protected String replaceText(String text, DocumentModel doc) throws OperationException, RenderingException, TemplateException, IOException {
        OperationContext ctx = new OperationContext(doc.getCoreSession());
        ctx.setInput((Object)doc);
        ctx.put("doc", (Object)doc);
        String newText = RenderingService.getInstance().render("ftl", text, ctx);
        return newText;
    }

    protected Blob getThumbnail(XSLFSlide slide, int maxWidth, String format) throws IOException {
        String mimeType;
        Blob result = null;
        if (slide == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            format = "png";
        }
        switch (format.toLowerCase()) {
            case "jpg": 
            case "jpeg": {
                format = "jpg";
                mimeType = "image/jpeg";
                break;
            }
            case "png": {
                mimeType = "image/png";
                break;
            }
            default: {
                throw new NuxeoException(format + " is no a supported formats (only jpg or png)");
            }
        }
        Dimension pgsize = slide.getSlideShow().getPageSize();
        int width = pgsize.width;
        int height = pgsize.height;
        float scale = 1.0f;
        if (maxWidth > 0 && maxWidth < width) {
            scale = (float)maxWidth / (float)width;
            width = maxWidth;
            height = (int)((float)height * scale);
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.scale(scale, scale);
        slide.draw(graphics);
        result = Blobs.createBlobWithExtension((String)("." + format));
        ImageIO.write((RenderedImage)img, format, result.getFile());
        result.setMimeType(mimeType);
        result.setFilename("Slide " + slide.getSlideNumber() + "." + format);
        return result;
    }
}

