/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.powerpoint.utils.api;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.mimetype.MimetypeDetectionException;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.runtime.api.Framework;

public interface PowerPointUtils {
    public static final String PPTX_MIMETYPE = "application/vnd.openxmlformats-officedocument.presentationml.presentation";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");

    public JSONObject getProperties(Blob var1);

    public BlobList splitPresentation(Blob var1) throws IOException;

    public BlobList splitPresentation(DocumentModel var1, String var2) throws IOException;

    public Blob merge(BlobList var1, boolean var2, String var3);

    public Blob merge(DocumentModelList var1, String var2, boolean var3, String var4);

    public Blob getSlide(Blob var1, int var2) throws IOException;

    public Blob getSlide(DocumentModel var1, String var2, int var3) throws IOException;

    public BlobList getThumbnails(Blob var1, int var2, String var3, boolean var4) throws IOException;

    public BlobList getThumbnails(DocumentModel var1, String var2, int var3, String var4, boolean var5) throws IOException;

    public Blob getThumbnail(Blob var1, int var2, int var3, String var4) throws IOException;

    public Blob getThumbnail(DocumentModel var1, String var2, int var3, int var4, String var5) throws IOException;

    public Blob renderWithTemplate(DocumentModel var1, Blob var2, String var3) throws Exception;

    public static String getBlobMimeType(Blob blob) {
        if (blob == null) {
            throw new NullPointerException();
        }
        String mimeType = blob.getMimeType();
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            return mimeType;
        }
        MimetypeRegistryService service = (MimetypeRegistryService)Framework.getService(MimetypeRegistry.class);
        try {
            mimeType = service.getMimetypeFromBlob(blob);
        }
        catch (MimetypeDetectionException | MimetypeNotFoundException e1) {
            try {
                mimeType = service.getMimetypeFromFile(blob.getFile());
            }
            catch (MimetypeDetectionException | MimetypeNotFoundException e2) {
                throw new NuxeoException("Cannot get a Mime Type from the blob or the file", e2);
            }
        }
        return mimeType;
    }

    public static String checkMergedFileName(String fileName) {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return "merged.pptx";
        }
        if (!fileName.toLowerCase().endsWith(".pptx")) {
            return fileName + ".pptx";
        }
        return fileName;
    }

    public static Blob getBlob(DocumentModel doc, String xpath) {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            xpath = "file:content";
        }
        return (Blob)doc.getPropertyValue(xpath);
    }
}

