/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.powerpoint.utils.aspose;

import com.aspose.slides.IAutoShape;
import com.aspose.slides.IFontData;
import com.aspose.slides.ILayoutSlide;
import com.aspose.slides.IMasterLayoutSlideCollection;
import com.aspose.slides.IMasterSlide;
import com.aspose.slides.IMasterSlideCollection;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IShape;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideCollection;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.License;
import com.aspose.slides.Presentation;
import freemarker.template.TemplateException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import nuxeo.powerpoint.utils.apachepoi.PowerPointUtilsWithApachePOI;
import nuxeo.powerpoint.utils.api.PowerPointUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.rendering.RenderingService;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;

public class PowerPointUtilsWithAspose
implements PowerPointUtils {
    @Override
    public JSONObject getProperties(Blob blob) {
        PowerPointUtilsWithApachePOI pptPoi = new PowerPointUtilsWithApachePOI();
        JSONObject obj = pptPoi.getProperties(blob);
        try {
            JSONArray arr;
            Presentation pres = new Presentation(blob.getStream());
            if (!obj.has("Fonts")) {
                arr = new JSONArray();
                obj.put("Fonts", (Object)arr);
            } else {
                arr = obj.getJSONArray("Fonts");
            }
            if (obj.getJSONArray("Fonts").length() == 0) {
                for (IFontData font : pres.getFontsManager().getFonts()) {
                    arr.put((Object)font.getFontName());
                }
            }
        }
        catch (IOException | JSONException e) {
            throw new NuxeoException(e);
        }
        return obj;
    }

    @Override
    public BlobList splitPresentation(Blob blob) throws IOException {
        BlobList result = new BlobList();
        if (blob == null) {
            return result;
        }
        try {
            Presentation pres = new Presentation(blob.getStream());
            int slidesCount = pres.getSlides().size();
            for (int i = 0; i < slidesCount; ++i) {
                Blob oneSlidePres = this.getSlide(blob, i);
                result.add((Object)oneSlidePres);
            }
        }
        catch (IOException | NuxeoException e) {
            throw new NuxeoException(e);
        }
        return result;
    }

    @Override
    public BlobList splitPresentation(DocumentModel input, String xpath) throws IOException {
        BlobList blobs = this.splitPresentation(PowerPointUtils.getBlob(input, xpath));
        return blobs;
    }

    @Override
    public Blob merge(BlobList blobs, boolean reuseMasters, String fileName) {
        Blob result = null;
        fileName = PowerPointUtils.checkMergedFileName(fileName);
        Presentation destPres = new Presentation();
        while (destPres.getSlides().size() > 0) {
            destPres.getSlides().removeAt(0);
        }
        destPres.getMasters().removeUnused(true);
        try {
            for (Blob b : blobs) {
                Presentation toMerge = new Presentation(b.getStream());
                if (toMerge == null) continue;
                ISlideCollection slidesColl = toMerge.getSlides();
                slidesColl.forEach(slide -> {
                    String slideTheme = slide.getLayoutSlide().getMasterSlide().getName();
                    String slideLayout = slide.getLayoutSlide().getName();
                    IMasterSlide masterToUse = null;
                    if (reuseMasters) {
                        IMasterSlideCollection masterColl = destPres.getMasters();
                        block0: for (int i = 0; i < masterColl.size(); ++i) {
                            IMasterSlide master = masterColl.get_Item(i);
                            if (master == null || master.getName() == null || !master.getName().equals(slideTheme)) continue;
                            IMasterLayoutSlideCollection layoutMasterColl = master.getLayoutSlides();
                            for (int j = 0; j < layoutMasterColl.size(); ++j) {
                                ILayoutSlide layoutMaster = layoutMasterColl.get_Item(j);
                                if (!layoutMaster.getName().equals(slideLayout)) continue;
                                masterToUse = master;
                                continue block0;
                            }
                        }
                    }
                    if (masterToUse == null) {
                        destPres.getSlides().addClone(slide);
                    } else {
                        destPres.getSlides().addClone(slide, masterToUse, true);
                    }
                });
            }
            result = Blobs.createBlobWithExtension((String)".pptx");
            destPres.save(result.getFile().getAbsolutePath(), 3);
            result.setFilename(fileName);
            result.setMimeType("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to merge PowerPoint persentations.", (Throwable)e);
        }
        return result;
    }

    @Override
    public Blob merge(DocumentModelList docs, String xpath, boolean reuseMasters, String fileName) {
        if (StringUtils.isBlank((CharSequence)xpath)) {
            xpath = "file:content";
        }
        BlobList blobs = new BlobList();
        for (DocumentModel doc : docs) {
            blobs.add((Object)PowerPointUtils.getBlob(doc, xpath));
        }
        return this.merge(blobs, reuseMasters, fileName);
    }

    @Override
    public Blob getSlide(Blob blob, int slideNumber) throws IOException {
        Blob result = null;
        if (blob == null) {
            return result;
        }
        String pptMimeType = PowerPointUtils.getBlobMimeType(blob);
        try {
            Presentation pres = new Presentation(blob.getStream());
            Presentation destPres = new Presentation();
            while (destPres.getSlides().size() > 0) {
                destPres.getSlides().removeAt(0);
            }
            destPres.getMasters().removeUnused(true);
            ISlideCollection slds = destPres.getSlides();
            slds.addClone(pres.getSlides().get_Item(slideNumber));
            result = Blobs.createBlobWithExtension((String)".pptx");
            destPres.save(result.getFile().getAbsolutePath(), 3);
            result.setMimeType(pptMimeType);
            String fileNameBase = blob.getFilename();
            fileNameBase = FilenameUtils.getBaseName((String)fileNameBase);
            fileNameBase = StringUtils.appendIfMissing((String)fileNameBase, (CharSequence)"-", (CharSequence[])new CharSequence[0]);
            result.setFilename(fileNameBase + (slideNumber + 1) + ".pptx");
        }
        catch (IOException e) {
            throw new NuxeoException("Failed to get slide #" + (slideNumber - 1), (Throwable)e);
        }
        return result;
    }

    @Override
    public Blob getSlide(DocumentModel input, String xpath, int slideNumber) throws IOException {
        return this.getSlide(PowerPointUtils.getBlob(input, xpath), slideNumber);
    }

    @Override
    public BlobList getThumbnails(Blob blob, int maxWidth, String format, boolean onlyVisible) throws IOException {
        BlobList result = new BlobList();
        if (blob == null) {
            return result;
        }
        try {
            Presentation pres = new Presentation(blob.getStream());
            int slidesCount = pres.getSlides().size();
            for (int i = 0; i < slidesCount; ++i) {
                ISlide slide = pres.getSlides().get_Item(i);
                if (onlyVisible && slide.getHidden()) continue;
                Blob thumb = this.getThumbnail(slide, maxWidth, format);
                result.add((Object)thumb);
            }
        }
        catch (IOException e) {
            throw new NuxeoException("Failed gerenate thumbnails.", (Throwable)e);
        }
        return result;
    }

    @Override
    public BlobList getThumbnails(DocumentModel doc, String xpath, int maxWidth, String format, boolean onlyVisible) throws IOException {
        BlobList blobs = this.getThumbnails(PowerPointUtils.getBlob(doc, xpath), maxWidth, format, onlyVisible);
        return blobs;
    }

    @Override
    public Blob getThumbnail(Blob blob, int slideNumber, int maxWidth, String format) throws IOException {
        Blob result = null;
        if (blob == null) {
            return result;
        }
        try {
            Presentation pres = new Presentation(blob.getStream());
            ISlide slide = pres.getSlides().get_Item(slideNumber);
            result = this.getThumbnail(slide, maxWidth, format);
        }
        catch (IOException e) {
            throw new NuxeoException("Failed gerenate thumbnails.", (Throwable)e);
        }
        return result;
    }

    @Override
    public Blob getThumbnail(DocumentModel doc, String xpath, int slideNumber, int maxWidth, String format) throws IOException {
        return this.getThumbnail(PowerPointUtils.getBlob(doc, xpath), slideNumber, maxWidth, format);
    }

    public static void setLicense(String pathToLicenseFile) {
        License license = new License();
        license.setLicense(pathToLicenseFile);
    }

    @Override
    public Blob renderWithTemplate(DocumentModel doc, Blob template, String newFileName) throws Exception {
        Blob result = null;
        result = Blobs.createBlobWithExtension((String)".pptx");
        File resultFile = result.getFile();
        try {
            Presentation pres = new Presentation(template.getStream());
            ISlideCollection slides = pres.getSlides();
            for (ISlide slide : slides) {
                for (IShape shape : slide.getShapes()) {
                    ITextFrame textFrame;
                    if (!(shape instanceof IAutoShape) || (textFrame = ((IAutoShape)shape).getTextFrame()) == null) continue;
                    for (IParagraph para : textFrame.getParagraphs()) {
                        String text = para.getText();
                        String newText = this.replaceText(text, doc);
                        if (newText.equals(text)) continue;
                        para.setText(newText);
                    }
                }
            }
            pres.save(resultFile.getAbsolutePath(), 3);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (newFileName == null) {
            newFileName = template.getFilename();
        }
        if (newFileName == null) {
            newFileName = doc.getTitle();
        }
        if (!StringUtils.endsWithIgnoreCase((CharSequence)newFileName, (CharSequence)".pptx")) {
            newFileName = (String)newFileName + ".pptx";
        }
        result.setFilename((String)newFileName);
        result.setMimeType("application/vnd.openxmlformats-officedocument.presentationml.presentation");
        return result;
    }

    protected String replaceText(String text, DocumentModel doc) throws OperationException, RenderingException, TemplateException, IOException {
        OperationContext ctx = new OperationContext(doc.getCoreSession());
        ctx.setInput((Object)doc);
        ctx.put("doc", (Object)doc);
        String newText = RenderingService.getInstance().render("ftl", text, ctx);
        return newText;
    }

    protected Blob getThumbnail(ISlide slide, int maxWidth, String format) throws IOException {
        String mimeType;
        Blob result = null;
        if (slide == null) {
            return result;
        }
        if (StringUtils.isBlank((CharSequence)format)) {
            format = "png";
        }
        switch (format.toLowerCase()) {
            case "jpg": 
            case "jpeg": {
                format = "jpg";
                mimeType = "image/jpeg";
                break;
            }
            case "png": {
                mimeType = "image/png";
                break;
            }
            default: {
                throw new NuxeoException(format + " is no a supported formats (only jpg or png)");
            }
        }
        double width = slide.getPresentation().getSlideSize().getSize().getWidth();
        double height = slide.getPresentation().getSlideSize().getSize().getHeight();
        float scale = 1.0f;
        if (maxWidth > 0 && (double)maxWidth < width) {
            scale = (float)((double)maxWidth / width);
            width = maxWidth;
            height = (int)(height * (double)scale);
        }
        BufferedImage img = slide.getThumbnail(scale, scale);
        result = Blobs.createBlobWithExtension((String)("." + format));
        ImageIO.write((RenderedImage)img, format, result.getFile());
        result.setMimeType(mimeType);
        result.setFilename("Slide " + slide.getSlideNumber() + "." + format);
        return result;
    }
}

