/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.powerpoint.utils.operations;

import java.io.IOException;
import nuxeo.powerpoint.utils.apachepoi.PowerPointUtilsWithApachePOI;
import nuxeo.powerpoint.utils.aspose.PowerPointUtilsWithAspose;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Conversion.PowerPointGetThumbnails", category="Conversion", label="PowerPoint: Get Thumbnails", description="return a BlobList of thumbnails, one/slide. format can be \"jpg\" or \"png\". maxWidth allows for returning smaller images. Any value <= 0 returns the images in the original dimension. If onlyVisible is true, thumbnails are returned only for visible slides. useAspose tells the operation to use Aspose for the rendition. Default is Apache POI. Slides rendered with Aspose usually have a better quality. Each blob will be named {original-file-name}-{slideNumber + 1}.{format}. SO even if slideNumber is zeroBased, output will start at 1 for better end user experience.")
public class GetThumbnailsOp {
    public static final String ID = "Conversion.PowerPointGetThumbnails";
    @Param(name="xpath", required=false, values={"file:content"})
    protected String xpath;
    @Param(name="useAspose", required=false)
    protected Boolean useAspose = false;
    @Param(name="maxWidth", required=false)
    protected Integer maxWidth = 0;
    @Param(name="format", widget="Option", required=false, values={"jpeg", "png"})
    protected String format = "png";
    @Param(name="onlyVisible", required=false)
    protected Boolean onlyVisible = false;

    @OperationMethod
    public BlobList run(DocumentModel doc) throws IOException {
        BlobList result;
        if (this.useAspose.booleanValue()) {
            PowerPointUtilsWithAspose asposePptUtils = new PowerPointUtilsWithAspose();
            result = asposePptUtils.getThumbnails(doc, this.xpath, this.maxWidth, this.format, this.onlyVisible);
        } else {
            PowerPointUtilsWithApachePOI pptUtils = new PowerPointUtilsWithApachePOI();
            result = pptUtils.getThumbnails(doc, this.xpath, this.maxWidth, this.format, this.onlyVisible);
        }
        return result;
    }

    @OperationMethod
    public BlobList run(Blob blob) throws IOException {
        BlobList result;
        if (this.useAspose.booleanValue()) {
            PowerPointUtilsWithAspose asposePptUtils = new PowerPointUtilsWithAspose();
            result = asposePptUtils.getThumbnails(blob, this.maxWidth, this.format, this.onlyVisible);
        } else {
            PowerPointUtilsWithApachePOI pptUtils = new PowerPointUtilsWithApachePOI();
            result = pptUtils.getThumbnails(blob, this.maxWidth, this.format, this.onlyVisible);
        }
        return result;
    }
}

