/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.powerpoint.utils.operations;

import nuxeo.powerpoint.utils.apachepoi.PowerPointUtilsWithApachePOI;
import nuxeo.powerpoint.utils.api.PowerPointUtils;
import nuxeo.powerpoint.utils.aspose.PowerPointUtilsWithAspose;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Conversion.RenderDocumentWithPowerPointTemplate", category="Conversion", label="PowerPoint: Render Document with Template", description="Create a pptx from the template and the input doc. The template parameter is required, it is a blob holding a .pptx slides deck. Inside this template, add FreeMarker expressions, such as ${doc[\"schma:field\"]} The operation replaces the values and returns a new blob. WARNING: an expression must be set on a single ligne. create a new text block in PowerPoint if needed. If fileName is empty, the returned blob will have the name of the template. useAspose tells the operation to use Aspose for the rendition. Default is Apache POI.")
public class RenderWithTemplateOp {
    public static final String ID = "Conversion.RenderDocumentWithPowerPointTemplate";
    @Param(name="templateBlob", required=true)
    protected Blob templateBlob;
    @Param(name="fileName", required=false)
    protected String fileName = null;
    @Param(name="useAspose", required=false)
    protected Boolean useAspose = false;

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        PowerPointUtils pptUtils = this.useAspose != false ? new PowerPointUtilsWithAspose() : new PowerPointUtilsWithApachePOI();
        Blob result = pptUtils.renderWithTemplate(doc, this.templateBlob, this.fileName);
        return result;
    }
}

