/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.cu;
import com.aspose.slides.ms.System.fc;
import com.aspose.slides.ms.System.i7;
import com.aspose.slides.ms.System.mz;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@fc
public class ArrayList
implements IList,
List {
    private Object[] kg;
    private int pr;
    private int k7;
    private static Object[] a5 = new Object[0];

    protected int getVersion() {
        return this.k7;
    }

    public ArrayList() {
        this.kg = new Object[4];
    }

    public ArrayList(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c", "collection is null");
        }
        this.kg = new Object[c.size()];
        this.addRange(c);
    }

    public ArrayList(int capacity) {
        if (capacity < 0) {
            ArrayList.kg("capacity", (Object)capacity, "The initial capacity can't be smaller than zero.");
        }
        if (capacity == 0) {
            capacity = 4;
        }
        this.kg = new Object[capacity];
    }

    private ArrayList(int initialCapacity, boolean forceZeroSize) {
        if (!forceZeroSize) {
            throw new IllegalStateException("Use ArrayList(int)");
        }
        this.kg = null;
    }

    private ArrayList(a5 array, int index, int count) {
        this.kg = count == 0 ? new Object[4] : new Object[count];
        com.aspose.slides.ms.System.a5.kg(array, index, com.aspose.slides.ms.System.a5.kg(this.kg), 0, count);
        this.pr = count;
    }

    @Override
    public Object get_Item(int index) {
        if (index < 0 || index >= this.pr) {
            ArrayList.kg("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        return this.kg[index];
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index < 0 || index >= this.pr) {
            ArrayList.kg("index", (Object)index, "Index is less than 0 or more than or equal to the list count.");
        }
        this.kg[index] = value;
        ++this.k7;
    }

    @Override
    public int size() {
        return this.pr;
    }

    public int getCapacity() {
        return this.kg.length;
    }

    public void setCapacity(int value) {
        if (value < this.pr) {
            ArrayList.kg("Capacity", (Object)value, "Must be more than count.");
        }
        this.kg = value > 0 ? Arrays.copyOf(this.kg, value) : new Object[4];
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    private void kg(int n) {
        int n10;
        if (n <= this.kg.length) {
            return;
        }
        int n11 = n10 = this.kg.length == 0 ? 4 : this.kg.length * 2;
        if (n10 < n) {
            n10 = n;
        }
        this.setCapacity(n10);
    }

    private void kg(int n, int n10) {
        if (n10 > 0) {
            if (this.pr + n10 > this.kg.length) {
                int n11;
                int n12 = n11 = this.kg.length > 0 ? this.kg.length << 1 : 1;
                while (n11 < this.pr + n10) {
                    n11 <<= 1;
                }
                Object[] objectArray = new Object[n11];
                com.aspose.slides.ms.System.a5.kg(this.kg, 0, objectArray, 0, n);
                com.aspose.slides.ms.System.a5.kg(this.kg, n, objectArray, n + n10, this.pr - n);
                this.kg = objectArray;
            } else {
                com.aspose.slides.ms.System.a5.kg(this.kg, n, this.kg, n + n10, this.pr - n);
            }
        } else if (n10 < 0) {
            int n13 = n - n10;
            com.aspose.slides.ms.System.a5.kg(this.kg, n13, this.kg, n, this.pr - n13);
            com.aspose.slides.ms.System.a5.kg(this.kg, this.pr + n10, -n10);
        }
    }

    @Override
    public int addItem(Object value) {
        if (this.kg.length <= this.pr) {
            this.kg(this.pr + 1);
        }
        this.kg[this.pr] = value;
        ++this.k7;
        return this.pr++;
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.a5.kg(this.kg, 0, this.pr);
        this.pr = 0;
        ++this.k7;
    }

    @Override
    public boolean contains(Object item) {
        return this.indexOf(item, 0, this.pr) > -1;
    }

    boolean kg(Object object, int n, int n10) {
        return this.indexOf(object, n, n10) > -1;
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, 0);
    }

    public int indexOf(Object value, int startIndex) {
        return this.indexOf(value, startIndex, this.pr - startIndex);
    }

    public int indexOf(Object value, int startIndex, int count) {
        if (startIndex < 0 || startIndex > this.pr) {
            ArrayList.kg("startIndex", (Object)startIndex, "Does not specify valid index.");
        }
        if (count < 0) {
            ArrayList.kg("count", (Object)count, "Can't be less than 0.");
        }
        if (startIndex > this.pr - count) {
            throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
        }
        return com.aspose.slides.ms.System.a5.kg(this.kg, value, startIndex, count);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.lastIndexOf(value, this.pr - 1);
    }

    public int lastIndexOf(Object value, int startIndex) {
        return this.lastIndexOf(value, startIndex, startIndex + 1);
    }

    public int lastIndexOf(Object value, int startIndex, int count) {
        return mz.kg(this.kg, value, startIndex, count);
    }

    @Override
    public void insertItem(int index, Object value) {
        if (index < 0 || index > this.pr) {
            ArrayList.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        this.kg(index, 1);
        this.kg[index] = value;
        ++this.pr;
        ++this.k7;
    }

    public void insertRange(int index, ICollection c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.pr) {
            ArrayList.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.size()) > 0) {
            if (this.kg.length < this.pr + n) {
                this.kg(this.pr + n);
            }
            if (index < this.pr) {
                com.aspose.slides.ms.System.a5.kg(this.kg, index, this.kg, index + n, this.pr - index);
            }
            if (this == c.getSyncRoot()) {
                com.aspose.slides.ms.System.a5.kg(this.kg, 0, this.kg, index, index);
                com.aspose.slides.ms.System.a5.kg(this.kg, index + n, this.kg, index << 1, this.pr - index);
            } else {
                c.copyTo(com.aspose.slides.ms.System.a5.kg(this.kg), index);
            }
            this.pr += c.size();
            ++this.k7;
        }
    }

    public void insertRange(int index, Object[] c) {
        int n;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index > this.pr) {
            ArrayList.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
        }
        if ((n = c.length) > 0) {
            if (this.kg.length < this.pr + n) {
                this.kg(this.pr + n);
            }
            if (index < this.pr) {
                com.aspose.slides.ms.System.a5.kg(this.kg, index, this.kg, index + n, this.pr - index);
            }
            com.aspose.slides.ms.System.a5.kg(c).copyTo(com.aspose.slides.ms.System.a5.kg(this.kg), index);
            this.pr += c.length;
            ++this.k7;
        }
    }

    @Override
    public void removeItem(Object obj) {
        int n = this.indexOf(obj);
        if (n > -1) {
            this.removeAt(n);
        }
        ++this.k7;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || index >= this.pr) {
            ArrayList.kg("index", (Object)index, "Less than 0 or more than list count.");
        }
        this.kg(index, -1);
        --this.pr;
        ++this.k7;
    }

    public void removeRange(int index, int count) {
        ArrayList.kg(index, count, this.pr);
        this.kg(index, -count);
        this.pr -= count;
        ++this.k7;
    }

    public void reverse() {
        mz.kg(this.kg, 0, this.pr);
        ++this.k7;
    }

    public void reverse(int index, int count) {
        ArrayList.kg(index, count, this.pr);
        mz.kg(this.kg, index, count);
        ++this.k7;
    }

    public void copyTo(a5 array) {
        com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg), 0, array, 0, this.pr);
    }

    @Override
    public void copyTo(a5 array, int arrayIndex) {
        this.copyTo(0, array, arrayIndex, this.pr);
    }

    public void copyTo(int index, a5 array, int arrayIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.a5() != 1) {
            throw new ArgumentException("Must have only 1 dimensions.", "array");
        }
        com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg), index, array, arrayIndex, count);
    }

    @Override
    public IEnumerator iterator() {
        return new SimpleEnumerator(this);
    }

    public IEnumerator iterator(int index, int count) {
        ArrayList.kg(index, count, this.pr);
        return new ArrayListEnumerator(this, index, count);
    }

    public void addRange(ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.pr, c);
    }

    public void addRange(Object[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("c");
        }
        this.insertRange(this.pr, collection);
    }

    public int binarySearch(Object value) {
        if (value == null) {
            return -1;
        }
        try {
            return mz.kg(this.kg, 0, this.pr, value);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(Object value, Comparator comparer) {
        try {
            return mz.kg(this.kg, 0, this.pr, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public int binarySearch(int index, int count, Object value, Comparator comparer) {
        try {
            return mz.kg(this.kg, index, count, value, comparer);
        }
        catch (InvalidOperationException invalidOperationException) {
            throw new ArgumentException(invalidOperationException.getMessage());
        }
    }

    public ArrayList getRange(int index, int count) {
        ArrayList.kg(index, count, this.pr);
        if (this.isSynchronized()) {
            return ArrayList.sync(new RangedArrayList(this, index, count));
        }
        return new RangedArrayList(this, index, count);
    }

    public void setRange(int index, ICollection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        if (index < 0 || index + c.size() > this.pr) {
            throw new ArgumentOutOfRangeException("index");
        }
        c.copyTo(com.aspose.slides.ms.System.a5.kg(this.kg), index);
        ++this.k7;
    }

    public void trimToSize() {
        this.setCapacity(this.pr);
    }

    public void sort() {
        Arrays.sort(this.kg, 0, this.pr, Comparer.Default);
        ++this.k7;
    }

    public void sort(Comparator comparer) {
        Arrays.sort(this.kg, 0, this.pr, comparer);
    }

    public void sort(int index, int count, Comparator comparer) {
        ArrayList.kg(index, count, this.pr);
        Arrays.sort(this.kg, index, index + count, comparer);
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.pr];
        this.copyTo(com.aspose.slides.ms.System.a5.kg(objectArray));
        return objectArray;
    }

    public a5 toArray(i7 type) {
        a5 a52 = com.aspose.slides.ms.System.a5.kg(type, this.pr);
        this.copyTo(a52);
        return a52;
    }

    public Object deepClone() {
        return new ArrayList(com.aspose.slides.ms.System.a5.kg(this.kg), 0, this.pr);
    }

    static void kg(int n, int n10, int n11) {
        if (n < 0) {
            ArrayList.kg("index", (Object)n, "Can't be less than 0.");
        }
        if (n10 < 0) {
            ArrayList.kg("count", (Object)n10, "Can't be less than 0.");
        }
        if (n > n11 - n10) {
            throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
        }
    }

    static void kg(String string, Object object, String string2) {
        throw new ArgumentOutOfRangeException(string, object, string2);
    }

    public static ArrayList adapter(IList list) {
        ArrayList arrayList;
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        ArrayList arrayList2 = arrayList = list instanceof ArrayList ? (ArrayList)list : null;
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayListAdapter(list);
        if (list.isSynchronized()) {
            return ArrayList.sync(arrayList);
        }
        return arrayList;
    }

    public static ArrayList sync(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedArrayListWrapper(list);
    }

    public static IList sync(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isSynchronized()) {
            return list;
        }
        return new SynchronizedListWrapper(list);
    }

    public static ArrayList readOnly(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyArrayListWrapper(list);
    }

    public static IList readOnly(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isReadOnly()) {
            return list;
        }
        return new ReadOnlyListWrapper(list);
    }

    public static ArrayList fixedSize(ArrayList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeArrayListWrapper(list);
    }

    public static IList fixedSize(IList list) {
        if (list == null) {
            throw new ArgumentNullException("list");
        }
        if (list.isFixedSize()) {
            return list;
        }
        return new FixedSizeListWrapper(list);
    }

    public static ArrayList repeat(Object value, int count) {
        ArrayList arrayList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            arrayList.addItem(value);
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length <= this.size()) {
            a = new Object[this.size()];
        }
        this.copyTo(com.aspose.slides.ms.System.a5.kg(a));
        return a;
    }

    @Override
    public boolean add(Object o) {
        int n = this.size();
        this.addItem(o);
        return this.size() != n;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.size();
        this.removeItem(o);
        return this.size() != n;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        return this.addAll(this.pr, c);
    }

    public boolean addAll(int index, Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = index;
        int n10 = this.size();
        for (Object e : c) {
            this.insertItem(n++, e);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object e : c) {
            this.removeItem(e);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection c) {
        Object[] objectArray;
        if (c == null) {
            throw new ArgumentNullException("c");
        }
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    public Object get(int index) {
        return this.get_Item(index);
    }

    public Object set(int index, Object element) {
        Object object = this.get_Item(index);
        this.set_Item(index, element);
        return object;
    }

    public void add(int index, Object element) {
        this.insertItem(index, element);
    }

    public Object remove(int index) {
        Object object = this.get_Item(index);
        this.removeAt(index);
        return object;
    }

    public ListIterator listIterator() {
        return new ListItr(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    public List subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static ArrayList fromJava(List list) {
        if (list == null) {
            return null;
        }
        return new ArrayListInternalized(list);
    }

    public static List toJava(ArrayList list) {
        return list;
    }

    private static class ArrayListInternalized
    extends ArrayList {
        private List kg;
        private int pr;

        @Override
        protected int getVersion() {
            return this.kg instanceof ArrayList ? ((ArrayList)this.kg).getVersion() : this.pr;
        }

        public ArrayListInternalized(List internal) {
            this.kg = internal;
            if (internal instanceof ArrayList) {
                this.pr = ((ArrayList)internal).getVersion();
            }
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.get(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.kg.set(index, value);
            ++this.pr;
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public int getCapacity() {
            return Math.max(super.getCapacity(), this.kg.size());
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.kg.size()) {
                throw new ArgumentOutOfRangeException("Capacity", value, "Must be more than count.");
            }
            for (int i = 0; i < value - this.kg.size(); ++i) {
                this.kg.add(null);
            }
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public int addItem(Object value) {
            int n = this.kg.size();
            this.kg.add(value);
            ++this.pr;
            return n;
        }

        @Override
        public void clear() {
            this.kg.clear();
            ++this.pr;
        }

        @Override
        public boolean contains(Object item) {
            return this.kg.contains(item);
        }

        @Override
        public int indexOf(Object value) {
            return this.kg.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.kg.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.kg.size()) {
                throw new ArgumentOutOfRangeException("startIndex", startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (startIndex > this.kg.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            return com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.kg.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return mz.kg(this.kg.toArray(), value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            if (index < 0 || index > this.kg.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.kg.add(index, value);
            ++this.pr;
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.kg.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.kg.add(index++, e);
            }
            ++this.pr;
        }

        @Override
        public void insertRange(int index, Object[] c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index > this.kg.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            for (Object object : c) {
                this.kg.add(index++, object);
            }
            ++this.pr;
        }

        @Override
        public void removeItem(Object obj) {
            this.kg.remove(obj);
            ++this.pr;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || index > this.kg.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            this.kg.remove(index);
            ++this.pr;
        }

        @Override
        public void removeRange(int index, int count) {
            if (index < 0 || index > this.kg.size()) {
                throw new ArgumentOutOfRangeException("index", index, "Index must be >= 0 and <= Count.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.kg.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                this.kg.remove(index);
            }
            ++this.pr;
        }

        @Override
        public void reverse() {
            this.reverse(0, this.kg.size());
        }

        @Override
        public void reverse(int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.kg.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            int n = index;
            for (int i = index + this.kg.size() - 1; n < i; ++n, --i) {
                Object e = this.kg.get(n);
                this.kg.set(n, this.kg.get(i));
                this.kg.set(i, e);
            }
            ++this.pr;
        }

        @Override
        public void copyTo(a5 array) {
            com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg.toArray()), 0, array, 0, this.kg.size());
        }

        @Override
        public void copyTo(a5 array, int arrayIndex) {
            this.copyTo(0, array, arrayIndex, this.kg.size());
        }

        @Override
        public void copyTo(int index, a5 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.a5() != 1) {
                throw new ArgumentException("Must have only 1 dimensions.", "array");
            }
            com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg.toArray()), index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return new SimpleEnumerator(this);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayList.kg(index, count, this.kg.size());
            return new ArrayListEnumerator(this, index, count);
        }

        @Override
        public void addRange(ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.size(), c);
        }

        @Override
        public void addRange(Object[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("c");
            }
            this.insertRange(this.kg.size(), collection);
        }

        @Override
        public int binarySearch(Object value) {
            if (value == null) {
                return -1;
            }
            try {
                return mz.kg(this.kg.toArray(), 0, this.kg.size(), value);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            try {
                return mz.kg(this.kg.toArray(), 0, this.kg.size(), value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            try {
                return mz.kg(this.kg.toArray(), index, count, value, comparer);
            }
            catch (InvalidOperationException invalidOperationException) {
                throw new ArgumentException(invalidOperationException.getMessage());
            }
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayList.kg(index, count, this.kg.size());
            if (this.isSynchronized()) {
                return ArrayList.sync(new RangedArrayList(this, index, count));
            }
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.kg.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            for (Object e : c) {
                this.kg.set(index++, e);
            }
            ++this.pr;
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            Collections.sort(this.kg, null);
            ++this.pr;
        }

        @Override
        public void sort(Comparator comparer) {
            Collections.sort(this.kg, comparer);
            ++this.pr;
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "Can't be less than 0.");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "Can't be less than 0.");
            }
            if (index > this.kg.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            List list = this.kg.subList(index, count);
            if (comparer == null) {
                Collections.sort(list);
            } else {
                Collections.sort(list, comparer);
            }
            for (int i = index; i < count; ++i) {
                this.kg.set(i, list.get(i - index));
            }
            ++this.pr;
        }

        @Override
        public Object[] toArray() {
            return this.kg.toArray();
        }

        @Override
        public a5 toArray(i7 type) {
            a5 a52 = com.aspose.slides.ms.System.a5.kg(type, this.kg.size());
            this.copyTo(a52);
            return a52;
        }

        @Override
        public Object deepClone() {
            Object[] objectArray = new Object[this.kg.size()];
            com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), 0, objectArray, 0, this.kg.size());
            java.util.ArrayList arrayList = new java.util.ArrayList();
            arrayList.addAll(arrayList);
            return new ArrayListInternalized(arrayList);
        }

        @Override
        public boolean isEmpty() {
            return this.kg.size() == 0;
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.kg.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            ++this.pr;
            return this.kg.add(o);
        }

        @Override
        public boolean remove(Object o) {
            ++this.pr;
            return this.kg.remove(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.kg.containsAll(c);
        }

        @Override
        public boolean addAll(Collection c) {
            ++this.pr;
            return this.kg.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection c) {
            ++this.pr;
            return this.kg.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection c) {
            ++this.pr;
            return this.kg.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection c) {
            ++this.pr;
            return this.kg.retainAll(c);
        }

        @Override
        public Object get(int index) {
            return this.kg.get(index);
        }

        @Override
        public Object set(int index, Object element) {
            ++this.pr;
            return this.kg.set(index, element);
        }

        @Override
        public void add(int index, Object element) {
            this.kg.add(index, element);
            ++this.pr;
        }

        @Override
        public Object remove(int index) {
            ++this.pr;
            return this.kg.remove(index);
        }

        @Override
        public ListIterator listIterator() {
            return this.kg.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.kg.listIterator(index);
        }

        @Override
        public List subList(int fromIndex, int toIndex) {
            return this.kg.subList(fromIndex, toIndex);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.kg = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.kg != 0;
        }

        @Override
        public int nextIndex() {
            return this.kg;
        }

        @Override
        public int previousIndex() {
            return this.kg - 1;
        }

        public Object previous() {
            int n = this.kg - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.kg;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.kg = n;
            this.pr = n;
            return objectArray[this.pr];
        }

        public void set(Object e) {
            if (this.pr < 0) {
                throw new IllegalStateException();
            }
            try {
                ((ArrayList)ArrayList.this).kg[this.pr] = e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(Object e) {
            try {
                int n = this.kg;
                ArrayList.this.add(n, e);
                this.kg = n + 1;
                this.pr = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator {
        int kg;
        int pr = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.kg != ArrayList.this.size();
        }

        public Object next() {
            int n = this.kg;
            if (n >= ArrayList.this.size()) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = ArrayList.this.kg;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.kg = n + 1;
            this.pr = n;
            return objectArray[this.pr];
        }

        @Override
        public void remove() {
            if (this.pr < 0) {
                throw new IllegalStateException();
            }
            try {
                ArrayList.this.remove(this.pr);
                this.kg = this.pr;
                this.pr = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    @fc
    private static class ListWrapper
    implements IList {
        protected IList kg;

        public ListWrapper(IList innerList) {
            this.kg = innerList;
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.kg.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.kg.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.kg.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.kg.isReadOnly();
        }

        @Override
        public int addItem(Object value) {
            return this.kg.addItem(value);
        }

        @Override
        public void clear() {
            this.kg.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.kg.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.kg.indexOf(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.kg.insertItem(index, value);
        }

        @Override
        public void removeItem(Object value) {
            this.kg.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.kg.removeAt(index);
        }

        @Override
        public void copyTo(a5 array, int index) {
            this.kg.copyTo(array, index);
        }

        @Override
        public IEnumerator iterator() {
            return this.kg.iterator();
        }
    }

    @fc
    private static final class ReadOnlyListWrapper
    extends FixedSizeListWrapper {
        @Override
        protected String kg() {
            return "List is read-only.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.kg());
        }
    }

    @fc
    private static class FixedSizeListWrapper
    extends ListWrapper {
        protected String kg() {
            return "List is fixed-size.";
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        public FixedSizeListWrapper(IList innerList) {
            super(innerList);
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.kg());
        }
    }

    @fc
    private static final class SynchronizedListWrapper
    extends ListWrapper {
        private final Object pr;

        public SynchronizedListWrapper(IList innerList) {
            super(innerList);
            this.pr = innerList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getSyncRoot() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.getSyncRoot();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.isReadOnly();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.pr;
            synchronized (object) {
                this.kg.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(a5 array, int index) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.iterator();
            }
        }
    }

    @fc
    private static final class RangedArrayList
    extends ArrayListWrapper {
        private int pr;
        private int k7;
        private int a5;

        public RangedArrayList(ArrayList innerList, int index, int count) {
            super(innerList);
            this.pr = index;
            this.k7 = count;
            this.a5 = innerList.getVersion();
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object get_Item(int index) {
            if (index < 0 || index > this.k7) {
                throw new ArgumentOutOfRangeException("index");
            }
            return this.kg.get_Item(this.pr + index);
        }

        @Override
        public void set_Item(int index, Object value) {
            if (index < 0 || index > this.k7) {
                throw new ArgumentOutOfRangeException("index");
            }
            this.kg.set_Item(this.pr + index, value);
        }

        @Override
        public int size() {
            this.kg();
            return this.k7;
        }

        @Override
        public int getCapacity() {
            return this.kg.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.k7) {
                throw new ArgumentOutOfRangeException();
            }
        }

        private void kg() {
            if (this.a5 != this.kg.getVersion()) {
                throw new IllegalStateException("ArrayList view is invalid because the underlying ArrayList was modified.");
            }
        }

        @Override
        public int addItem(Object value) {
            this.kg();
            this.kg.insertItem(this.pr + this.k7, value);
            this.a5 = this.kg.getVersion();
            return ++this.k7;
        }

        @Override
        public void clear() {
            this.kg();
            this.kg.removeRange(this.pr, this.k7);
            this.k7 = 0;
            this.a5 = this.kg.getVersion();
        }

        @Override
        public boolean contains(Object value) {
            return this.kg.kg(value, this.pr, this.k7);
        }

        @Override
        public int indexOf(Object value) {
            return this.indexOf(value, 0);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.k7 - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.k7) {
                RangedArrayList.kg("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                RangedArrayList.kg("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.k7 - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            int n = this.kg.indexOf(value, this.pr + startIndex, count);
            if (n == -1) {
                return -1;
            }
            return n - this.pr;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.k7 - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            int n;
            if (startIndex < 0) {
                RangedArrayList.kg("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                RangedArrayList.kg("count", (Object)count, "count is negative.");
            }
            if ((n = this.kg.lastIndexOf(value, this.pr + startIndex, count)) == -1) {
                return -1;
            }
            return n - this.pr;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.kg();
            if (index < 0 || index > this.k7) {
                RangedArrayList.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.kg.insertItem(this.pr + index, value);
            ++this.k7;
            this.a5 = this.kg.getVersion();
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.kg();
            if (index < 0 || index > this.k7) {
                RangedArrayList.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.kg.insertRange(this.pr + index, c);
            this.k7 += c.size();
            this.a5 = this.kg.getVersion();
        }

        @Override
        public void removeItem(Object value) {
            this.kg();
            int n = this.indexOf(value);
            if (n > -1) {
                this.removeAt(n);
            }
            this.a5 = this.kg.getVersion();
        }

        @Override
        public void removeAt(int index) {
            this.kg();
            if (index < 0 || index > this.k7) {
                RangedArrayList.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.kg.removeAt(this.pr + index);
            --this.k7;
            this.a5 = this.kg.getVersion();
        }

        @Override
        public void removeRange(int index, int count) {
            this.kg();
            RangedArrayList.kg(index, count, this.k7);
            this.kg.removeRange(this.pr + index, count);
            this.k7 -= count;
            this.a5 = this.kg.getVersion();
        }

        @Override
        public void reverse() {
            this.reverse(0, this.k7);
        }

        @Override
        public void reverse(int index, int count) {
            this.kg();
            RangedArrayList.kg(index, count, this.k7);
            this.kg.reverse(this.pr + index, count);
            this.a5 = this.kg.getVersion();
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.kg();
            if (index < 0 || index > this.k7) {
                RangedArrayList.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            this.kg.setRange(this.pr + index, c);
            this.a5 = this.kg.getVersion();
        }

        @Override
        public void copyTo(a5 array) {
            this.copyTo(array, 0);
        }

        @Override
        public void copyTo(a5 array, int index) {
            this.copyTo(0, array, index, this.k7);
        }

        @Override
        public void copyTo(int index, a5 array, int arrayIndex, int count) {
            RangedArrayList.kg(index, count, this.k7);
            this.kg.copyTo(this.pr + index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.iterator(0, this.k7);
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            RangedArrayList.kg(index, count, this.k7);
            return this.kg.iterator(this.pr + index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.kg();
            this.kg.insertRange(this.k7, c);
            this.k7 += c.size();
            this.a5 = this.kg.getVersion();
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(0, this.k7, value, Comparer.Default);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.k7, value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            RangedArrayList.kg(index, count, this.k7);
            return this.kg.binarySearch(this.pr + index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return new RangedArrayList((ArrayList)this.kg.deepClone(), this.pr, this.k7);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            RangedArrayList.kg(index, count, this.k7);
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException();
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.k7, comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.kg();
            RangedArrayList.kg(index, count, this.k7);
            this.kg.sort(this.pr + index, count, comparer);
            this.a5 = this.kg.getVersion();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.k7];
            this.kg.copyTo(this.pr, com.aspose.slides.ms.System.a5.kg(objectArray), 0, this.k7);
            return objectArray;
        }

        @Override
        public a5 toArray(i7 elementType) {
            a5 a52 = com.aspose.slides.ms.System.a5.kg(elementType, this.k7);
            this.kg.copyTo(this.pr, a52, 0, this.k7);
            return a52;
        }
    }

    @fc
    private static final class ReadOnlyArrayListWrapper
    extends FixedSizeArrayListWrapper {
        @Override
        protected String kg() {
            return "Can't modify a readonly list.";
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        public ReadOnlyArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void reverse() {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void reverse(int index, int count) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void setRange(int index, ICollection c) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void sort() {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void sort(Comparator comparer) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            throw new NotSupportedException(this.kg());
        }
    }

    @fc
    private static class FixedSizeArrayListWrapper
    extends ArrayListWrapper {
        public FixedSizeArrayListWrapper(ArrayList innerList) {
            super(innerList);
        }

        protected String kg() {
            return "Can't add or remove from a fixed-size list.";
        }

        @Override
        public int getCapacity() {
            return super.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void addRange(ICollection c) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void clear() {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void insertRange(int index, ICollection c) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void insertRange(int index, Object[] c) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void removeRange(int index, int count) {
            throw new NotSupportedException(this.kg());
        }

        @Override
        public void trimToSize() {
            throw new NotSupportedException(this.kg());
        }
    }

    @fc
    private static final class SynchronizedArrayListWrapper
    extends ArrayListWrapper {
        private final Object pr;

        SynchronizedArrayListWrapper(ArrayList innerArrayList) {
            super(innerArrayList);
            this.pr = innerArrayList.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(int index) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.get_Item(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(int index, Object value) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.set_Item(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.setCapacity(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFixedSize() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.isFixedSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadOnly() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.isReadOnly();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.pr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int addItem(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.addItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.pr;
            synchronized (object) {
                this.kg.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.contains(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.indexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.indexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object value, int startIndex, int count) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.indexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.lastIndexOf(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.lastIndexOf(value, startIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.lastIndexOf(value, startIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertItem(int index, Object value) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.insertItem(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertRange(int index, ICollection c) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.insertRange(index, c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object value) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.removeItem(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeRange(int index, int count) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.removeRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse() {
            Object object = this.pr;
            synchronized (object) {
                this.kg.reverse();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reverse(int index, int count) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.reverse(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(a5 array) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.copyTo(array);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(a5 array, int index) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(int index, a5 array, int arrayIndex, int count) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.copyTo(index, array, arrayIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator(int index, int count) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.iterator(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addRange(ICollection c) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.addRange(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.binarySearch(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(Object value, Comparator comparer) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.binarySearch(value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.binarySearch(index, count, value, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ArrayList getRange(int index, int count) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.getRange(index, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.pr;
            synchronized (object) {
                this.kg.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort() {
            Object object = this.pr;
            synchronized (object) {
                this.kg.sort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator comparer) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.sort(comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(int index, int count, Comparator comparer) {
            Object object = this.pr;
            synchronized (object) {
                this.kg.sort(index, count, comparer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public a5 toArray(i7 elementType) {
            Object object = this.pr;
            synchronized (object) {
                return this.kg.toArray(elementType);
            }
        }
    }

    @fc
    private static class ArrayListWrapper
    extends ArrayList {
        protected ArrayList kg;

        public ArrayListWrapper(ArrayList innerArrayList) {
            this.kg = innerArrayList;
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.kg.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public int getCapacity() {
            return this.kg.getCapacity();
        }

        @Override
        public void setCapacity(int value) {
            this.kg.setCapacity(value);
        }

        @Override
        public boolean isFixedSize() {
            return this.kg.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.kg.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return this.kg.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.kg.addItem(value);
        }

        @Override
        public void clear() {
            this.kg.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.kg.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.kg.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.kg.indexOf(value, startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            return this.kg.indexOf(value, startIndex, count);
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.kg.lastIndexOf(value);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.kg.lastIndexOf(value, startIndex);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            return this.kg.lastIndexOf(value, startIndex, count);
        }

        @Override
        public void insertItem(int index, Object value) {
            this.kg.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            this.kg.insertRange(index, c);
        }

        @Override
        public void removeItem(Object value) {
            this.kg.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.kg.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            this.kg.removeRange(index, count);
        }

        @Override
        public void reverse() {
            this.kg.reverse();
        }

        @Override
        public void reverse(int index, int count) {
            this.kg.reverse(index, count);
        }

        @Override
        public void setRange(int index, ICollection c) {
            this.kg.setRange(index, c);
        }

        @Override
        public void copyTo(a5 array) {
            this.kg.copyTo(array);
        }

        @Override
        public void copyTo(a5 array, int index) {
            this.kg.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, a5 array, int arrayIndex, int count) {
            this.kg.copyTo(index, array, arrayIndex, count);
        }

        @Override
        public IEnumerator iterator() {
            return this.kg.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            return this.kg.iterator(index, count);
        }

        @Override
        public void addRange(ICollection c) {
            this.kg.addRange(c);
        }

        @Override
        public int binarySearch(Object value) {
            return this.kg.binarySearch(value);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.kg.binarySearch(value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            return this.kg.binarySearch(index, count, value, comparer);
        }

        @Override
        public Object deepClone() {
            return this.kg.deepClone();
        }

        @Override
        public ArrayList getRange(int index, int count) {
            return this.kg.getRange(index, count);
        }

        @Override
        public void trimToSize() {
            this.kg.trimToSize();
        }

        @Override
        public void sort() {
            this.kg.sort();
        }

        @Override
        public void sort(Comparator comparer) {
            this.kg.sort(comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            this.kg.sort(index, count, comparer);
        }

        @Override
        public Object[] toArray() {
            return this.kg.toArray();
        }

        @Override
        public a5 toArray(i7 elementType) {
            return this.kg.toArray(elementType);
        }
    }

    @fc
    private static final class ArrayListAdapter
    extends ArrayList {
        private IList kg;

        public ArrayListAdapter(IList adaptee) {
            super(0, true);
            this.kg = adaptee;
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.get_Item(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            this.kg.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public int getCapacity() {
            return this.kg.size();
        }

        @Override
        public void setCapacity(int value) {
            if (value < this.kg.size()) {
                throw new ArgumentException("capacity");
            }
        }

        @Override
        public boolean isFixedSize() {
            return this.kg.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.kg.isReadOnly();
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        @Override
        public int addItem(Object value) {
            return this.kg.addItem(value);
        }

        @Override
        public void clear() {
            this.kg.clear();
        }

        @Override
        public boolean contains(Object value) {
            return this.kg.contains(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.kg.indexOf(value);
        }

        @Override
        public int indexOf(Object value, int startIndex) {
            return this.indexOf(value, startIndex, this.kg.size() - startIndex);
        }

        @Override
        public int indexOf(Object value, int startIndex, int count) {
            if (startIndex < 0 || startIndex > this.kg.size()) {
                ArrayListAdapter.kg("startIndex", (Object)startIndex, "Does not specify valid index.");
            }
            if (count < 0) {
                ArrayListAdapter.kg("count", (Object)count, "Can't be less than 0.");
            }
            if (startIndex > this.kg.size() - count) {
                throw new ArgumentOutOfRangeException("count", "Start index and count do not specify a valid range.");
            }
            if (value == null) {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (this.kg.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i < startIndex + count; ++i) {
                    if (!value.equals(this.kg.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object value) {
            return this.lastIndexOf(value, this.kg.size() - 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex) {
            return this.lastIndexOf(value, startIndex, startIndex + 1);
        }

        @Override
        public int lastIndexOf(Object value, int startIndex, int count) {
            if (startIndex < 0) {
                ArrayListAdapter.kg("startIndex", (Object)startIndex, "< 0");
            }
            if (count < 0) {
                ArrayListAdapter.kg("count", (Object)count, "count is negative.");
            }
            if (startIndex - count + 1 < 0) {
                ArrayListAdapter.kg("count", (Object)count, "count is too large.");
            }
            if (value == null) {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (this.kg.get_Item(i) != null) continue;
                    return i;
                }
            } else {
                for (int i = startIndex; i > startIndex - count; --i) {
                    if (!value.equals(this.kg.get_Item(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public void insertItem(int index, Object value) {
            this.kg.insertItem(index, value);
        }

        @Override
        public void insertRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index > this.kg.size()) {
                ArrayListAdapter.kg("index", (Object)index, "Index must be >= 0 and <= Count.");
            }
            for (Object e : c) {
                this.kg.insertItem(index++, e);
            }
        }

        @Override
        public void removeItem(Object value) {
            this.kg.removeItem(value);
        }

        @Override
        public void removeAt(int index) {
            this.kg.removeAt(index);
        }

        @Override
        public void removeRange(int index, int count) {
            ArrayListAdapter.kg(index, count, this.kg.size());
            for (int i = 0; i < count; ++i) {
                this.kg.removeAt(index);
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.kg.size());
        }

        @Override
        public void reverse(int index, int count) {
            ArrayListAdapter.kg(index, count, this.kg.size());
            for (int i = 0; i < count / 2; ++i) {
                Object object = this.kg.get_Item(i + index);
                this.kg.set_Item(i + index, this.kg.get_Item(index + count - i + index - 1));
                this.kg.set_Item(index + count - i + index - 1, object);
            }
        }

        @Override
        public void setRange(int index, ICollection c) {
            if (c == null) {
                throw new ArgumentNullException("c");
            }
            if (index < 0 || index + c.size() > this.kg.size()) {
                throw new ArgumentOutOfRangeException("index");
            }
            int n = index;
            for (Object e : c) {
                this.kg.set_Item(n++, e);
            }
        }

        @Override
        public void copyTo(a5 array) {
            this.kg.copyTo(array, 0);
        }

        @Override
        public void copyTo(a5 array, int index) {
            this.kg.copyTo(array, index);
        }

        @Override
        public void copyTo(int index, a5 array, int arrayIndex, int count) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (index < 0) {
                ArrayListAdapter.kg("index", (Object)index, "Can't be less than zero.");
            }
            if (arrayIndex < 0) {
                ArrayListAdapter.kg("arrayIndex", (Object)arrayIndex, "Can't be less than zero.");
            }
            if (count < 0) {
                ArrayListAdapter.kg("index", (Object)index, "Can't be less than zero.");
            }
            if (array.a5() > 1) {
                throw new ArgumentException("Can't copy into multi-dimensional array.");
            }
            if (array.b0() - arrayIndex < count) {
                throw new ArgumentException("Destination array is too small.");
            }
            if (index > this.kg.size() - count) {
                throw new ArgumentException("Index and count do not denote a valid range of elements.", "index");
            }
            for (int i = 0; i < count; ++i) {
                array.k7(this.kg.get_Item(index + i), arrayIndex + i);
            }
        }

        @Override
        public boolean isSynchronized() {
            return this.kg.isSynchronized();
        }

        @Override
        public IEnumerator iterator() {
            return this.kg.iterator();
        }

        @Override
        public IEnumerator iterator(int index, int count) {
            ArrayListAdapter.kg(index, count, this.kg.size());
            return new EnumeratorWithRange(this.kg.iterator(), index, count);
        }

        @Override
        public void addRange(ICollection c) {
            for (Object e : c) {
                this.kg.addItem(e);
            }
        }

        @Override
        public int binarySearch(Object value) {
            return this.binarySearch(value, null);
        }

        @Override
        public int binarySearch(Object value, Comparator comparer) {
            return this.binarySearch(0, this.kg.size(), value, comparer);
        }

        @Override
        public int binarySearch(int index, int count, Object value, Comparator comparer) {
            ArrayListAdapter.kg(index, count, this.kg.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            int n = index;
            int n10 = index + count - 1;
            while (n <= n10) {
                int n11;
                int n12 = n + (n10 - n) / 2;
                try {
                    n11 = comparer.compare(value, this.kg.get_Item(n12));
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("value is not of the same type", exception);
                }
                if (n11 < 0) {
                    n10 = n12 - 1;
                    continue;
                }
                if (n11 > 0) {
                    n = n12 + 1;
                    continue;
                }
                return n12;
            }
            return ~n;
        }

        @Override
        public Object deepClone() {
            return new ArrayListAdapter(this.kg);
        }

        @Override
        public ArrayList getRange(int index, int count) {
            ArrayListAdapter.kg(index, count, this.kg.size());
            return new RangedArrayList(this, index, count);
        }

        @Override
        public void trimToSize() {
        }

        @Override
        public void sort() {
            this.sort((Comparator)Comparer.Default);
        }

        @Override
        public void sort(Comparator comparer) {
            this.sort(0, this.kg.size(), comparer);
        }

        @Override
        public void sort(int index, int count, Comparator comparer) {
            ArrayListAdapter.kg(index, count, this.kg.size());
            if (comparer == null) {
                comparer = Comparer.Default;
            }
            ArrayListAdapter.kg(this.kg, index, index + count - 1, comparer);
        }

        private static void kg(IList iList, int n, int n10) {
            Object object = iList.get_Item(n);
            iList.set_Item(n, iList.get_Item(n10));
            iList.set_Item(n10, object);
        }

        static void kg(IList iList, int n, int n10, Comparator comparator) {
            if (n >= n10) {
                return;
            }
            int n11 = n + (n10 - n) / 2;
            if (comparator.compare(iList.get_Item(n11), iList.get_Item(n)) < 0) {
                ArrayListAdapter.kg(iList, n11, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n)) < 0) {
                ArrayListAdapter.kg(iList, n10, n);
            }
            if (comparator.compare(iList.get_Item(n10), iList.get_Item(n11)) < 0) {
                ArrayListAdapter.kg(iList, n10, n11);
            }
            if (n10 - n + 1 <= 3) {
                return;
            }
            ArrayListAdapter.kg(iList, n10 - 1, n11);
            Object object = iList.get_Item(n10 - 1);
            int n12 = n;
            int n13 = n10 - 1;
            while (true) {
                if (comparator.compare(iList.get_Item(++n12), object) < 0) {
                    continue;
                }
                while (comparator.compare(iList.get_Item(--n13), object) > 0) {
                }
                if (n12 >= n13) break;
                ArrayListAdapter.kg(iList, n12, n13);
            }
            ArrayListAdapter.kg(iList, n10 - 1, n12);
            ArrayListAdapter.kg(iList, n, n12 - 1, comparator);
            ArrayListAdapter.kg(iList, n12 + 1, n10, comparator);
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.kg.size()];
            this.kg.copyTo(com.aspose.slides.ms.System.a5.kg(objectArray), 0);
            return objectArray;
        }

        @Override
        public a5 toArray(i7 elementType) {
            a5 a52 = com.aspose.slides.ms.System.a5.kg(elementType, this.kg.size());
            this.kg.copyTo(a52, 0);
            return a52;
        }

        private static final class EnumeratorWithRange
        implements IEnumerator,
        cu,
        Cloneable {
            private int kg;
            private int pr;
            private int k7;
            private IEnumerator a5;

            private EnumeratorWithRange() {
            }

            public EnumeratorWithRange(IEnumerator enumerator, int index, int count) {
                this.pr = 0;
                this.kg = index;
                this.k7 = count;
                this.a5 = enumerator;
                this.reset();
            }

            @Override
            public Object deepClone() {
                return this.kg();
            }

            @Override
            public Object next() {
                return this.a5.next();
            }

            @Override
            public boolean hasNext() {
                if (this.pr >= this.k7) {
                    return false;
                }
                ++this.pr;
                return this.a5.hasNext();
            }

            @Override
            public void reset() {
                this.pr = 0;
                this.a5.reset();
                for (int i = 0; i < this.kg; ++i) {
                    this.a5.hasNext();
                }
            }

            protected Object kg() {
                try {
                    return this.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalStateException(cloneNotSupportedException);
                }
            }

            protected Object clone() throws CloneNotSupportedException {
                EnumeratorWithRange enumeratorWithRange = new EnumeratorWithRange();
                enumeratorWithRange.kg = this.kg;
                enumeratorWithRange.pr = this.pr;
                enumeratorWithRange.k7 = this.k7;
                enumeratorWithRange.a5 = this.a5;
                return enumeratorWithRange;
            }

            @Override
            public void remove() {
                throw new NotSupportedException();
            }
        }
    }

    static final class SimpleEnumerator
    implements IEnumerator,
    cu,
    Cloneable {
        private ArrayList pr;
        private Object k7;
        private int a5;
        private int b0;
        static Object kg = new Object();

        private SimpleEnumerator() {
        }

        public SimpleEnumerator(ArrayList list) {
            this.pr = list;
            this.a5 = -1;
            this.b0 = list.getVersion();
            this.k7 = kg;
        }

        @Override
        public Object deepClone() {
            return this.kg();
        }

        @Override
        public boolean hasNext() {
            if (this.b0 != this.pr.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            if (++this.a5 < this.pr.size()) {
                this.k7 = this.pr.get_Item(this.a5);
                return true;
            }
            this.k7 = kg;
            return false;
        }

        @Override
        public Object next() {
            if (this.k7 == kg) {
                if (this.a5 == -1) {
                    throw new IllegalStateException("Enumerator not started");
                }
                throw new IllegalStateException("Enumerator ended");
            }
            return this.k7;
        }

        @Override
        public void reset() {
            if (this.b0 != this.pr.getVersion()) {
                throw new IllegalStateException("List has changed.");
            }
            this.k7 = kg;
            this.a5 = -1;
        }

        protected Object kg() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            SimpleEnumerator simpleEnumerator = new SimpleEnumerator();
            simpleEnumerator.pr = this.pr;
            simpleEnumerator.k7 = this.k7;
            simpleEnumerator.a5 = this.a5;
            simpleEnumerator.b0 = this.b0;
            return simpleEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class ArrayListEnumerator
    implements IEnumerator,
    cu,
    Cloneable {
        private Object kg;
        private ArrayList pr;
        private int k7;
        private int a5;
        private int b0;
        private int sk;

        private ArrayListEnumerator() {
        }

        @Override
        public Object deepClone() {
            return this.kg();
        }

        public ArrayListEnumerator(ArrayList list, int index, int count) {
            this.pr = list;
            this.a5 = index;
            this.b0 = count;
            this.k7 = this.a5 - 1;
            this.kg = null;
            this.sk = list.getVersion();
        }

        @Override
        public Object next() {
            if (this.k7 == this.a5 - 1) {
                throw new IllegalStateException("Enumerator unusable (Reset pending, or past end of array.");
            }
            return this.kg;
        }

        @Override
        public boolean hasNext() {
            if (this.pr.getVersion() != this.sk) {
                throw new IllegalStateException("List has changed.");
            }
            ++this.k7;
            if (this.k7 - this.a5 < this.b0) {
                this.kg = this.pr.get_Item(this.k7);
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.kg = null;
            this.k7 = this.a5 - 1;
        }

        protected Object kg() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            ArrayListEnumerator arrayListEnumerator = new ArrayListEnumerator();
            arrayListEnumerator.kg = this.kg;
            arrayListEnumerator.pr = this.pr;
            arrayListEnumerator.k7 = this.k7;
            arrayListEnumerator.a5 = this.a5;
            arrayListEnumerator.b0 = this.b0;
            arrayListEnumerator.sk = this.sk;
            return arrayListEnumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

