/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.cu;
import com.aspose.slides.ms.System.fc;

@fc
public final class BitArray
implements ICollection,
cu {
    private int[] kg;
    private int pr;
    private int k7 = 0;

    public BitArray(BitArray bits) {
        if (bits == null) {
            throw new ArgumentNullException("bits");
        }
        this.pr = bits.pr;
        this.kg = new int[(this.pr + 31) / 32];
        if (this.kg.length == 1) {
            this.kg[0] = bits.kg[0];
        } else {
            a5.kg(bits.kg, 0, this.kg, 0, this.kg.length);
        }
    }

    public BitArray(boolean[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        this.pr = values.length;
        this.kg = new int[(this.pr + 31) / 32];
        for (int i = 0; i < values.length; ++i) {
            this.set_Item(i, values[i]);
        }
    }

    public BitArray(byte[] bytes) {
        if (bytes == null) {
            throw new ArgumentNullException("bytes");
        }
        this.pr = bytes.length * 8;
        this.kg = new int[(this.pr + 31) / 32];
        for (int i = 0; i < bytes.length; ++i) {
            this.kg(i, bytes[i]);
        }
    }

    public BitArray(int[] values) {
        if (values == null) {
            throw new ArgumentNullException("values");
        }
        int n = values.length;
        this.pr = n * 32;
        this.kg = new int[n];
        a5.kg(values, 0, this.kg, 0, n);
    }

    public BitArray(int length) {
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length");
        }
        this.pr = length;
        this.kg = new int[(this.pr + 31) / 32];
    }

    public BitArray(int length, boolean defaultValue) {
        this(length);
        if (defaultValue) {
            for (int i = 0; i < this.kg.length; ++i) {
                this.kg[i] = -1;
            }
        }
    }

    private byte kg(int n) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = this.kg[n10] & 255 << n11;
        return (byte)(n12 >> n11 & 0xFF);
    }

    private void kg(int n, byte by2) {
        int n10 = n / 4;
        int n11 = n % 4 * 8;
        int n12 = n10;
        this.kg[n12] = this.kg[n12] & ~(255 << n11);
        int n13 = n10;
        this.kg[n13] = this.kg[n13] | (by2 & 0xFF) << n11;
        ++this.k7;
    }

    private void pr(BitArray bitArray) {
        if (bitArray == null) {
            throw new ArgumentNullException();
        }
        if (bitArray.pr != this.pr) {
            throw new ArgumentException();
        }
    }

    @Override
    public int size() {
        return this.pr;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    public boolean get_Item(int index) {
        return this.get(index);
    }

    public void set_Item(int index, boolean value) {
        this.set(index, value);
    }

    public int getLength() {
        return this.pr;
    }

    public void setLength(int value) {
        if (this.pr == value) {
            return;
        }
        if (value < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (value > this.pr) {
            int n = (value + 31) / 32;
            int n10 = (this.pr + 31) / 32;
            if (n > this.kg.length) {
                int[] nArray = new int[n];
                a5.kg(this.kg, 0, nArray, 0, this.kg.length);
                this.kg = nArray;
            } else {
                a5.kg(a5.kg((Object)this.kg), n10, n - n10);
            }
            int n11 = this.pr % 32;
            if (n11 > 0) {
                int n12 = n10 - 1;
                this.kg[n12] = this.kg[n12] & (1 << n11) - 1;
            }
        }
        this.pr = value;
        ++this.k7;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public Object deepClone() {
        return new BitArray(this);
    }

    @Override
    public void copyTo(a5 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.a5() != 1) {
            throw new ArgumentException("array", "Array rank must be 1");
        }
        if (index >= array.b0() && this.pr > 0) {
            throw new ArgumentException("index", "index is greater than array.Length");
        }
        Object object = a5.kg(array);
        if (object instanceof Boolean[]) {
            if (array.b0() - index < this.pr) {
                throw new ArgumentException();
            }
            Boolean[] booleanArray = (Boolean[])object;
            for (int i = 0; i < this.pr; ++i) {
                booleanArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof boolean[]) {
            if (array.b0() - index < this.pr) {
                throw new ArgumentException();
            }
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < this.pr; ++i) {
                blArray[index + i] = this.get_Item(i);
            }
        } else if (object instanceof Byte[]) {
            int n = (this.pr + 7) / 8;
            if (array.b0() - index < n) {
                throw new ArgumentException();
            }
            Byte[] byteArray = (Byte[])object;
            for (int i = 0; i < n; ++i) {
                byteArray[index + i] = this.kg(i);
            }
        } else if (object instanceof byte[]) {
            int n = (this.pr + 7) / 8;
            if (array.b0() - index < n) {
                throw new ArgumentException();
            }
            byte[] byArray = (byte[])object;
            for (int i = 0; i < n; ++i) {
                byArray[index + i] = this.kg(i);
            }
        } else if (object instanceof Integer[]) {
            a5.kg(a5.kg((Object)this.kg), 0, array, index, (this.pr + 31) / 32);
        } else if (object instanceof int[]) {
            a5.kg(a5.kg((Object)this.kg), 0, array, index, (this.pr + 31) / 32);
        } else {
            throw new ArgumentException("array", "Unsupported type");
        }
    }

    public BitArray not() {
        int n = (this.pr + 31) / 32;
        for (int i = 0; i < n; ++i) {
            this.kg[i] = ~this.kg[i];
        }
        ++this.k7;
        return this;
    }

    public BitArray and(BitArray value) {
        this.pr(value);
        int n = (this.pr + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.kg[n10] = this.kg[n10] & value.kg[i];
        }
        ++this.k7;
        return this;
    }

    public BitArray or(BitArray value) {
        this.pr(value);
        int n = (this.pr + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.kg[n10] = this.kg[n10] | value.kg[i];
        }
        ++this.k7;
        return this;
    }

    public BitArray xor(BitArray value) {
        this.pr(value);
        int n = (this.pr + 31) / 32;
        for (int i = 0; i < n; ++i) {
            int n10 = i;
            this.kg[n10] = this.kg[n10] ^ value.kg[i];
        }
        ++this.k7;
        return this;
    }

    public boolean get(int index) {
        if (index < 0 || index >= this.pr) {
            throw new ArgumentOutOfRangeException();
        }
        return (this.kg[index >> 5] & 1 << (index & 0x1F)) != 0;
    }

    public void set(int index, boolean value) {
        if (index < 0 || index >= this.pr) {
            throw new ArgumentOutOfRangeException();
        }
        if (value) {
            int n = index >> 5;
            this.kg[n] = this.kg[n] | 1 << (index & 0x1F);
        } else {
            int n = index >> 5;
            this.kg[n] = this.kg[n] & ~(1 << (index & 0x1F));
        }
        ++this.k7;
    }

    public void setAll(boolean value) {
        if (value) {
            for (int i = 0; i < this.kg.length; ++i) {
                this.kg[i] = -1;
            }
        } else {
            a5.kg(a5.kg((Object)this.kg), 0, this.kg.length);
        }
        ++this.k7;
    }

    @Override
    public IEnumerator iterator() {
        return new BitArrayEnumerator(this);
    }

    @fc
    private static class BitArrayEnumerator
    implements IEnumerator,
    cu,
    Cloneable {
        private BitArray kg;
        private boolean pr;
        private int k7;
        private int a5;

        @Override
        public Object deepClone() {
            return this.kg();
        }

        private BitArrayEnumerator() {
        }

        public BitArrayEnumerator(BitArray ba2) {
            this.k7 = -1;
            this.kg = ba2;
            this.a5 = ba2.k7;
        }

        @Override
        public Object next() {
            if (this.k7 == -1) {
                throw new InvalidOperationException("Enum not started");
            }
            if (this.k7 >= this.kg.size()) {
                throw new InvalidOperationException("Enum Ended");
            }
            return this.pr;
        }

        @Override
        public boolean hasNext() {
            this.pr();
            if (this.k7 < this.kg.size() - 1) {
                this.pr = this.kg.get_Item(++this.k7);
                return true;
            }
            this.k7 = this.kg.size();
            return false;
        }

        @Override
        public void reset() {
            this.pr();
            this.k7 = -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        private void pr() {
            if (this.a5 != this.kg.k7) {
                throw new InvalidOperationException();
            }
        }

        protected Object kg() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            BitArrayEnumerator bitArrayEnumerator = new BitArrayEnumerator();
            bitArrayEnumerator.kg = this.kg;
            bitArrayEnumerator.pr = this.pr;
            bitArrayEnumerator.k7 = this.k7;
            bitArrayEnumerator.a5 = this.a5;
            return bitArrayEnumerator;
        }
    }
}

