/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.IGenericList;
import com.aspose.slides.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.po.ud;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.fc;
import com.aspose.slides.ms.System.kg;
import com.aspose.slides.ms.System.lv;
import com.aspose.slides.ms.System.lz;
import com.aspose.slides.ms.System.mz;
import com.aspose.slides.ms.System.o4;
import com.aspose.slides.ms.System.s6;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

@fc
public class List<T>
implements IGenericList<T>,
java.util.List<T> {
    private Object[] kg;
    private int pr;
    private int k7;
    private final Object a5 = new Object();
    static Object[] sk = new Object[0];

    public List() {
        this.kg = sk;
    }

    public List(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.kg = sk;
        this.kg(collection);
    }

    public List(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: capacity");
        }
        this.kg = new Object[capacity];
    }

    private List(T[] data, int size) {
        this.kg = data;
        this.pr = size;
    }

    protected int getVersion() {
        return this.k7;
    }

    @Override
    public void addItem(T item) {
        if (this.pr == this.kg.length) {
            this.kg(1);
        }
        this.kg[this.pr++] = item;
        ++this.k7;
    }

    private void kg(int n) {
        int n10 = this.pr + n;
        if (n10 > this.kg.length) {
            this.setCapacity(Math.max(Math.max(this.getCapacity() * 2, 4), n10));
        }
    }

    private void kg(int n, int n10) {
        if (n < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (n10 < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.pr & 0xFFFFFFFFL)) {
            throw new ArgumentException("index and count exceed length of list");
        }
    }

    private void kg(IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.addItem(t);
        }
    }

    public void addRange(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.kg(new List<T>(collection));
        ++this.k7;
    }

    public void addRange(T[] collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (T t : collection) {
            this.addItem(t);
        }
        ++this.k7;
    }

    public ReadOnlyCollection<T> asReadOnly() {
        return new ReadOnlyCollection(this);
    }

    public int binarySearch(T item) {
        return mz.kg(this.kg, 0, this.pr, item);
    }

    public int binarySearch(T item, Comparator<T> comparer) {
        return mz.kg(this.kg, 0, this.pr, item, comparer);
    }

    public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
        this.kg(index, count);
        return mz.kg(this.kg, index, count, item, comparer);
    }

    @Override
    public void clear() {
        com.aspose.slides.ms.System.a5.kg(this.kg, 0, this.kg.length);
        this.pr = 0;
        ++this.k7;
    }

    public <TOutput> List<TOutput> convertAll(s6<T, TOutput> converter) {
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        List<T> list = new List<T>(this.pr);
        for (int i = 0; i < this.pr; ++i) {
            list.kg[i] = converter.kg(this.kg[i]);
        }
        list.pr = this.pr;
        return list;
    }

    public void copyTo(T[] array) {
        com.aspose.slides.ms.System.a5.kg(this.kg, 0, array, 0, this.pr);
    }

    @Override
    public void copyToTArray(T[] array, int arrayIndex) {
        com.aspose.slides.ms.System.a5.kg(this.kg, 0, array, arrayIndex, this.pr);
    }

    public void copyTo(int index, T[] array, int arrayIndex, int count) {
        this.kg(index, count);
        com.aspose.slides.ms.System.a5.kg(this.kg, index, array, arrayIndex, count);
    }

    public boolean exists(lz<T> match) {
        List.kg(match);
        return this.kg(0, this.pr, match) != -1;
    }

    public T find(lz<T> match) {
        List.kg(match);
        int n = this.kg(0, this.pr, match);
        return (T)(n != -1 ? this.kg[n] : null);
    }

    static <T> void kg(lz<T> lz3) {
        if (lz3 == null) {
            throw new ArgumentNullException("match");
        }
    }

    public List<T> findAll(lz<T> match) {
        List.kg(match);
        return this.pr(match);
    }

    private List<T> pr(lz<T> lz3) {
        List<Object> list = new List<Object>();
        for (int i = 0; i < this.pr; ++i) {
            if (!lz3.invoke(this.kg[i])) continue;
            list.addItem(this.kg[i]);
        }
        return list;
    }

    public int findIndex(lz<T> match) {
        List.kg(match);
        return this.kg(0, this.pr, match);
    }

    public int findIndex(int startIndex, lz<T> match) {
        List.kg(match);
        this.pr(startIndex);
        return this.kg(startIndex, this.pr - startIndex, match);
    }

    public int findIndex(int startIndex, int count, lz<T> match) {
        List.kg(match);
        this.kg(startIndex, count);
        return this.kg(startIndex, count, match);
    }

    private int kg(int n, int n10, lz<T> lz3) {
        int n11 = n + n10;
        for (int i = n; i < n11; ++i) {
            if (!lz3.invoke(this.kg[i])) continue;
            return i;
        }
        return -1;
    }

    public T findLast(lz<T> match) {
        List.kg(match);
        int n = this.pr(0, this.pr, match);
        if (n == -1) {
            return null;
        }
        return this.get_Item(n);
    }

    public int findLastIndex(lz<T> match) {
        List.kg(match);
        return this.pr(0, this.pr, match);
    }

    public int findLastIndex(int startIndex, lz<T> match) {
        List.kg(match);
        this.pr(startIndex);
        return this.pr(0, startIndex + 1, match);
    }

    public int findLastIndex(int startIndex, int count, lz<T> match) {
        List.kg(match);
        int n = startIndex - count + 1;
        this.kg(n, count);
        return this.pr(n, count, match);
    }

    private int pr(int n, int n10, lz<T> lz3) {
        int n11 = n + n10;
        while (n11 != n) {
            if (!lz3.invoke(this.kg[--n11])) continue;
            return n11;
        }
        return -1;
    }

    @Override
    public void forEach(kg<T> action) {
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < this.pr; ++i) {
            action.invoke(this.kg[i]);
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @Deprecated
    public EnumeratorJava<T> iteratorJava() {
        return new EnumeratorJava(this);
    }

    public List<T> getRange(int index, int count) {
        this.kg(index, count);
        Object[] objectArray = new Object[count];
        com.aspose.slides.ms.System.a5.kg(this.kg, index, objectArray, 0, count);
        return new List<Object>(objectArray, count);
    }

    @Override
    public int indexOfItem(T item) {
        return com.aspose.slides.ms.System.a5.kg(this.kg, item, 0, this.pr);
    }

    public int indexOf(T item, int index) {
        this.pr(index);
        return com.aspose.slides.ms.System.a5.kg(this.kg, item, index, this.pr - index);
    }

    public int indexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("Parameter name: count");
        }
        if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.pr & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
        }
        return com.aspose.slides.ms.System.a5.kg(this.kg, item, index, count);
    }

    private void pr(int n, int n10) {
        if (n10 < 0) {
            n -= n10;
        }
        if (n < this.pr) {
            com.aspose.slides.ms.System.a5.kg(this.kg, n, this.kg, n + n10, this.pr - n);
        }
        this.pr += n10;
        if (n10 < 0) {
            com.aspose.slides.ms.System.a5.kg(this.kg, this.pr, -n10);
        }
    }

    private void pr(int n) {
        if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.pr & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
    }

    @Override
    public void insertItem(int index, T item) {
        this.pr(index);
        if (this.pr == this.kg.length) {
            this.kg(1);
        }
        this.pr(index, 1);
        this.kg[index] = item;
        ++this.k7;
    }

    void k7(int n) {
        Object[] objectArray = new Object[this.pr];
        this.copyToTArray(objectArray, 0);
        this.kg(this.pr);
        this.pr(n, objectArray.length);
        com.aspose.slides.ms.System.a5.kg(objectArray, 0, this.kg, n, objectArray.length);
    }

    public void insertRange(int index, IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        this.pr(index);
        if (collection == this) {
            this.k7(index);
        } else {
            this.kg(index, collection);
        }
        ++this.k7;
    }

    private void kg(int n, IGenericEnumerable<T> iGenericEnumerable) {
        for (Object t : iGenericEnumerable) {
            this.insertItem(n++, t);
        }
    }

    @Override
    public int lastIndexOf(Object item) {
        if (this.pr == 0) {
            return -1;
        }
        return mz.kg(this.kg, item, this.pr - 1, this.pr);
    }

    public int lastIndexOf(T item, int index) {
        this.pr(index);
        return mz.kg(this.kg, item, index, index + 1);
    }

    public int lastIndexOf(T item, int index, int count) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", index, "index is negative");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", count, "count is negative");
        }
        if (index - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("cound", count, "count is too large");
        }
        return mz.kg(this.kg, item, index, count);
    }

    @Override
    public boolean removeItem(T item) {
        int n = this.indexOfItem(item);
        if (n != -1) {
            this.removeAt(n);
        }
        return n != -1;
    }

    public int removeAll(lz<T> match) {
        List.kg(match);
        int n = 0;
        int n10 = 0;
        for (n = 0; n < this.pr && !match.invoke(this.kg[n]); ++n) {
        }
        if (n == this.pr) {
            return 0;
        }
        ++this.k7;
        for (n10 = n + 1; n10 < this.pr; ++n10) {
            if (match.invoke(this.kg[n10])) continue;
            this.kg[n++] = this.kg[n10];
        }
        if (n10 - n > 0) {
            com.aspose.slides.ms.System.a5.kg(this.kg, n, n10 - n);
        }
        this.pr = n;
        return n10 - n;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.pr & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.pr(index, -1);
        com.aspose.slides.ms.System.a5.kg(this.kg, this.pr, 1);
        ++this.k7;
    }

    public void removeRange(int index, int count) {
        this.kg(index, count);
        if (count > 0) {
            this.pr(index, -count);
            com.aspose.slides.ms.System.a5.kg(this.kg, this.pr, count);
            ++this.k7;
        }
    }

    public void reverse() {
        mz.kg(this.kg, 0, this.pr);
        ++this.k7;
    }

    public void reverse(int index, int count) {
        this.kg(index, count);
        mz.kg(this.kg, index, count);
        ++this.k7;
    }

    public void sort() {
        Arrays.sort(this.kg, 0, this.pr);
        ++this.k7;
    }

    @Override
    public void sort(Comparator<? super T> comparer) {
        Arrays.sort(this.kg, 0, this.pr, comparer);
        ++this.k7;
    }

    @Override
    public void sort(o4<T> comparison) {
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        Arrays.sort(this.kg, 0, this.pr, new mz.kg<T>(comparison));
        ++this.k7;
    }

    public void sort(int index, int count, Comparator<T> comparer) {
        this.kg(index, count);
        Arrays.sort(this.kg, index, index + count, comparer);
        ++this.k7;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.pr) {
            return Arrays.copyOf(this.kg, this.pr, a.getClass());
        }
        System.arraycopy(this.kg, 0, a, 0, this.pr);
        if (a.length > this.pr) {
            a[this.pr] = null;
        }
        return a;
    }

    public void trimExcess() {
        this.setCapacity(this.pr);
    }

    public boolean trueForAll(lz<T> match) {
        List.kg(match);
        for (int i = 0; i < this.pr; ++i) {
            if (match.invoke(this.kg[i])) continue;
            return false;
        }
        return true;
    }

    public int getCapacity() {
        return this.kg.length;
    }

    public void setCapacity(int value) {
        if (((long)value & 0xFFFFFFFFL) < ((long)this.pr & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        this.kg = Arrays.copyOf(this.kg, value);
    }

    @Override
    public int size() {
        return this.pr;
    }

    @Override
    public T get_Item(int index) {
        if (((long)index & 0xFFFFFFFFL) >= ((long)this.pr & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        return (T)this.kg[index];
    }

    @Override
    public void set_Item(int index, T value) {
        this.pr(index);
        if ((long)index == (long)this.pr) {
            throw new ArgumentOutOfRangeException("Parameter name: index");
        }
        this.kg[index] = value;
        ++this.k7;
    }

    public void copyTo(a5 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.a5() > 1 || array.pr(0) != 0) {
            throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
        }
        com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg), 0, array, arrayIndex, this.pr);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized() {
        return false;
    }

    public Object getSyncRoot() {
        return this.a5;
    }

    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.pr == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            for (int i = 0; i < this.pr; ++i) {
                if (this.kg[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.pr; ++i) {
            if (!this.kg[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItem(T item) {
        if (item == null) {
            for (int i = 0; i < this.pr; ++i) {
                if (this.kg[i] != null) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.pr; ++i) {
            if (!this.kg[i].equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.pr];
        System.arraycopy(this.kg, 0, objectArray, 0, this.pr);
        return objectArray;
    }

    @Override
    public boolean add(T t) {
        int n = this.pr;
        this.addItem(t);
        return n != this.pr;
    }

    @Override
    public boolean remove(Object o) {
        int n = this.pr;
        this.removeItem(o);
        return n != this.pr;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object obj : c) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int n = 0;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        int n = index;
        int n10 = this.size();
        for (T t : c) {
            this.insertItem(n++, t);
        }
        return n10 != this.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        int n = this.size();
        for (Object obj : c) {
            this.remove(obj);
        }
        return n != this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Object[] objectArray;
        int n = this.size();
        for (Object object : objectArray = this.toArray()) {
            if (c.contains(object)) continue;
            this.remove(object);
        }
        return n != this.size();
    }

    @Override
    public T get(int index) {
        return this.get_Item(index);
    }

    @Override
    public T set(int index, T element) {
        T t = this.get_Item(index);
        this.set_Item(index, element);
        return t;
    }

    @Override
    public void add(int index, T element) {
        this.insertItem(index, element);
    }

    @Override
    public T remove(int index) {
        T t = this.get_Item(index);
        this.removeAt(index);
        return t;
    }

    @Override
    public int indexOf(Object o) {
        if (o == null) {
            for (int i = 0; i < this.pr; ++i) {
                if (this.kg[i] != null) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.pr; ++i) {
            if (!o.equals(this.kg[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public java.util.List<T> subList(int fromIndex, int toIndex) {
        int n = toIndex - fromIndex;
        return this.getRange(fromIndex, n);
    }

    public static <T> List<T> fromJava(java.util.List<T> list) {
        if (list == null) {
            return null;
        }
        return new ListInternalized<T>(list);
    }

    public static <T> java.util.List<T> toJava(List<T> list) {
        return list;
    }

    static class ListInternalized<T>
    extends List<T> {
        private java.util.List<T> kg;
        private int pr;

        public ListInternalized() {
            this.kg = new ArrayList<T>();
        }

        public ListInternalized(java.util.List<T> list) {
            super(list.size());
            for (T t : list) {
                super.addItem(t);
            }
            this.kg = list;
        }

        @Override
        protected int getVersion() {
            return this.pr;
        }

        @Override
        public void addRange(IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            this.kg(collection);
            ++this.pr;
        }

        @Override
        public void addRange(T[] collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            for (T t : collection) {
                this.addItem(t);
            }
            ++this.pr;
        }

        @Override
        public ReadOnlyCollection<T> asReadOnly() {
            return new ReadOnlyCollection(this);
        }

        @Override
        public int binarySearch(T item) {
            return mz.kg(this.kg.toArray(), 0, this.kg.size(), item);
        }

        @Override
        public int binarySearch(T item, Comparator<T> comparer) {
            return mz.kg(this.kg.toArray(), 0, this.kg.size(), item, comparer);
        }

        @Override
        public int binarySearch(int index, int count, T item, Comparator<T> comparer) {
            this.kg(index, count);
            return mz.kg(this.kg.toArray(), index, count, item, comparer);
        }

        @Override
        private void kg(int n, int n10) {
            if (n < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (n10 < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)n & 0xFFFFFFFFL) + ((long)n10 & 0xFFFFFFFFL) > ((long)this.kg.size() & 0xFFFFFFFFL)) {
                throw new ArgumentException("index and count exceed length of list");
            }
        }

        @Override
        public <TOutput> List<TOutput> convertAll(s6<T, TOutput> converter) {
            if (converter == null) {
                throw new ArgumentNullException("converter");
            }
            List list = new List(this.kg.size());
            for (int i = 0; i < this.kg.size(); ++i) {
                list.kg[i] = converter.kg(this.get_Item(i));
            }
            list.pr = this.kg.size();
            return list;
        }

        @Override
        public void copyTo(T[] array) {
            com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), 0, array, 0, this.kg.size());
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), 0, array, arrayIndex, this.kg.size());
        }

        @Override
        public void copyTo(int index, T[] array, int arrayIndex, int count) {
            this.kg(index, count);
            com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), index, array, arrayIndex, count);
        }

        @Override
        public boolean exists(lz<T> match) {
            ListInternalized.pr(match);
            return this.kg(0, this.kg.size(), match) != -1;
        }

        @Override
        private int kg(int n, int n10, lz<T> lz3) {
            int n11 = n + n10;
            for (int i = n; i < n11; ++i) {
                if (!lz3.invoke(this.kg.get(i))) continue;
                return i;
            }
            return -1;
        }

        static <T> void pr(lz<T> lz3) {
            if (lz3 == null) {
                throw new ArgumentNullException("match");
            }
        }

        @Override
        public T find(lz<T> match) {
            ListInternalized.pr(match);
            int n = this.kg(0, this.kg.size(), match);
            return n != -1 ? (T)this.kg.get(n) : null;
        }

        @Override
        public List<T> findAll(lz<T> match) {
            ListInternalized.pr(match);
            return this.k7(match);
        }

        private List<T> k7(lz<T> lz3) {
            List<T> list = new List<T>();
            for (int i = 0; i < this.size(); ++i) {
                if (!lz3.invoke(this.kg.get(i))) continue;
                list.addItem(this.kg.get(i));
            }
            return list;
        }

        @Override
        public int findIndex(lz<T> match) {
            ListInternalized.pr(match);
            return this.kg(0, this.kg.size(), match);
        }

        @Override
        public int findIndex(int startIndex, lz<T> match) {
            ListInternalized.pr(match);
            this.kg(startIndex);
            return this.kg(startIndex, this.kg.size() - startIndex, match);
        }

        @Override
        private void kg(int n) {
            if (n < 0 || ((long)n & 0xFFFFFFFFL) > ((long)this.kg.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
        }

        @Override
        public int findIndex(int startIndex, int count, lz<T> match) {
            ListInternalized.pr(match);
            this.kg(startIndex, count);
            return this.kg(startIndex, count, match);
        }

        @Override
        public T findLast(lz<T> match) {
            ListInternalized.pr(match);
            int n = this.pr(0, this.kg.size(), match);
            if (n == -1) {
                return null;
            }
            return this.get_Item(n);
        }

        @Override
        private int pr(int n, int n10, lz<T> lz3) {
            int n11 = n + n10;
            while (n11 != n) {
                if (!lz3.invoke(this.kg.get(--n11))) continue;
                return n11;
            }
            return -1;
        }

        @Override
        public int findLastIndex(lz<T> match) {
            ListInternalized.pr(match);
            return this.pr(0, this.kg.size(), match);
        }

        @Override
        public int findLastIndex(int startIndex, lz<T> match) {
            ListInternalized.pr(match);
            this.kg(startIndex);
            return this.pr(0, startIndex + 1, match);
        }

        @Override
        public int findLastIndex(int startIndex, int count, lz<T> match) {
            ListInternalized.pr(match);
            int n = startIndex - count + 1;
            this.kg(n, count);
            return this.pr(n, count, match);
        }

        @Override
        public void forEach(kg<T> action) {
            if (action == null) {
                throw new ArgumentNullException("action");
            }
            for (int i = 0; i < this.kg.size(); ++i) {
                action.invoke(this.kg.get(i));
            }
        }

        @Override
        public Enumerator<T> iterator() {
            return new Enumerator(this);
        }

        @Override
        public List<T> getRange(int index, int count) {
            this.kg(index, count);
            Object[] objectArray = new Object[count];
            com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), index, objectArray, 0, count);
            return new List(objectArray, count);
        }

        @Override
        public int indexOfItem(T item) {
            return this.kg.indexOf(item);
        }

        @Override
        public int indexOf(T item, int index) {
            this.kg(index);
            return com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), item, index, this.kg.size() - index);
        }

        @Override
        public int indexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("Parameter name: count");
            }
            if (((long)index & 0xFFFFFFFFL) + ((long)count & 0xFFFFFFFFL) > ((long)this.kg.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index and count exceed length of list");
            }
            return com.aspose.slides.ms.System.a5.kg(this.kg.toArray(), item, index, count);
        }

        @Override
        public int lastIndexOf(Object item) {
            if (this.kg.size() == 0) {
                return -1;
            }
            return mz.kg(this.kg.toArray(), item, this.kg.size() - 1, this.kg.size());
        }

        @Override
        public int lastIndexOf(T item, int index) {
            this.kg(index);
            return mz.kg(this.kg.toArray(), item, index, index + 1);
        }

        @Override
        public int lastIndexOf(T item, int index, int count) {
            if (index < 0) {
                throw new ArgumentOutOfRangeException("index", index, "index is negative");
            }
            if (count < 0) {
                throw new ArgumentOutOfRangeException("count", count, "count is negative");
            }
            if (index - count + 1 < 0) {
                throw new ArgumentOutOfRangeException("cound", count, "count is too large");
            }
            return mz.kg(this.kg.toArray(), item, index, count);
        }

        @Override
        public boolean removeItem(T item) {
            int n = this.indexOfItem(item);
            if (n != -1) {
                this.removeAt(n);
            }
            return n != -1;
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.kg.toArray(a);
        }

        @Override
        public void trimExcess() {
            this.setCapacity(this.kg.size());
        }

        @Override
        public boolean trueForAll(lz<T> match) {
            ListInternalized.pr(match);
            for (int i = 0; i < this.kg.size(); ++i) {
                if (match.invoke(this.kg.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public int getCapacity() {
            return this.kg.size();
        }

        @Override
        public void setCapacity(int value) {
            if (((long)value & 0xFFFFFFFFL) < ((long)this.kg.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException();
            }
            for (int i = 0; i < value - this.kg.size(); ++i) {
                this.kg.add(null);
            }
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public T get_Item(int index) {
            return this.kg.get(index);
        }

        @Override
        public void copyTo(a5 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array");
            }
            if (array.a5() > 1 || array.pr(0) != 0) {
                throw new ArgumentException("Array must be zero based and single dimentional\r\nParameter name: array");
            }
            com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg.toArray()), 0, array, arrayIndex, this.kg.size());
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        @Override
        public boolean isSynchronized() {
            return false;
        }

        @Override
        public Object getSyncRoot() {
            return this;
        }

        @Override
        public boolean isFixedSize() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.size() != 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = 0; i < this.kg.size(); ++i) {
                    if (this.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.kg.size(); ++i) {
                if (!this.get(i).equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsItem(T item) {
            if (item == null) {
                for (int i = 0; i < this.kg.size(); ++i) {
                    if (this.kg.get(i) != null) continue;
                    return true;
                }
                return false;
            }
            for (int i = 0; i < this.kg.size(); ++i) {
                if (!this.kg.get(i).equals(item)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.kg.toArray();
        }

        @Override
        public boolean add(T t) {
            ++this.pr;
            return this.kg.add(t);
        }

        @Override
        public boolean remove(Object o) {
            ++this.pr;
            return this.kg.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.kg.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            ++this.pr;
            return this.kg.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            ++this.pr;
            return this.kg.addAll(index, c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            ++this.pr;
            return this.kg.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            ++this.pr;
            return this.kg.retainAll(c);
        }

        @Override
        public T get(int index) {
            return this.kg.get(index);
        }

        @Override
        public T set(int index, T element) {
            ++this.pr;
            return this.kg.set(index, element);
        }

        @Override
        public void add(int index, T element) {
            ++this.pr;
            this.kg.add(index, element);
        }

        @Override
        public T remove(int index) {
            ++this.pr;
            return this.kg.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.kg.indexOf(o);
        }

        @Override
        public ListIterator listIterator() {
            return this.kg.listIterator();
        }

        @Override
        public ListIterator listIterator(int index) {
            return this.kg.listIterator(index);
        }

        @Override
        public java.util.List<T> subList(int fromIndex, int toIndex) {
            return this.kg.subList(fromIndex, toIndex);
        }

        @Override
        public void addItem(T item) {
            this.kg.add(item);
            ++this.pr;
        }

        @Override
        public void clear() {
            this.kg.clear();
            ++this.pr;
        }

        @Override
        public void insertItem(int index, T item) {
            this.kg.add(index, item);
            ++this.pr;
        }

        @Override
        public void insertRange(int index, IGenericEnumerable<T> collection) {
            if (collection == null) {
                throw new ArgumentNullException("collection");
            }
            if (index < 0 || ((long)index & 0xFFFFFFFFL) > ((long)this.kg.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            int n = index;
            if (collection == this) {
                Object[] objectArray = new Object[this.size()];
                this.copyTo(objectArray);
                for (Object object : objectArray) {
                    this.kg.add(n++, object);
                }
            } else {
                for (Object e : collection) {
                    this.kg.add(n++, e);
                }
            }
            ++this.pr;
        }

        @Override
        public int removeAll(lz<T> match) {
            ListInternalized.pr(match);
            int n = 0;
            int n10 = 0;
            for (n = 0; n < this.kg.size() && !match.invoke(this.kg.get(n)); ++n) {
            }
            if (n == this.kg.size()) {
                return 0;
            }
            ++this.pr;
            for (n10 = n + 1; n10 < this.kg.size(); ++n10) {
                if (match.invoke(this.kg.get(n10))) continue;
                this.kg.set(n++, this.kg.get(n10));
            }
            if (n10 - n > 0) {
                for (int i = 0; i < n10 - n; ++i) {
                    this.kg.remove(this.kg.size() - 1);
                }
            }
            return n10 - n;
        }

        @Override
        public void removeAt(int index) {
            if (index < 0 || ((long)index & 0xFFFFFFFFL) >= ((long)this.kg.size() & 0xFFFFFFFFL)) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.kg.remove(index);
            ++this.pr;
        }

        @Override
        public void removeRange(int index, int count) {
            this.kg(index, count);
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    this.kg.remove(index);
                }
                ++this.pr;
            }
        }

        @Override
        public void reverse() {
            this.reverse(0, this.size());
        }

        @Override
        public void reverse(int index, int count) {
            this.kg(index, count);
            int n = index;
            for (int i = index + count - 1; n < i; ++n, --i) {
                T t = this.kg.get(n);
                this.kg.set(n, this.kg.get(i));
                this.kg.set(i, t);
            }
            ++this.pr;
        }

        @Override
        public void sort() {
            Collections.sort(this.kg, null);
            ++this.pr;
        }

        @Override
        public void sort(Comparator<? super T> comparer) {
            Collections.sort(this.kg, comparer);
            ++this.pr;
        }

        @Override
        public void sort(final o4<T> tComparison) {
            if (tComparison == null) {
                throw new ArgumentNullException("comparison");
            }
            Collections.sort(this.kg, new Comparator<T>(){

                @Override
                public int compare(T o12, T o22) {
                    return tComparison.kg(o12, o22);
                }
            });
            ++this.pr;
        }

        @Override
        public void sort(int index, int count, Comparator<T> comparer) {
            this.kg(index, count);
            java.util.List<T> list = this.kg.subList(index, count);
            Collections.sort(list, comparer);
            for (int i = 0; i < count; ++i) {
                this.kg.set(index + i, list.get(i));
            }
            ++this.pr;
        }

        @Override
        public void set_Item(int index, T value) {
            this.kg(index);
            if ((long)index == (long)this.kg.size()) {
                throw new ArgumentOutOfRangeException("Parameter name: index");
            }
            this.kg.set(index, value);
            ++this.pr;
        }

        @Override
        private void kg(IGenericEnumerable<T> iGenericEnumerable) {
            for (Object t : iGenericEnumerable) {
                this.addItem(t);
            }
        }
    }

    @Deprecated
    @fc
    public static class EnumeratorJava<T>
    extends ud<EnumeratorJava<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> pr = new List();
        private int k7;
        private int a5;
        private T b0;

        public EnumeratorJava() {
        }

        EnumeratorJava(List<T> l) {
            this();
            this.pr = l;
            this.a5 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void kg() {
            if (this.a5 != this.pr.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public T next() {
            if (this.k7 < 0 || this.k7 >= this.pr.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            if (this.a5 != this.pr.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.b0 = this.pr.get_Item(this.k7++);
            return this.b0;
        }

        @Override
        public boolean hasNext() {
            if (this.a5 == this.pr.getVersion()) {
                if (this.k7 < 0) {
                    return false;
                }
                return this.k7 < this.pr.size();
            }
            throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
        }

        @Override
        public void reset() {
            this.kg();
            this.k7 = 0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(EnumeratorJava<T> that) {
            that.pr = this.pr;
            that.k7 = this.k7;
            that.a5 = this.a5;
            that.b0 = this.b0;
        }

        @Override
        public EnumeratorJava<T> Clone() {
            EnumeratorJava<T> enumeratorJava = new EnumeratorJava<T>();
            this.CloneTo(enumeratorJava);
            return enumeratorJava;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean kg(EnumeratorJava enumeratorJava) {
            return lv.kg(enumeratorJava.pr, this.pr) && enumeratorJava.k7 == this.k7 && enumeratorJava.a5 == this.a5 && lv.kg(enumeratorJava.b0, this.b0);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (lv.pr(null, obj)) {
                return false;
            }
            if (lv.pr(this, obj)) {
                return true;
            }
            if (!(obj instanceof EnumeratorJava)) {
                return false;
            }
            return this.kg((EnumeratorJava)obj);
        }

        public static boolean equals(EnumeratorJava obj1, EnumeratorJava obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.pr != null ? this.pr.hashCode() : 0;
            n = 31 * n + this.k7;
            n = 31 * n + this.a5;
            n = 31 * n + (this.b0 != null ? this.b0.hashCode() : 0);
            return n;
        }
    }

    @fc
    public static class Enumerator<T>
    extends ud<Enumerator<T>>
    implements IGenericEnumerator<T>,
    IDisposable {
        private List<T> pr = new List();
        private int k7;
        private int a5;
        private T b0;

        public Enumerator() {
        }

        Enumerator(List<T> l) {
            this();
            this.pr = l;
            this.a5 = l.getVersion();
        }

        @Override
        public void dispose() {
        }

        private void kg() {
            if (this.a5 != this.pr.getVersion()) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.a5 == this.pr.getVersion()) {
                if (this.k7 < 0) {
                    return false;
                }
                if (this.k7 < this.pr.size()) {
                    this.b0 = this.pr.get_Item(this.k7++);
                    return true;
                }
            } else {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute.");
            }
            this.k7 = this.pr.size() + 1;
            return false;
        }

        @Override
        public void reset() {
            this.kg();
            this.k7 = 0;
        }

        @Override
        public T next() {
            if (this.k7 < 0 || this.k7 >= this.pr.size() + 1) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished.");
            }
            return this.b0;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator<T> that) {
            that.pr = this.pr;
            that.k7 = this.k7;
            that.a5 = this.a5;
            that.b0 = this.b0;
        }

        @Override
        public Enumerator<T> Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean kg(Enumerator enumerator) {
            return lv.kg(enumerator.pr, this.pr) && enumerator.k7 == this.k7 && enumerator.a5 == this.a5 && lv.kg(enumerator.b0, this.b0);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (lv.pr(null, obj)) {
                return false;
            }
            if (lv.pr(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.kg((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.pr != null ? this.pr.hashCode() : 0;
            n = 31 * n + this.k7;
            n = 31 * n + this.a5;
            n = 31 * n + (this.b0 != null ? this.b0.hashCode() : 0);
            return n;
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator {
        ListItr(int index) {
            this.kg = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.kg != 0;
        }

        @Override
        public int nextIndex() {
            return this.kg;
        }

        @Override
        public int previousIndex() {
            return this.kg - 1;
        }

        public T previous() {
            int n = this.kg - 1;
            if (n < 0) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.kg;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.kg = n;
            this.pr = n;
            return objectArray[this.pr];
        }

        public void set(T e) {
            if (this.pr < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.set(this.pr, e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        public void add(T e) {
            try {
                int n = this.kg;
                List.this.add(n, e);
                this.kg = n + 1;
                this.pr = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        int kg;
        int pr = -1;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.kg != List.this.pr;
        }

        @Override
        public T next() {
            int n = this.kg;
            if (n >= List.this.pr) {
                throw new NoSuchElementException();
            }
            Object[] objectArray = List.this.kg;
            if (n >= objectArray.length) {
                throw new ConcurrentModificationException();
            }
            this.kg = n + 1;
            this.pr = n;
            return (T)objectArray[this.pr];
        }

        @Override
        public void remove() {
            if (this.pr < 0) {
                throw new IllegalStateException();
            }
            try {
                List.this.remove(this.pr);
                this.kg = this.pr;
                this.pr = -1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

