/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Generic;

import com.aspose.slides.Collections.Generic.IGenericCollection;
import com.aspose.slides.Collections.Generic.IGenericEnumerable;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.ArrayTypeMismatchException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.internal.po.k7;
import com.aspose.slides.internal.po.ud;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.fc;
import com.aspose.slides.ms.System.lv;
import com.aspose.slides.ms.System.mz;
import java.util.Arrays;

@fc
public class Stack<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] kg;
    private int pr;
    private int k7;

    public Stack() {
    }

    public Stack(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.kg = new Object[capacity];
    }

    public Stack(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        for (Object t : collection) {
            this.push(t);
        }
    }

    public Stack(IGenericCollection<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        if (collection != null) {
            this.pr = collection.size();
            this.kg = new Object[this.pr];
            collection.copyToTArray(this.kg, 0);
        }
    }

    public void clear() {
        if (this.kg != null) {
            a5.kg(this.kg, 0, this.kg.length);
        }
        this.pr = 0;
        ++this.k7;
    }

    public boolean contains(T item) {
        return this.kg != null && a5.kg(this.kg, item, 0, this.pr) != -1;
    }

    public void copyToTArray(T[] array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (arrayIndex >= array.length) {
            throw new ArgumentOutOfRangeException("idx");
        }
        if (this.pr - arrayIndex > array.length) {
            throw new ArgumentException("idx");
        }
        if (this.kg != null) {
            a5.kg(this.kg, 0, array, arrayIndex, this.pr);
            mz.kg(array, arrayIndex, this.pr);
        }
    }

    public T peek() {
        if (this.pr == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.kg[this.pr - 1];
    }

    public T pop() {
        if (this.pr == 0) {
            throw new InvalidOperationException();
        }
        ++this.k7;
        Object object = this.kg[--this.pr];
        this.kg[this.pr] = null;
        return (T)object;
    }

    public void push(T item) {
        if (this.kg == null || this.pr == this.kg.length) {
            if (this.kg == null) {
                this.kg = new Object[16];
            }
            this.kg = Arrays.copyOf(this.kg, this.pr == 0 ? 16 : 2 * this.pr);
        }
        ++this.k7;
        this.kg[this.pr++] = item;
    }

    public <T> T[] toArray(T[] array) {
        if (array.length >= this.pr) {
            this.copyTo(a5.kg(array), 0);
            return array;
        }
        a5 a52 = a5.kg(com.aspose.slides.internal.po.k7.kg(array.getClass().getComponentType()), this.pr);
        this.copyTo(a52, 0);
        return (Object[])a5.kg(a52);
    }

    public void trimExcess() {
        if (this.kg != null && (double)this.pr < (double)this.kg.length * 0.9) {
            this.kg = Arrays.copyOf(this.kg, this.pr);
        }
        ++this.k7;
    }

    @Override
    public int size() {
        return this.pr;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(a5 dest, int idx) {
        try {
            if (dest == null) {
                throw new ArgumentNullException();
            }
            if (this.kg != null) {
                if (idx < 0) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (idx >= this.pr) {
                    throw new ArgumentOutOfRangeException("idx");
                }
                if (this.pr - idx > dest.b0()) {
                    throw new ArgumentException("idx");
                }
                a5.kg(a5.kg(this.kg), 0, dest, idx, this.pr);
                a5.pr(dest, idx, this.pr);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    @Override
    public Enumerator<T> iterator() {
        return new Enumerator(this);
    }

    @fc
    public static class Enumerator<T>
    extends ud<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private Stack<T> pr;
        private int k7;
        private int a5;

        public Enumerator() {
        }

        Enumerator(Stack<T> t) {
            this.pr = t;
            this.k7 = -2;
            this.a5 = ((Stack)t).k7;
        }

        @Override
        public void dispose() {
            this.k7 = -1;
        }

        @Override
        public boolean hasNext() {
            if (this.a5 != ((Stack)this.pr).k7) {
                throw new IllegalStateException();
            }
            if (this.k7 == -2) {
                this.k7 = ((Stack)this.pr).pr;
            }
            return this.k7 != -1 && --this.k7 != -1;
        }

        @Override
        public T next() {
            if (this.k7 < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Stack)this.pr).kg[this.k7];
        }

        @Override
        public void reset() {
            if (this.a5 != ((Stack)this.pr).k7) {
                throw new IllegalStateException();
            }
            this.k7 = -2;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.pr = this.pr;
            that.k7 = this.k7;
            that.a5 = this.a5;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean kg(Enumerator enumerator) {
            return lv.kg(enumerator.pr, this.pr) && enumerator.k7 == this.k7 && enumerator.a5 == this.a5;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (lv.pr(null, obj)) {
                return false;
            }
            if (lv.pr(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.kg((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.pr != null ? this.pr.hashCode() : 0;
            n = 31 * n + this.k7;
            n = 31 * n + this.a5;
            return n;
        }
    }
}

