/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.Generic.IGenericEqualityComparer;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IHashCodeProvider;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.exceptions.SerializationException;
import com.aspose.slides.internal.cl.kg;
import com.aspose.slides.internal.cl.pr;
import com.aspose.slides.internal.jv.f8;
import com.aspose.slides.internal.jv.j1;
import com.aspose.slides.internal.jv.mn;
import com.aspose.slides.internal.jv.ud;
import com.aspose.slides.internal.jv.uy;
import com.aspose.slides.internal.mh.gn;
import com.aspose.slides.internal.po.k7;
import com.aspose.slides.internal.po.sk;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.cu;
import com.aspose.slides.ms.System.fc;
import com.aspose.slides.ms.System.lv;
import com.aspose.slides.ms.System.m9;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@fc
public class Hashtable
implements ICollection,
IDictionary,
IEnumerable,
f8,
ud,
cu,
Map {
    private IGenericEqualityComparer kg;
    private final Object pr = new Object();
    private Bucket[] k7;
    private int a5;
    private volatile boolean b0;
    private ICollection sk;
    private float ud;
    private int lc;
    private j1 gn;
    private int f8;
    private ICollection pb;
    private volatile int ji;
    private static final sk d9 = new sk("LoadFactor", "HashSize", "KeyComparer", "Comparer", "HashCodeProvider", "Keys", "Values");

    public Hashtable() {
        this(0, 1.0f);
    }

    Hashtable(boolean trash) {
    }

    public Hashtable(IDictionary d) {
        this(d, 1.0f);
    }

    public Hashtable(IGenericEqualityComparer equalityComparer) {
        this(0, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity) {
        this(capacity, 1.0f);
    }

    public Hashtable(IDictionary d, IGenericEqualityComparer equalityComparer) {
        this(d, 1.0f, equalityComparer);
    }

    public Hashtable(IDictionary d, float loadFactor) {
        this(d, loadFactor, (IGenericEqualityComparer)null);
    }

    @Deprecated
    public Hashtable(IHashCodeProvider hcp, Comparator comparer) {
        this(0, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, IGenericEqualityComparer equalityComparer) {
        this(capacity, 1.0f, equalityComparer);
    }

    public Hashtable(int capacity, float loadFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Non-negative number required");
        }
        if (loadFactor < 0.1f || loadFactor > 1.0f || Float.isNaN(loadFactor)) {
            throw new ArgumentOutOfRangeException("loadFactor", m9.kg("Load factor needs to be between {0} and {1}", 0.1, 1.0));
        }
        this.ud = 0.72f * loadFactor;
        double d = (float)capacity / this.ud;
        if (d > 2.147483647E9) {
            throw new ArgumentException("Hashtable's capacity overflowed and went negative. Check load factor, capacity and the current size of the table");
        }
        int n = d > 11.0 ? com.aspose.slides.internal.cl.kg.kg((int)d) : 11;
        this.k7 = this.pr(n);
        this.lc = (int)(this.ud * (float)n);
        this.b0 = false;
    }

    protected Hashtable(j1 info, mn context) {
        this.gn = info;
    }

    @Deprecated
    public Hashtable(IDictionary d, IHashCodeProvider hcp, Comparator comparer) {
        this(d, 1.0f, hcp, comparer);
    }

    public Hashtable(IDictionary d, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(d != null ? d.size() : 0, loadFactor, equalityComparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, 1.0f, hcp, comparer);
    }

    public Hashtable(int capacity, float loadFactor, IGenericEqualityComparer equalityComparer) {
        this(capacity, loadFactor);
        this.kg = equalityComparer;
    }

    @Deprecated
    public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(d != null ? d.size() : 0, loadFactor, hcp, comparer);
        if (d == null) {
            throw new ArgumentNullException("d", "Dictionary cannot be null");
        }
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Deprecated
    public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, Comparator comparer) {
        this(capacity, loadFactor);
        this.kg = hcp == null && comparer == null ? null : new CompatibleComparer(comparer, hcp);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.kg(key, value, true);
    }

    @Override
    public void clear() {
        if (this.a5 != 0) {
            this.b0 = true;
            for (int i = 0; i < this.k7.length; ++i) {
                this.k7[i].k7 = 0;
                this.k7[i].kg = null;
                this.k7[i].pr = null;
            }
            this.a5 = 0;
            this.f8 = 0;
            this.a5();
            this.b0 = false;
        }
    }

    @Override
    public Object deepClone() {
        Bucket[] bucketArray = this.k7;
        Hashtable hashtable = new Hashtable(this.a5, this.kg);
        hashtable.ji = this.ji;
        hashtable.ud = this.ud;
        hashtable.a5 = 0;
        int n = this.k7.length;
        while (n > 0) {
            Object object = bucketArray[--n].kg;
            if (object == null || object == bucketArray) continue;
            hashtable.set_Item(object, bucketArray[n].pr);
        }
        return hashtable;
    }

    @Override
    public boolean contains(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKey(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.k7;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.kg(key, this.k7.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.k7.length);
        do {
            bucketArray[n10].kg(bucket);
            if (bucket.kg == null) {
                return false;
            }
            if ((long)(bucket.k7 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.kg, key)) {
                return true;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.k7.length);
        } while (bucket.k7 < 0 && ++n < this.k7.length);
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            int n = this.k7.length;
            while (--n >= 0) {
                if (this.k7[n].kg == null || this.k7[n].kg == this.k7 || this.k7[n].pr != null) continue;
                return true;
            }
        } else {
            int n = this.k7.length;
            while (--n >= 0) {
                Object object = this.k7[n].pr;
                if (object == null || !object.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void k7(a5 a52, int n) {
        Bucket[] bucketArray = this.k7;
        int n10 = this.k7.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].kg;
            if (object == null || object == this.k7) continue;
            DictionaryEntry dictionaryEntry = new DictionaryEntry(object, bucketArray[n10].pr);
            a52.k7(dictionaryEntry.Clone(), n++);
        }
    }

    void kg(a5 a52, int n) {
        Bucket[] bucketArray = this.k7;
        int n10 = this.k7.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].kg;
            if (object == null || object == this.k7) continue;
            a52.k7(object, n++);
        }
    }

    @Override
    public void copyTo(a5 array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException("array", "Array cannot be null");
        }
        if (array.a5() != 1) {
            throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
        }
        if (array.b0() - arrayIndex < this.a5) {
            throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
        }
        this.k7(array, arrayIndex);
    }

    void pr(a5 a52, int n) {
        Bucket[] bucketArray = this.k7;
        int n10 = this.k7.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].kg;
            if (object == null || object == this.k7) continue;
            a52.k7(bucketArray[n10].pr, n++);
        }
    }

    private void pr() {
        int n = com.aspose.slides.internal.cl.kg.kg(this.k7.length * 2);
        this.kg(n);
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new HashtableEnumerator(this, 3);
    }

    protected int getHash(Object key) {
        if (this.kg != null) {
            return this.kg.hashCode(key);
        }
        return key.hashCode();
    }

    @Override
    public void getObjectData(j1 info, mn context) {
        Object[] objectArray;
        if (info == null) {
            throw new ArgumentNullException("info");
        }
        info.kg("LoadFactor", this.ud);
        info.kg("Version", this.ji);
        if (this.kg == null) {
            info.kg("Comparer", null, com.aspose.slides.internal.po.k7.kg(Comparator.class));
            info.kg("HashCodeProvider", null, com.aspose.slides.internal.po.k7.kg(IHashCodeProvider.class));
        } else if (this.kg instanceof CompatibleComparer) {
            objectArray = (Object[])com.aspose.slides.internal.po.k7.kg(this.kg, CompatibleComparer.class);
            info.kg("Comparer", objectArray.kg(), com.aspose.slides.internal.po.k7.kg(Comparator.class));
            info.kg("HashCodeProvider", objectArray.pr(), com.aspose.slides.internal.po.k7.kg(IHashCodeProvider.class));
        } else {
            info.kg("KeyComparer", this.kg, com.aspose.slides.internal.po.k7.kg(IGenericEqualityComparer.class));
        }
        info.kg("HashSize", this.k7.length);
        objectArray = new Object[this.a5];
        Object[] objectArray2 = new Object[this.a5];
        this.kg(com.aspose.slides.ms.System.a5.kg(objectArray), 0);
        this.pr(com.aspose.slides.ms.System.a5.kg(objectArray2), 0);
        info.kg("Keys", objectArray, com.aspose.slides.internal.po.k7.kg(Object[].class));
        info.kg("Values", objectArray2, com.aspose.slides.internal.po.k7.kg(Object[].class));
    }

    private long kg(Object object, int n, long[] lArray, long[] lArray2) {
        long l;
        lArray[0] = l = (long)(this.getHash(object) & Integer.MAX_VALUE);
        lArray2[0] = 1L + (((lArray[0] & 0xFFFFFFFFL) >> 5) + 1L) % (long)(n - 1);
        return l;
    }

    private void kg(Object object, Object object2, boolean bl2) {
        block12: {
            long l = 0L;
            long l10 = 0L;
            if (object == null) {
                throw new ArgumentNullException("key", "Key cannot be null");
            }
            if (this.a5 >= this.lc) {
                this.pr();
            } else if (this.f8 > this.lc && this.a5 > 100) {
                this.k7();
            }
            long[] lArray = new long[]{0L};
            long[] lArray2 = new long[]{0L};
            long l11 = this.kg(object, this.k7.length, lArray, lArray2);
            l = lArray[0];
            l10 = lArray2[0];
            int n = 0;
            int n10 = -1;
            int n11 = (int)((l & 0xFFFFFFFFL) % (long)this.k7.length);
            do {
                if (n10 == -1 && this.k7[n11].kg == this.k7 && this.k7[n11].k7 < 0) {
                    n10 = n11;
                }
                if (this.k7[n11].kg == null || this.k7[n11].kg == this.k7 && ((long)this.k7[n11].k7 & 0x80000000L) == 0L) {
                    if (n10 != -1) {
                        n11 = n10;
                    }
                    this.b0 = true;
                    this.k7[n11].pr = object2;
                    this.k7[n11].kg = object;
                    this.k7[n11].k7 |= (int)(l11 & 0xFFFFFFFFL);
                    ++this.a5;
                    this.a5();
                    this.b0 = false;
                    break block12;
                }
                if ((long)(this.k7[n11].k7 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(this.k7[n11].kg, object)) {
                    if (bl2) {
                        throw new ArgumentException(m9.kg("Item has already been added. Key in dictionary: '{0}'  Key being added: '{1}'", this.k7[n11].kg, object));
                    }
                    this.b0 = true;
                    this.k7[n11].pr = object2;
                    this.a5();
                    this.b0 = false;
                    break block12;
                }
                if (n10 == -1 && this.k7[n11].k7 >= 0) {
                    this.k7[n11].k7 = (int)((long)this.k7[n11].k7 | Integer.MIN_VALUE);
                    ++this.f8;
                }
                n11 = (int)(((long)n11 + (l10 & 0xFFFFFFFFL)) % (long)this.k7.length);
            } while (++n < this.k7.length);
            if (n10 == -1) {
                throw new InvalidOperationException("Hashtable insert failed. Load factor too high.");
            }
            this.b0 = true;
            this.k7[n10].pr = object2;
            this.k7[n10].kg = object;
            this.k7[n10].k7 |= (int)(l11 & 0xFFFFFFFFL);
            ++this.a5;
            this.a5();
            this.b0 = false;
        }
    }

    protected boolean keyEquals(Object item, Object key) {
        if (lv.pr(this.k7, item)) {
            return false;
        }
        if (this.kg != null) {
            return this.kg.equals(item, key);
        }
        return item != null && item.equals(key);
    }

    @Override
    public void onDeserialization(Object sender) {
        if (this.k7 == null) {
            if (this.gn == null) {
                throw new SerializationException("OnDeserialization method was called while the object was not being deserialized.");
            }
            int n = 0;
            Comparator comparator = null;
            IHashCodeProvider iHashCodeProvider = null;
            Object[] objectArray = null;
            Object[] objectArray2 = null;
            uy uy2 = this.gn.a5();
            while (uy2.hasNext()) {
                switch (d9.kg(uy2.pr())) {
                    case 0: {
                        this.ud = this.gn.pr("LoadFactor");
                        break;
                    }
                    case 1: {
                        n = this.gn.kg("HashSize");
                        break;
                    }
                    case 2: {
                        this.kg = (IGenericEqualityComparer)this.gn.kg("KeyComparer", com.aspose.slides.internal.po.k7.kg(IGenericEqualityComparer.class));
                        break;
                    }
                    case 3: {
                        comparator = (Comparator)this.gn.kg("Comparer", com.aspose.slides.internal.po.k7.kg(Comparator.class));
                        break;
                    }
                    case 4: {
                        iHashCodeProvider = (IHashCodeProvider)this.gn.kg("HashCodeProvider", com.aspose.slides.internal.po.k7.kg(IHashCodeProvider.class));
                        break;
                    }
                    case 5: {
                        objectArray = (Object[])this.gn.kg("Keys", com.aspose.slides.internal.po.k7.kg(Object[].class));
                        break;
                    }
                    case 6: {
                        objectArray2 = (Object[])this.gn.kg("Values", com.aspose.slides.internal.po.k7.kg(Object[].class));
                    }
                }
            }
            this.lc = (int)(this.ud * (float)n);
            if (this.kg == null && (comparator != null || iHashCodeProvider != null)) {
                this.kg = new CompatibleComparer(comparator, iHashCodeProvider);
            }
            this.k7 = this.pr(n);
            if (objectArray == null) {
                throw new SerializationException("The Keys for this dictionary are missing");
            }
            if (objectArray2 == null) {
                throw new SerializationException("The Values for this dictionary are missing");
            }
            if (objectArray.length != objectArray2.length) {
                throw new SerializationException("The keys and values arrays have different sizes");
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) {
                    throw new SerializationException("One of the serialized keys is null");
                }
                this.kg(objectArray[i], objectArray2[i], true);
            }
            this.ji = this.gn.kg("Version");
            this.gn = null;
        }
    }

    private void kg(Bucket[] bucketArray, Object object, Object object2, int n) {
        long l = 1L + ((((long)n & 0xFFFFFFFFL) >> 5) + 1L) % (long)(bucketArray.length - 1);
        int n10 = (int)(((long)n & 0xFFFFFFFFL) % (long)bucketArray.length);
        while (true) {
            if (bucketArray[n10].kg == null || bucketArray[n10].kg == this.k7) {
                bucketArray[n10].pr = object2;
                bucketArray[n10].kg = object;
                bucketArray[n10].k7 |= n;
                break;
            }
            if (bucketArray[n10].k7 >= 0) {
                bucketArray[n10].k7 = (int)((long)bucketArray[n10].k7 | Integer.MIN_VALUE);
                ++this.f8;
            }
            n10 = (int)(((long)n10 + (l & 0xFFFFFFFFL)) % (long)bucketArray.length);
        }
    }

    private void k7() {
        this.kg(this.k7.length);
    }

    private void kg(int n) {
        this.f8 = 0;
        Bucket[] bucketArray = this.pr(n);
        for (int i = 0; i < this.k7.length; ++i) {
            Bucket bucket = this.k7[i].kg();
            if (bucket.kg == null || bucket.kg == this.k7) continue;
            this.kg(bucketArray, bucket.kg, bucket.pr, bucket.k7 & Integer.MAX_VALUE);
        }
        this.b0 = true;
        this.k7 = bucketArray;
        this.lc = (int)(this.ud * (float)n);
        this.a5();
        this.b0 = false;
    }

    @Override
    public void removeItem(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.kg(key, this.k7.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.k7.length);
        do {
            this.k7[n10].kg(bucket);
            if ((long)(bucket.k7 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.kg, key)) {
                this.b0 = true;
                this.k7[n10].k7 = (int)((long)this.k7[n10].k7 & Integer.MIN_VALUE);
                this.k7[n10].kg = this.k7[n10].k7 != 0 ? this.k7 : null;
                this.k7[n10].pr = null;
                --this.a5;
                this.a5();
                this.b0 = false;
                break;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.k7.length);
        } while (bucket.k7 < 0 && ++n < this.k7.length);
    }

    public static Hashtable sync(Hashtable table) {
        if (table == null) {
            throw new ArgumentNullException("table");
        }
        return new SyncHashtable(table);
    }

    KeyValuePairs[] kg() {
        KeyValuePairs[] keyValuePairsArray = new KeyValuePairs[this.a5];
        int n = 0;
        Bucket[] bucketArray = this.k7;
        int n10 = this.k7.length;
        while (--n10 >= 0) {
            Object object = bucketArray[n10].kg;
            if (object == null || object == this.k7) continue;
            keyValuePairsArray[n++] = new KeyValuePairs(object, bucketArray[n10].pr);
        }
        return keyValuePairsArray;
    }

    private void a5() {
        ++this.ji;
    }

    private Bucket[] pr(int n) {
        Bucket[] bucketArray = new Bucket[n];
        for (int i = 0; i < bucketArray.length; ++i) {
            bucketArray[i] = new Bucket();
        }
        return bucketArray;
    }

    @Override
    public int size() {
        return this.a5;
    }

    protected IGenericEqualityComparer getEqualityComparer() {
        return this.kg;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object get_Item(Object key) {
        long l = 0L;
        long l10 = 0L;
        Bucket bucket = new Bucket();
        if (key == null) {
            throw new ArgumentNullException("key", "Key cannot be null");
        }
        Bucket[] bucketArray = this.k7;
        long[] lArray = new long[]{0L};
        long[] lArray2 = new long[]{0L};
        long l11 = this.kg(key, this.k7.length, lArray, lArray2);
        l = lArray[0];
        l10 = lArray2[0];
        int n = 0;
        int n10 = (int)((l & 0xFFFFFFFFL) % (long)this.k7.length);
        do {
            int n11;
            int n12 = 0;
            do {
                n11 = this.ji;
                bucketArray[n10].kg(bucket);
                if (++n12 % 8 != 0) continue;
                com.aspose.slides.internal.mh.gn.pr(1);
            } while (this.b0 || n11 != this.ji);
            if (bucket.kg == null) break;
            if ((long)(bucket.k7 & Integer.MAX_VALUE) == (l11 & 0xFFFFFFFFL) && this.keyEquals(bucket.kg, key)) {
                return bucket.pr;
            }
            n10 = (int)(((long)n10 + (l10 & 0xFFFFFFFFL)) % (long)this.k7.length);
        } while (bucket.k7 < 0 && ++n < this.k7.length);
        return null;
    }

    @Override
    public void set_Item(Object key, Object value) {
        this.kg(key, value, false);
    }

    @Override
    public ICollection getKeys() {
        if (this.sk == null) {
            this.sk = new KeyCollection(this);
        }
        return this.sk;
    }

    @Override
    public Object getSyncRoot() {
        return this.pr;
    }

    @Override
    public ICollection getValues() {
        if (this.pb == null) {
            this.pb = new ValueCollection(this);
        }
        return this.pb;
    }

    @Override
    public boolean isEmpty() {
        return this.a5 == 0;
    }

    public Object get(Object key) {
        return this.get_Item(key);
    }

    public Object put(Object key, Object value) {
        Object object = this.get_Item(key);
        this.set_Item(key, value);
        return object;
    }

    public Object remove(Object key) {
        Object object = this.get_Item(key);
        this.removeItem(key);
        return object;
    }

    public void putAll(Map m) {
        Set set = m.keySet();
        for (Object k : set) {
            Object v = m.get(k);
            this.put(k, v);
        }
    }

    public Set keySet() {
        Object[] objectArray = new Object[this.size()];
        a5 a52 = com.aspose.slides.ms.System.a5.kg(objectArray);
        this.getKeys().copyTo(a52, 0);
        return new ReadOnlyItemCollection(a52);
    }

    public Collection values() {
        Object[] objectArray = new Object[this.size()];
        a5 a52 = com.aspose.slides.ms.System.a5.kg(objectArray);
        this.getValues().copyTo(a52, 0);
        return new ReadOnlyItemCollection(a52);
    }

    public Set entrySet() {
        KeyValuePairs[] keyValuePairsArray = this.kg();
        Map.Entry[] entryArray = new Map.Entry[keyValuePairsArray.length];
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = new AbstractMap.SimpleEntry<Object, Object>(keyValuePairsArray[i].kg(), keyValuePairsArray[i].pr());
        }
        return new ReadOnlyItemCollection(com.aspose.slides.ms.System.a5.kg(entryArray));
    }

    public int getVersion() {
        return this.ji;
    }

    public static Hashtable fromJava(Map map) {
        if (map == null) {
            return null;
        }
        return new pr(map);
    }

    public static Map toJava(Hashtable h) {
        return h;
    }

    private class ReadOnlyItemCollection
    implements Set {
        private a5 pr;

        ReadOnlyItemCollection(a5 items) {
            this.pr = items;
        }

        @Override
        public int size() {
            return this.pr.size();
        }

        @Override
        public boolean isEmpty() {
            return this.pr.size() == 0;
        }

        @Override
        public boolean contains(Object o) {
            return this.pr.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.pr.iterator();
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            a5 a52 = com.aspose.slides.ms.System.a5.kg(objectArray);
            this.pr.copyTo(a52, 0);
            return objectArray;
        }

        @Override
        public boolean add(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean remove(Object o) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean containsAll(Collection c) {
            for (Object e : c) {
                if (this.contains(e)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read only");
        }

        @Override
        public Object[] toArray(Object[] a) {
            if (a.length <= this.size()) {
                a = new Object[this.size()];
            }
            this.pr.copyTo(com.aspose.slides.ms.System.a5.kg(a), 0);
            return a;
        }
    }

    private static class HashtableDebugView {
    }

    @fc
    private static class SyncHashtable
    extends Hashtable {
        protected Hashtable kg;

        SyncHashtable(Hashtable table) {
            super(false);
            this.kg = table;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.addItem(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return Hashtable.sync((Hashtable)this.kg.deepClone());
            }
        }

        @Override
        public boolean contains(Object key) {
            return this.kg.contains(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.kg.containsKey(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object key) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.containsValue(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(a5 array, int arrayIndex) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.copyTo(array, arrayIndex);
            }
        }

        @Override
        public IDictionaryEnumerator iterator() {
            return this.kg.iterator();
        }

        @Override
        public void getObjectData(j1 info, mn context) {
            if (info == null) {
                throw new ArgumentNullException("info");
            }
            info.kg("ParentTable", this.kg, com.aspose.slides.internal.po.k7.kg(Hashtable.class));
        }

        @Override
        public void onDeserialization(Object sender) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.removeItem(key);
            }
        }

        @Override
        KeyValuePairs[] kg() {
            return this.kg.kg();
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public boolean isFixedSize() {
            return this.kg.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.kg.isReadOnly();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object get_Item(Object key) {
            return this.kg.get_Item(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.set_Item(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.getKeys();
            }
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.getValues();
            }
        }
    }

    @fc
    private static class ValueCollection
    implements ICollection,
    IEnumerable {
        private Hashtable kg;

        ValueCollection(Hashtable hashtable) {
            this.kg = hashtable;
        }

        @Override
        public void copyTo(a5 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.a5() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.b0() - arrayIndex < this.kg.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.kg.pr(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.kg, 2);
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.kg.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }
    }

    @fc
    private static class KeyCollection
    implements ICollection,
    IEnumerable {
        private Hashtable kg;

        KeyCollection(Hashtable hashtable) {
            this.kg = hashtable;
        }

        @Override
        public void copyTo(a5 array, int arrayIndex) {
            if (array == null) {
                throw new ArgumentNullException("array", "Array cannot be null");
            }
            if (array.a5() != 1) {
                throw new ArgumentException("Only single dimensional arrays are supported for the requested action");
            }
            if (arrayIndex < 0) {
                throw new ArgumentOutOfRangeException("arrayIndex", "Non-negative number required");
            }
            if (array.b0() - arrayIndex < this.kg.size()) {
                throw new ArgumentException("Destination array is not long enough to copy all the items in the collection. Check array index and length");
            }
            this.kg.kg(array, arrayIndex);
        }

        public IEnumerator iterator() {
            return new HashtableEnumerator(this.kg, 1);
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.kg.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }
    }

    @fc
    private static class HashtableEnumerator
    implements IDictionaryEnumerator,
    IEnumerator {
        private int kg;
        private boolean pr;
        private Object k7;
        private Object a5;
        private int b0;
        private Hashtable sk;
        private int ud;

        HashtableEnumerator(Hashtable hashtable, int getObjRetType) {
            this.sk = hashtable;
            this.kg = hashtable.k7.length;
            this.ud = hashtable.ji;
            this.pr = false;
            this.b0 = getObjRetType;
        }

        @Override
        public boolean hasNext() {
            if (this.ud != this.sk.ji) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            while (this.kg > 0) {
                --this.kg;
                Object object = ((Hashtable)this.sk).k7[this.kg].kg;
                if (object == null || object == this.sk.k7) continue;
                this.k7 = object;
                this.a5 = ((Hashtable)this.sk).k7[this.kg].pr;
                this.pr = true;
                return true;
            }
            this.pr = false;
            return false;
        }

        @Override
        public void reset() {
            if (this.ud != this.sk.ji) {
                throw new InvalidOperationException("Collection was modified; enumeration operation may not execute");
            }
            this.pr = false;
            this.kg = this.sk.k7.length;
            this.k7 = null;
            this.a5 = null;
        }

        @Override
        public Object next() {
            if (!this.pr) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            if (this.b0 == 1) {
                return this.k7;
            }
            if (this.b0 == 2) {
                return this.a5;
            }
            return new DictionaryEntry(this.k7, this.a5);
        }

        @Override
        public DictionaryEntry getEntry() {
            if (!this.pr) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return new DictionaryEntry(this.k7, this.a5);
        }

        @Override
        public Object getKey() {
            if (!this.pr) {
                throw new InvalidOperationException("Enumeration has not started. Call HasNext");
            }
            return this.k7;
        }

        @Override
        public Object getValue() {
            if (!this.pr) {
                throw new InvalidOperationException("Enumeration has either not started or has already finished");
            }
            return this.a5;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static class KeyValuePairs {
        private Object kg;
        private Object pr;

        public KeyValuePairs(Object key, Object value) {
            this.pr = value;
            this.kg = key;
        }

        public Object kg() {
            return this.kg;
        }

        public Object pr() {
            return this.pr;
        }
    }

    private static class Bucket
    extends com.aspose.slides.internal.po.ud<Bucket> {
        public Object kg;
        public Object pr;
        public int k7;

        public void kg(Bucket bucket) {
            bucket.kg = this.kg;
            bucket.pr = this.pr;
            bucket.k7 = this.k7;
        }

        public Bucket kg() {
            Bucket bucket = new Bucket();
            this.kg(bucket);
            return bucket;
        }

        public Object clone() {
            return this.kg();
        }

        private boolean pr(Bucket bucket) {
            return lv.kg(bucket.kg, this.kg) && lv.kg(bucket.pr, this.pr) && bucket.k7 == this.k7;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (lv.pr(null, obj)) {
                return false;
            }
            if (lv.pr(this, obj)) {
                return true;
            }
            if (!(obj instanceof Bucket)) {
                return false;
            }
            return this.pr((Bucket)obj);
        }

        public int hashCode() {
            int n = this.kg != null ? this.kg.hashCode() : 0;
            n = 31 * n + (this.pr != null ? this.pr.hashCode() : 0);
            n = 31 * n + this.k7;
            return n;
        }

        @Override
        public /* synthetic */ Object Clone() {
            return this.kg();
        }

        @Override
        public /* synthetic */ void CloneTo(Object object) {
            this.kg((Bucket)object);
        }
    }

    @fc
    private static class CompatibleComparer
    implements IGenericEqualityComparer {
        private Comparator kg;
        private IHashCodeProvider pr;

        CompatibleComparer(Comparator comparer, IHashCodeProvider hashCodeProvider) {
            this.kg = comparer;
            this.pr = hashCodeProvider;
        }

        public int kg(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if (this.kg != null) {
                return this.kg.compare(object, object2);
            }
            Comparable comparable = (Comparable)((Object)com.aspose.slides.internal.po.k7.kg(object, Comparable.class));
            if (comparable == null) {
                throw new ArgumentException("At least one object must implement java.lang.Comparable");
            }
            return comparable.compareTo(object2);
        }

        @Override
        public boolean equals(Object x, Object y) {
            return this.equalsT(x, y);
        }

        @Override
        public int hashCode(Object obj) {
            return this.hashCodeT(obj);
        }

        public boolean equalsT(Object a, Object b) {
            return this.kg(a, b) == 0;
        }

        public int hashCodeT(Object obj) {
            if (obj == null) {
                throw new ArgumentNullException("obj");
            }
            if (this.pr != null) {
                return this.pr.hashCode(obj);
            }
            return obj.hashCode();
        }

        Comparator kg() {
            return this.kg;
        }

        IHashCodeProvider pr() {
            return this.pr;
        }
    }
}

