/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.cu;
import com.aspose.slides.ms.System.fc;
import java.util.Arrays;

@fc
public class Queue
implements ICollection,
IEnumerable,
cu {
    private Object[] kg;
    private int pr = 0;
    private int k7 = 0;
    private int a5 = 0;
    private int b0;
    private int sk = 0;

    public Queue() {
        this(32, 2.0f);
    }

    public Queue(int capacity) {
        this(capacity, 2.0f);
    }

    public Queue(ICollection col) {
        this(col == null ? 32 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.enqueue(e);
        }
    }

    public Queue(int capacity, float growFactor) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity", "Needs a non-negative number");
        }
        if (!(growFactor >= 1.0f) || !(growFactor <= 10.0f)) {
            throw new ArgumentOutOfRangeException("growFactor", "Queue growth factor must be between 1.0 and 10.0, inclusive");
        }
        this.kg = new Object[capacity];
        this.b0 = (int)(growFactor * 100.0f);
    }

    @Override
    public int size() {
        return this.k7;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public void copyTo(a5 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.a5() > 1 || index != 0 && index >= array.b0() || this.k7 > array.b0() - index) {
            throw new ArgumentException();
        }
        int n = this.kg.length;
        int n10 = n - this.pr;
        com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg), this.pr, array, index, Math.min(this.k7, n10));
        if (this.k7 > n10) {
            com.aspose.slides.ms.System.a5.kg(com.aspose.slides.ms.System.a5.kg(this.kg), 0, array, index + n10, this.k7 - n10);
        }
    }

    public IEnumerator iterator() {
        return new QueueEnumerator(this);
    }

    @Override
    public Object deepClone() {
        Queue queue = new Queue(this.kg.length);
        queue.b0 = this.b0;
        com.aspose.slides.ms.System.a5.kg(this.kg, 0, queue.kg, 0, this.kg.length);
        queue.pr = this.pr;
        queue.k7 = this.k7;
        queue.a5 = this.a5;
        return queue;
    }

    public void clear() {
        ++this.sk;
        this.pr = 0;
        this.k7 = 0;
        this.a5 = 0;
        for (int i = this.kg.length - 1; i >= 0; --i) {
            this.kg[i] = null;
        }
    }

    public boolean contains(Object obj) {
        int n = this.pr + this.k7;
        if (obj == null) {
            for (int i = this.pr; i < n; ++i) {
                if (this.kg[i % this.kg.length] != null) continue;
                return true;
            }
        } else {
            for (int i = this.pr; i < n; ++i) {
                if (!obj.equals(this.kg[i % this.kg.length])) continue;
                return true;
            }
        }
        return false;
    }

    public Object dequeue() {
        ++this.sk;
        if (this.k7 < 1) {
            throw new InvalidOperationException();
        }
        Object object = this.kg[this.pr];
        this.kg[this.pr] = null;
        this.pr = (this.pr + 1) % this.kg.length;
        --this.k7;
        return object;
    }

    public void enqueue(Object obj) {
        ++this.sk;
        if (this.k7 == this.kg.length) {
            this.kg();
        }
        this.kg[this.a5] = obj;
        this.a5 = (this.a5 + 1) % this.kg.length;
        ++this.k7;
    }

    public Object peek() {
        if (this.k7 < 1) {
            throw new InvalidOperationException();
        }
        return this.kg[this.pr];
    }

    public static Queue sync(Queue queue) {
        if (queue == null) {
            throw new ArgumentNullException("queue");
        }
        return new SyncQueue(queue);
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.k7) {
            return Arrays.copyOf(this.kg, this.k7, a.getClass());
        }
        System.arraycopy(this.kg, 0, a, 0, this.k7);
        if (a.length > this.k7) {
            a[this.k7] = null;
        }
        return a;
    }

    public void trimToSize() {
        ++this.sk;
        Object[] objectArray = new Object[this.k7];
        this.copyTo(com.aspose.slides.ms.System.a5.kg(objectArray), 0);
        this.kg = objectArray;
        this.pr = 0;
        this.a5 = 0;
    }

    private void kg() {
        int n = this.kg.length * this.b0 / 100;
        if (n < this.kg.length + 1) {
            n = this.kg.length + 1;
        }
        Object[] objectArray = new Object[n];
        this.copyTo(com.aspose.slides.ms.System.a5.kg(objectArray), 0);
        this.kg = objectArray;
        this.pr = 0;
        this.a5 = this.pr + this.k7;
    }

    @fc
    private static class QueueEnumerator
    implements IEnumerator,
    cu {
        private Queue kg;
        private int pr;
        private int k7;

        QueueEnumerator(Queue q) {
            this.kg = q;
            this.pr = q.sk;
            this.k7 = -1;
        }

        @Override
        public Object deepClone() {
            QueueEnumerator queueEnumerator = new QueueEnumerator(this.kg);
            queueEnumerator.pr = this.pr;
            queueEnumerator.k7 = this.k7;
            return queueEnumerator;
        }

        @Override
        public Object next() {
            if (this.pr != this.kg.sk || this.k7 < 0 || this.k7 >= this.kg.k7) {
                throw new InvalidOperationException();
            }
            return this.kg.kg[(this.kg.pr + this.k7) % this.kg.kg.length];
        }

        @Override
        public boolean hasNext() {
            if (this.pr != this.kg.sk) {
                throw new InvalidOperationException();
            }
            if (this.k7 >= this.kg.k7 - 1) {
                this.k7 = Integer.MAX_VALUE;
                return false;
            }
            ++this.k7;
            return true;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.pr != this.kg.sk) {
                throw new InvalidOperationException();
            }
            this.k7 = -1;
        }
    }

    private static class SyncQueue
    extends Queue {
        private final Queue kg;

        SyncQueue(Queue queue) {
            this.kg = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Queue queue = this.kg;
            synchronized (queue) {
                return this.kg.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(a5 array, int index) {
            Queue queue = this.kg;
            synchronized (queue) {
                this.kg.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Queue queue = this.kg;
            synchronized (queue) {
                return this.kg.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Queue queue = this.kg;
            synchronized (queue) {
                return new SyncQueue((Queue)this.kg.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Queue queue = this.kg;
            synchronized (queue) {
                this.kg.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Queue queue = this.kg;
            synchronized (queue) {
                this.kg.trimToSize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Queue queue = this.kg;
            synchronized (queue) {
                return this.kg.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object dequeue() {
            Queue queue = this.kg;
            synchronized (queue) {
                return this.kg.dequeue();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueue(Object obj) {
            Queue queue = this.kg;
            synchronized (queue) {
                this.kg.enqueue(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Queue queue = this.kg;
            synchronized (queue) {
                return this.kg.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Queue queue = this.kg;
            synchronized (queue) {
                return this.kg.toArray(a);
            }
        }
    }
}

