/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.Comparer;
import com.aspose.slides.Collections.DictionaryEntry;
import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IDictionary;
import com.aspose.slides.Collections.IDictionaryEnumerator;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.Collections.IList;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotSupportedException;
import com.aspose.slides.internal.po.ud;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.cu;
import com.aspose.slides.ms.System.fc;
import com.aspose.slides.ms.System.jk;
import com.aspose.slides.ms.System.lv;
import com.aspose.slides.ms.System.m9;
import java.util.Comparator;

@fc
public class SortedList
implements IDictionary,
cu {
    private final Object kg = new Object();
    private Slot[] pr;
    private Comparator k7;
    private int a5;
    private int b0;
    private int sk;

    public SortedList() {
        this(null, 16);
    }

    public SortedList(int initialCapacity) {
        this(null, initialCapacity);
    }

    public SortedList(Comparator comparer, int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.sk = capacity == 0 ? 0 : 16;
        this.k7 = comparer;
        this.pr(capacity, true);
    }

    public SortedList(Comparator comparer) {
        this.k7 = comparer;
        this.pr(16, true);
    }

    public SortedList(IDictionary d) {
        this(d, null);
    }

    public SortedList(IDictionary d, Comparator comparer) {
        if (d == null) {
            throw new ArgumentNullException("dictionary");
        }
        this.pr(d.size(), true);
        this.k7 = comparer;
        IDictionaryEnumerator iDictionaryEnumerator = d.iterator();
        while (iDictionaryEnumerator.hasNext()) {
            this.addItem(iDictionaryEnumerator.getKey(), iDictionaryEnumerator.getValue());
        }
    }

    @Override
    public int size() {
        return this.a5;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.kg;
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ICollection getKeys() {
        return new ListKeys(this);
    }

    @Override
    public ICollection getValues() {
        return new ListValues(this);
    }

    @Override
    public Object get_Item(Object key) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        return this.kg(key);
    }

    @Override
    public void set_Item(Object key, Object value) {
        if (key == null) {
            throw new ArgumentNullException();
        }
        if (this.isReadOnly()) {
            throw new NotSupportedException("SortedList is Read Only.");
        }
        if (this.pr(key) < 0 && this.isFixedSize()) {
            throw new NotSupportedException("Key not found and SortedList is fixed size.");
        }
        this.kg(key, value, true);
    }

    public int getCapacity() {
        return this.pr.length;
    }

    public void setCapacity(int value) {
        int n = this.pr.length;
        if (this.a5 > value) {
            throw new ArgumentOutOfRangeException("capacity too small");
        }
        if (value == 0) {
            Slot[] slotArray = SortedList.kg(this.sk);
            SortedList.kg(this.pr, 0, slotArray, 0, this.a5);
            this.pr = slotArray;
        } else if (value > this.a5) {
            Slot[] slotArray = SortedList.kg(value);
            SortedList.kg(this.pr, 0, slotArray, 0, this.a5);
            this.pr = slotArray;
        } else if (value > n) {
            Slot[] slotArray = SortedList.kg(value);
            SortedList.kg(this.pr, 0, slotArray, 0, n);
            this.pr = slotArray;
        }
    }

    @Override
    public IDictionaryEnumerator iterator() {
        return new Enumerator(this, 2);
    }

    @Deprecated
    public IDictionaryEnumerator iteratorJava() {
        return new EnumeratorJava(this, 2);
    }

    @Override
    public void addItem(Object key, Object value) {
        this.kg(key, value, false);
    }

    @Override
    public void clear() {
        this.sk = 16;
        this.pr = SortedList.kg(this.sk);
        this.a5 = 0;
        ++this.b0;
    }

    @Override
    public boolean contains(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.pr(key) >= 0;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void removeItem(Object key) {
        int n = this.indexOfKey(key);
        if (n >= 0) {
            this.removeAt(n);
        }
    }

    @Override
    public void copyTo(a5 array, int arrayIndex) {
        if (null == array) {
            throw new ArgumentNullException();
        }
        if (arrayIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.a5() > 1) {
            throw new ArgumentException("array is multi-dimensional");
        }
        if (arrayIndex >= array.b0()) {
            throw new ArgumentNullException("arrayIndex is greater than or equal to array.Length");
        }
        if (this.size() > array.b0() - arrayIndex) {
            throw new ArgumentNullException("Not enough space in array from arrayIndex to end of array");
        }
        IDictionaryEnumerator iDictionaryEnumerator = this.iterator();
        int n = arrayIndex;
        while (iDictionaryEnumerator.hasNext()) {
            array.k7(iDictionaryEnumerator.getEntry().Clone(), n++);
        }
    }

    @Override
    public Object deepClone() {
        SortedList sortedList = new SortedList(this, this.k7);
        sortedList.b0 = this.b0;
        return sortedList;
    }

    public IList getKeyList() {
        return new ListKeys(this);
    }

    public IList getValueList() {
        return new ListValues(this);
    }

    public void removeAt(int index) {
        Slot[] slotArray = this.pr;
        int n = this.size();
        if (index >= 0 && index < n) {
            if (index != n - 1) {
                SortedList.kg(slotArray, index + 1, slotArray, index, n - 1 - index);
            } else {
                slotArray[index].kg = null;
                slotArray[index].pr = null;
            }
            --this.a5;
            ++this.b0;
        } else {
            throw new ArgumentOutOfRangeException("index out of range");
        }
    }

    public int indexOfKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        int n = 0;
        try {
            n = this.pr(key);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        return n | n >> 31;
    }

    public int indexOfValue(Object value) {
        if (this.a5 == 0) {
            return -1;
        }
        for (int i = 0; i < this.a5; ++i) {
            Slot slot = this.pr[i].Clone();
            if (!lv.kg(value, slot.pr)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        if (null == key) {
            throw new ArgumentNullException();
        }
        try {
            return this.contains(key);
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalStateException();
        }
    }

    public boolean containsValue(Object value) {
        return this.indexOfValue(value) >= 0;
    }

    public Object getByIndex(int index) {
        if (index >= 0 && index < this.size()) {
            return this.pr[index].pr;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public void setByIndex(int index, Object value) {
        if (index < 0 || index >= this.size()) {
            throw new ArgumentOutOfRangeException("index out of range");
        }
        this.pr[index].pr = value;
    }

    public Object getKey(int index) {
        if (index >= 0 && index < this.size()) {
            return this.pr[index].kg;
        }
        throw new ArgumentOutOfRangeException("index out of range");
    }

    public static SortedList sync(SortedList list) {
        if (list == null) {
            throw new ArgumentNullException("Base list is null.");
        }
        return new SynchedSortedList(list);
    }

    public void trimToSize() {
        if (this.size() == 0) {
            this.kg(this.sk, false);
        } else {
            this.kg(this.size(), true);
        }
    }

    private void kg(int n, boolean bl2) {
        Slot[] slotArray = this.pr;
        Slot[] slotArray2 = SortedList.kg(n);
        if (bl2) {
            SortedList.kg(slotArray, 0, slotArray2, 0, n);
        }
        this.pr = slotArray2;
    }

    private void kg(int n, int n10) {
        boolean bl2;
        Slot[] slotArray = this.pr;
        Slot[] slotArray2 = null;
        int n11 = this.getCapacity();
        boolean bl3 = bl2 = n10 >= 0 && n10 < this.size();
        if (n > n11) {
            slotArray2 = SortedList.kg(n << 1);
        }
        if (slotArray2 != null) {
            if (bl2) {
                int n12 = n10;
                if (n12 > 0) {
                    SortedList.kg(slotArray, 0, slotArray2, 0, n12);
                }
                if ((n12 = this.size() - n10) > 0) {
                    SortedList.kg(slotArray, n10, slotArray2, n10 + 1, n12);
                }
            } else {
                SortedList.kg(slotArray, 0, slotArray2, 0, this.size());
            }
            this.pr = slotArray2;
        } else if (bl2) {
            SortedList.kg(slotArray, n10, slotArray, n10 + 1, this.size() - n10);
        }
    }

    private void kg(Object object, Object object2, boolean bl2) {
        if (object == null) {
            throw new ArgumentNullException("null key");
        }
        Slot[] slotArray = this.pr;
        int n = -1;
        try {
            n = this.pr(object);
        }
        catch (RuntimeException runtimeException) {
            throw new InvalidOperationException();
        }
        if (n >= 0) {
            if (!bl2) {
                String string = m9.kg("Key '{0}' already exists in list.", new Object[]{object});
                throw new ArgumentException(string);
            }
            slotArray[n].pr = object2;
            ++this.b0;
            return;
        }
        if ((n ^= 0xFFFFFFFF) > this.getCapacity() + 1) {
            throw new RuntimeException(m9.kg(new Object[]{"SortedList::internal error (", object, ", ", object2, ") at [", n, "]"}));
        }
        this.kg(this.size() + 1, n);
        slotArray = this.pr;
        slotArray[n].kg = object;
        slotArray[n].pr = object2;
        ++this.a5;
        ++this.b0;
    }

    private Object kg(Object object) {
        int n = this.pr(object);
        if (n >= 0) {
            return this.pr[n].pr;
        }
        return null;
    }

    private void pr(int n, boolean bl2) {
        if (!bl2 && n < this.sk) {
            n = this.sk;
        }
        this.pr = SortedList.kg(n);
        this.a5 = 0;
        this.b0 = 0;
    }

    private void kg(a5 a52, int n, int n10) {
        if (a52 == null) {
            throw new ArgumentNullException("arr");
        }
        if (n < 0 || n + this.size() > a52.b0()) {
            throw new ArgumentOutOfRangeException("i");
        }
        Enumerator enumerator = new Enumerator(this, n10);
        while (enumerator.hasNext()) {
            a52.k7(enumerator.next(), n++);
        }
    }

    private int pr(Object object) {
        Slot[] slotArray = this.pr;
        int n = this.size();
        if (n == 0) {
            return -1;
        }
        Comparator comparator = this.k7 == null ? Comparer.Default : this.k7;
        int n10 = 0;
        int n11 = n - 1;
        while (n10 <= n11) {
            int n12 = n10 + n11 >> 1;
            int n13 = comparator.compare(slotArray[n12].kg, object);
            if (n13 == 0) {
                return n12;
            }
            if (n13 < 0) {
                n10 = n12 + 1;
                continue;
            }
            n11 = n12 - 1;
        }
        return ~n10;
    }

    static Slot[] kg(int n) {
        Slot[] slotArray = new Slot[n];
        for (int i = 0; i < n; ++i) {
            slotArray[i] = new Slot();
        }
        return slotArray;
    }

    private static boolean kg(int n, int n10, int n11) {
        return n < n10 && n + n11 > n10 || n10 < n && n10 + n11 > n;
    }

    static void kg(Slot[] slotArray, int n, Slot[] slotArray2, int n10, int n11) {
        Slot[] slotArray3;
        if (slotArray == slotArray2 && SortedList.kg(n, n10, n11)) {
            slotArray3 = new Slot[n11];
            System.arraycopy(slotArray, n, slotArray3, 0, n11);
            n = 0;
        } else {
            slotArray3 = slotArray;
        }
        for (int i = 0; i < n11; ++i) {
            slotArray2[n10 + i] = slotArray3[n + i].Clone();
        }
    }

    private static class SynchedSortedList
    extends SortedList {
        private SortedList kg;

        public SynchedSortedList(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.kg = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCapacity() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.getCapacity();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCapacity(int value) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.setCapacity(value);
            }
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        @Override
        public boolean isFixedSize() {
            return this.kg.isFixedSize();
        }

        @Override
        public boolean isReadOnly() {
            return this.kg.isReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getKeys() {
            ICollection iCollection = null;
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                iCollection = this.kg.getKeys();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ICollection getValues() {
            ICollection iCollection = null;
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                iCollection = this.kg.getValues();
            }
            return iCollection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object get_Item(Object key) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.kg(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set_Item(Object key, Object value) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.kg(key, value, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(a5 array, int arrayIndex) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.copyTo(array, arrayIndex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addItem(Object key, Object value) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.kg(key, value, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object key) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.pr(key) >= 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IDictionaryEnumerator iterator() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public IDictionaryEnumerator iteratorJava() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.iteratorJava();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeItem(Object key) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.removeItem(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.contains(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.deepClone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getByIndex(int index) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.getByIndex(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getKey(int index) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.getKey(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getKeyList() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return new ListKeys(this.kg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IList getValueList() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return new ListValues(this.kg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAt(int index) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.removeAt(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfKey(Object key) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.indexOfKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOfValue(Object val) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                return this.kg.indexOfValue(val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setByIndex(int index, Object value) {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.setByIndex(index, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void trimToSize() {
            Object object = this.kg.getSyncRoot();
            synchronized (object) {
                this.kg.trimToSize();
            }
        }
    }

    @fc
    private static class ListValues
    implements IList {
        private SortedList kg;

        public ListValues(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.kg = host;
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.kg.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        @Override
        public void copyTo(a5 array, int arrayIndex) {
            this.kg.kg(array, arrayIndex, 1);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.getByIndex(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("This operation is not supported on GetValueList return");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object value) {
            return this.kg.containsValue(value);
        }

        @Override
        public int indexOf(Object value) {
            return this.kg.indexOfValue(value);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.kg, 1);
        }
    }

    @fc
    private static class ListKeys
    implements IList {
        private SortedList kg;

        public ListKeys(SortedList host) {
            if (host == null) {
                throw new ArgumentNullException();
            }
            this.kg = host;
        }

        @Override
        public int size() {
            return this.kg.size();
        }

        @Override
        public boolean isSynchronized() {
            return this.kg.isSynchronized();
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        @Override
        public void copyTo(a5 array, int arrayIndex) {
            this.kg.kg(array, arrayIndex, 0);
        }

        @Override
        public boolean isFixedSize() {
            return true;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public Object get_Item(int index) {
            return this.kg.getKey(index);
        }

        @Override
        public void set_Item(int index, Object value) {
            throw new NotSupportedException("attempt to modify a key");
        }

        @Override
        public int addItem(Object value) {
            throw new NotSupportedException("IList::Add not supported");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("IList::Clear not supported");
        }

        @Override
        public boolean contains(Object key) {
            return this.kg.contains(key);
        }

        @Override
        public int indexOf(Object key) {
            return this.kg.indexOfKey(key);
        }

        @Override
        public void insertItem(int index, Object value) {
            throw new NotSupportedException("IList::Insert not supported");
        }

        @Override
        public void removeItem(Object value) {
            throw new NotSupportedException("IList::Remove not supported");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("IList::RemoveAt not supported");
        }

        @Override
        public IEnumerator iterator() {
            return new Enumerator(this.kg, 0);
        }
    }

    @Deprecated
    private static final class EnumeratorJava
    implements IDictionaryEnumerator,
    cu {
        private SortedList kg;
        private Object pr;
        private Object k7;
        private int a5;
        private int b0;
        private int sk;
        private int ud;
        private boolean lc = false;
        private static String gn = "SortedList.EnumeratorJava: snapshot out of sync.";

        public EnumeratorJava(SortedList host, int mode) {
            this.kg = host;
            this.a5 = host.b0;
            this.sk = host.size();
            this.ud = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.kg.b0 != this.a5 || this.lc) {
                throw new IllegalStateException(gn);
            }
            this.b0 = -1;
            this.pr = null;
            this.k7 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.kg.b0 != this.a5 || this.lc) {
                throw new InvalidOperationException(gn);
            }
            return ++this.b0 < this.sk;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                throw new IllegalStateException(gn);
            }
            return new DictionaryEntry(this.pr, this.k7);
        }

        @Override
        public Object getKey() {
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                throw new IllegalStateException(gn);
            }
            return this.pr;
        }

        @Override
        public Object getValue() {
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                throw new IllegalStateException(gn);
            }
            return this.k7;
        }

        @Override
        public Object next() {
            if (this.kg.b0 != this.a5 || this.lc) {
                throw new InvalidOperationException(gn);
            }
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                if (this.b0 >= this.sk) {
                    this.pr = null;
                    this.k7 = null;
                }
                throw new IllegalStateException(gn);
            }
            Slot[] slotArray = this.kg.pr;
            Slot slot = slotArray[this.b0].Clone();
            this.pr = slot.kg;
            this.k7 = slot.pr;
            switch (this.ud) {
                case 0: {
                    return this.pr;
                }
                case 1: {
                    return this.k7;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(m9.kg(new String[]{jk.getName(EnumeratorMode.class, this.ud), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            EnumeratorJava enumeratorJava = new EnumeratorJava(this.kg, this.ud);
            enumeratorJava.a5 = this.a5;
            enumeratorJava.b0 = this.b0;
            enumeratorJava.sk = this.sk;
            enumeratorJava.pr = this.pr;
            enumeratorJava.k7 = this.k7;
            enumeratorJava.lc = this.lc;
            return enumeratorJava;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class Enumerator
    implements IDictionaryEnumerator,
    cu {
        private SortedList kg;
        private Object pr;
        private Object k7;
        private int a5;
        private int b0;
        private int sk;
        private int ud;
        private boolean lc = false;
        private static String gn = "SortedList.Enumerator: snapshot out of sync.";

        public Enumerator(SortedList host, int mode) {
            this.kg = host;
            this.a5 = host.b0;
            this.sk = host.size();
            this.ud = mode;
            this.reset();
        }

        @Override
        public void reset() {
            if (this.kg.b0 != this.a5 || this.lc) {
                throw new IllegalStateException(gn);
            }
            this.b0 = -1;
            this.pr = null;
            this.k7 = null;
        }

        @Override
        public boolean hasNext() {
            if (this.kg.b0 != this.a5 || this.lc) {
                throw new InvalidOperationException(gn);
            }
            Slot[] slotArray = this.kg.pr;
            if (++this.b0 < this.sk) {
                Slot slot = slotArray[this.b0].Clone();
                this.pr = slot.kg;
                this.k7 = slot.pr;
                return true;
            }
            this.pr = null;
            this.k7 = null;
            return false;
        }

        @Override
        public DictionaryEntry getEntry() {
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                throw new IllegalStateException(gn);
            }
            return new DictionaryEntry(this.pr, this.k7);
        }

        @Override
        public Object getKey() {
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                throw new IllegalStateException(gn);
            }
            return this.pr;
        }

        @Override
        public Object getValue() {
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                throw new IllegalStateException(gn);
            }
            return this.k7;
        }

        @Override
        public Object next() {
            if (this.lc || this.b0 >= this.sk || this.b0 == -1) {
                throw new IllegalStateException(gn);
            }
            switch (this.ud) {
                case 0: {
                    return this.pr;
                }
                case 1: {
                    return this.k7;
                }
                case 2: {
                    return this.getEntry();
                }
            }
            throw new NotSupportedException(m9.kg(new String[]{jk.getName(EnumeratorMode.class, this.ud), " is not a supported mode."}));
        }

        @Override
        public Object deepClone() {
            Enumerator enumerator = new Enumerator(this.kg, this.ud);
            enumerator.a5 = this.a5;
            enumerator.b0 = this.b0;
            enumerator.sk = this.sk;
            enumerator.pr = this.pr;
            enumerator.k7 = this.k7;
            enumerator.lc = this.lc;
            return enumerator;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }

    private static final class EnumeratorMode
    extends jk {
        private EnumeratorMode() {
        }

        static {
            jk.register(new jk.b0(EnumeratorMode.class, Integer.class){
                {
                    this.addConstant("KEY_MODE", 0L);
                    this.addConstant("VALUE_MODE", 1L);
                    this.addConstant("ENTRY_MODE", 2L);
                }
            });
        }
    }

    @fc
    public static class Slot
    extends ud<Slot> {
        Object kg;
        Object pr;

        @Override
        public void CloneTo(Slot that) {
            that.kg = this.kg;
            that.pr = this.pr;
        }

        @Override
        public Slot Clone() {
            Slot slot = new Slot();
            this.CloneTo(slot);
            return slot;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean kg(Slot slot) {
            return lv.kg(slot.kg, this.kg) && lv.kg(slot.pr, this.pr);
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (lv.pr(null, obj)) {
                return false;
            }
            if (lv.pr(this, obj)) {
                return true;
            }
            if (!(obj instanceof Slot)) {
                return false;
            }
            return this.kg((Slot)obj);
        }

        public static boolean equals(Slot obj1, Slot obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n = this.kg != null ? this.kg.hashCode() : 0;
            n = 31 * n + (this.pr != null ? this.pr.hashCode() : 0);
            return n;
        }
    }
}

