/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections.Specialized;

import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.po.k7;
import com.aspose.slides.internal.po.ud;
import com.aspose.slides.internal.we.u5;
import com.aspose.slides.ms.System.e6;
import com.aspose.slides.ms.System.yo;

public class BitVector32
extends ud<BitVector32> {
    private int kg;

    public BitVector32() {
    }

    public BitVector32(BitVector32 value) {
        this.kg = value.kg;
    }

    public BitVector32(int data) {
        this.kg = data;
    }

    public int getData() {
        return this.kg;
    }

    public int get_Item(Section section) {
        return this.kg >> section.getOffset() & section.getMask();
    }

    public void set_Item(Section section, int value) {
        if (value < 0) {
            throw new ArgumentException("Section can't hold negative values");
        }
        if (value > section.getMask()) {
            throw new ArgumentException("Value too large to fit in section");
        }
        this.kg &= ~(section.getMask() << section.getOffset());
        this.kg |= value << section.getOffset();
    }

    public boolean get_Item(int bit) {
        return (this.kg & bit) == bit;
    }

    public void set_Item(int bit, boolean value) {
        this.kg = value ? (this.kg |= bit) : (this.kg &= ~bit);
    }

    public static int createMask() {
        return 1;
    }

    public static int createMask(int previous) {
        if (previous == 0) {
            return 1;
        }
        if (previous == Integer.MIN_VALUE) {
            throw new InvalidOperationException("all bits set");
        }
        return previous << 1;
    }

    public static Section createSection(short maxValue) {
        return BitVector32.createSection(maxValue, new Section(0, 0));
    }

    public static Section createSection(short maxValue, Section previous) {
        if (maxValue < 1) {
            throw new ArgumentException("maxValue");
        }
        int n = BitVector32.kg(maxValue);
        int n10 = (1 << n) - 1;
        int n11 = previous.getOffset() + BitVector32.kg(previous.getMask());
        if (n11 + n > 32) {
            throw new ArgumentException("Sections cannot exceed 32 bits in total");
        }
        return new Section(k7.pr((Object)n10, 9), k7.pr((Object)n11, 9));
    }

    public boolean equals(Object o) {
        return k7.pr(o, BitVector32.class) && this.kg == k7.a5((Object)o, BitVector32.class).kg;
    }

    public int hashCode() {
        return e6.kg(this.kg);
    }

    public String toString() {
        return BitVector32.toString(this.Clone());
    }

    public static String toString(BitVector32 value) {
        u5 u52 = new u5();
        u52.kg("BitVector32{");
        for (long i = k7.sk((Object)0x80000000L, 10); i > 0L; i >>= 1) {
            u52.kg(((long)value.kg & i) == 0L ? (char)'0' : '1');
        }
        u52.kg('}');
        return u52.toString();
    }

    private static int kg(int n) {
        int n10 = 0;
        while (n >> n10 != 0) {
            ++n10;
        }
        return n10;
    }

    @Override
    public void CloneTo(BitVector32 that) {
        that.kg = this.kg;
    }

    @Override
    public BitVector32 Clone() {
        BitVector32 bitVector32 = new BitVector32();
        this.CloneTo(bitVector32);
        return bitVector32;
    }

    public Object clone() {
        return this.Clone();
    }

    public static boolean equals(BitVector32 obj1, BitVector32 obj2) {
        return obj1.equals(obj2);
    }

    public static class Section
    extends ud<Section> {
        private short kg;
        private short pr;

        public Section() {
        }

        Section(short mask, short offset) {
            this.kg = mask;
            this.pr = offset;
        }

        public short getMask() {
            return this.kg;
        }

        public short getOffset() {
            return this.pr;
        }

        public static boolean op_Equality(Section a, Section b) {
            return a.kg == b.kg && a.pr == b.pr;
        }

        public static boolean op_Inequality(Section a, Section b) {
            return a.kg != b.kg || a.pr != b.pr;
        }

        public boolean equals(Section obj) {
            return this.kg == obj.kg && this.pr == obj.pr;
        }

        public boolean equals(Object o) {
            if (!k7.pr(o, Section.class)) {
                return false;
            }
            Section section = k7.a5(o, Section.class).Clone();
            return this.kg == section.kg && this.pr == section.pr;
        }

        public int hashCode() {
            return this.kg << this.pr;
        }

        public String toString() {
            return Section.toString(this.Clone());
        }

        public static String toString(Section value) {
            u5 u52 = new u5();
            u52.kg("Section{0x");
            u52.kg(yo.kg(value.getMask(), 16));
            u52.kg(", 0x");
            u52.kg(yo.kg(value.getOffset(), 16));
            u52.kg("}");
            return u52.toString();
        }

        @Override
        public void CloneTo(Section that) {
            that.kg = this.kg;
            that.pr = this.pr;
        }

        @Override
        public Section Clone() {
            Section section = new Section();
            this.CloneTo(section);
            return section;
        }

        public Object clone() {
            return this.Clone();
        }

        public static boolean equals(Section obj1, Section obj2) {
            return obj1.equals(obj2);
        }
    }
}

