/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.Collections;

import com.aspose.slides.Collections.ICollection;
import com.aspose.slides.Collections.IEnumerable;
import com.aspose.slides.Collections.IEnumerator;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.exceptions.NotImplementedException;
import com.aspose.slides.ms.System.a5;
import com.aspose.slides.ms.System.cu;
import com.aspose.slides.ms.System.fc;
import com.aspose.slides.ms.System.mz;
import java.util.Arrays;

@fc
public class Stack
implements ICollection,
IEnumerable,
cu {
    private Object[] kg;
    private int pr = -1;
    private int k7;
    private int a5;
    private int b0;

    private void kg(int n) {
        n = Math.max(n, 16);
        Object[] objectArray = new Object[n];
        com.aspose.slides.ms.System.a5.kg(this.kg, 0, objectArray, 0, this.k7);
        this.a5 = n;
        this.kg = objectArray;
    }

    public Stack() {
        this.kg = new Object[16];
        this.a5 = 16;
    }

    public Stack(ICollection col) {
        this(col == null ? 16 : col.size());
        if (col == null) {
            throw new ArgumentNullException("col");
        }
        for (Object e : col) {
            this.push(e);
        }
    }

    public Stack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new ArgumentOutOfRangeException("initialCapacity");
        }
        this.a5 = initialCapacity;
        this.kg = new Object[this.a5];
    }

    public static Stack sync(Stack stack) {
        if (stack == null) {
            throw new ArgumentNullException("stack");
        }
        return new SyncStack(stack);
    }

    @Override
    public int size() {
        return this.k7;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    public void clear() {
        ++this.b0;
        for (int i = 0; i < this.k7; ++i) {
            this.kg[i] = null;
        }
        this.k7 = 0;
        this.pr = -1;
    }

    @Override
    public Object deepClone() {
        Stack stack = new Stack(com.aspose.slides.ms.System.a5.kg(this.kg));
        stack.pr = this.pr;
        stack.k7 = this.k7;
        return stack;
    }

    public boolean contains(Object obj) {
        if (this.k7 == 0) {
            return false;
        }
        if (obj == null) {
            for (int i = 0; i < this.k7; ++i) {
                if (this.kg[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.k7; ++i) {
                if (!obj.equals(this.kg[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(a5 array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (array.a5() > 1 || array.b0() > 0 && index >= array.b0() || this.k7 > array.b0() - index) {
            throw new ArgumentException();
        }
        for (int i = this.pr; i != -1; --i) {
            array.k7(this.kg[i], this.k7 - (i + 1) + index);
        }
    }

    public IEnumerator iterator() {
        return new Enumerator(this);
    }

    public Object peek() {
        if (this.pr == -1) {
            throw new InvalidOperationException();
        }
        return this.kg[this.pr];
    }

    public Object pop() {
        if (this.pr == -1) {
            throw new InvalidOperationException();
        }
        ++this.b0;
        Object object = this.kg[this.pr];
        this.kg[this.pr] = null;
        --this.k7;
        --this.pr;
        if (this.k7 <= this.a5 / 4 && this.k7 > 16) {
            this.kg(this.a5 / 2);
        }
        return object;
    }

    public void push(Object obj) {
        ++this.b0;
        if (this.a5 == this.k7) {
            this.kg(this.a5 * 2);
        }
        ++this.k7;
        ++this.pr;
        this.kg[this.pr] = obj;
    }

    public <T> T[] toArray(T[] a) {
        if (a.length < this.k7) {
            a = Arrays.copyOf(this.kg, this.k7, a.getClass());
            mz.kg(a);
            return a;
        }
        System.arraycopy(this.kg, 0, a, 0, this.k7);
        if (a.length > this.k7) {
            a[this.k7] = null;
        }
        mz.kg(a);
        return a;
    }

    private static class Enumerator
    implements IEnumerator,
    cu,
    Cloneable {
        private Stack kg;
        private int pr;
        private int k7;

        Enumerator(Stack s) {
            this.kg = s;
            this.pr = s.b0;
            this.k7 = -2;
        }

        private Enumerator() {
        }

        @Override
        public Object deepClone() {
            return this.kg();
        }

        @Override
        public Object next() {
            if (this.pr != this.kg.b0 || this.k7 == -2 || this.k7 == -1 || this.k7 > this.kg.k7) {
                throw new InvalidOperationException();
            }
            return this.kg.kg[this.k7];
        }

        @Override
        public boolean hasNext() {
            if (this.pr != this.kg.b0) {
                throw new InvalidOperationException();
            }
            switch (this.k7) {
                case -2: {
                    this.k7 = this.kg.pr;
                    return this.k7 != -1;
                }
                case -1: {
                    return false;
                }
            }
            --this.k7;
            return this.k7 != -1;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }

        @Override
        public void reset() {
            if (this.pr != this.kg.b0) {
                throw new InvalidOperationException();
            }
            this.k7 = -2;
        }

        protected Object kg() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            Enumerator enumerator = new Enumerator();
            enumerator.kg = this.kg;
            enumerator.pr = this.pr;
            enumerator.k7 = this.k7;
            return enumerator;
        }
    }

    @fc
    private static class SyncStack
    extends Stack {
        private final Stack kg;

        SyncStack(Stack s) {
            this.kg = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Stack stack = this.kg;
            synchronized (stack) {
                return this.kg.size();
            }
        }

        @Override
        public boolean isSynchronized() {
            return true;
        }

        @Override
        public Object getSyncRoot() {
            return this.kg.getSyncRoot();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Stack stack = this.kg;
            synchronized (stack) {
                this.kg.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deepClone() {
            Stack stack = this.kg;
            synchronized (stack) {
                return Stack.sync((Stack)this.kg.deepClone());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object obj) {
            Stack stack = this.kg;
            synchronized (stack) {
                return this.kg.contains(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copyTo(a5 array, int index) {
            Stack stack = this.kg;
            synchronized (stack) {
                this.kg.copyTo(array, index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IEnumerator iterator() {
            Stack stack = this.kg;
            synchronized (stack) {
                return new Enumerator(this.kg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object peek() {
            Stack stack = this.kg;
            synchronized (stack) {
                return this.kg.peek();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object pop() {
            Stack stack = this.kg;
            synchronized (stack) {
                return this.kg.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void push(Object obj) {
            Stack stack = this.kg;
            synchronized (stack) {
                this.kg.push(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Stack stack = this.kg;
            synchronized (stack) {
                return this.kg.toArray(a);
            }
        }
    }
}

