/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IMathElement;
import com.aspose.slides.IMathMatrix;
import com.aspose.slides.MathElementBase;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.exceptions.InvalidOperationException;
import com.aspose.slides.internal.po.k7;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.o0;
import com.aspose.slides.tna;
import com.aspose.slides.wfg;

public final class MathMatrix
extends MathElementBase
implements IMathMatrix,
o0 {
    private boolean a5;
    private int b0;
    private long sk;
    private int ud;
    private long lc;
    private int gn;
    private long f8;
    private final List<List<IMathElement>> pb;
    private int[] ji;
    final tna kg;

    @Override
    public final int getRowCount() {
        return this.pb.size();
    }

    @Override
    public final int getColumnCount() {
        return this.pb.get_Item(0).size();
    }

    @Override
    public final boolean getHidePlaceholders() {
        return this.a5;
    }

    @Override
    public final void setHidePlaceholders(boolean value) {
        this.a5 = value;
    }

    @Override
    public final int getBaseJustification() {
        return this.b0;
    }

    @Override
    public final void setBaseJustification(int value) {
        this.b0 = value;
    }

    @Override
    public final long getMinColumnWidth() {
        return this.sk;
    }

    @Override
    public final void setMinColumnWidth(long value) {
        this.sk = value;
    }

    @Override
    public final int getColumnGapRule() {
        return this.ud;
    }

    @Override
    public final void setColumnGapRule(int value) {
        this.ud = value;
    }

    @Override
    public final long getColumnGap() {
        return this.lc;
    }

    @Override
    public final void setColumnGap(long value) {
        this.lc = value;
    }

    @Override
    public final int getRowGapRule() {
        return this.gn;
    }

    @Override
    public final void setRowGapRule(int value) {
        this.gn = value;
    }

    @Override
    public final long getRowGap() {
        return this.f8;
    }

    @Override
    public final void setRowGap(long value) {
        this.f8 = value;
    }

    @Override
    public final IMathElement get_Item(int row, int column) {
        return this.pb.get_Item(row).get_Item(column);
    }

    @Override
    public final void set_Item(int row, int column, IMathElement value) {
        this.pb.get_Item(row).set_Item(column, value);
    }

    @Override
    public final tna getControlCharacterProperties() {
        return this.kg;
    }

    public MathMatrix(int rowCount, int columnCount) {
        if (rowCount < 1) {
            throw new ArgumentOutOfRangeException("rowCount");
        }
        if (columnCount < 1) {
            throw new ArgumentOutOfRangeException("columnCount");
        }
        this.pb = new List(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            this.pb.addItem(this.kg(columnCount));
        }
        this.setHidePlaceholders(false);
        this.setBaseJustification(2);
        this.setMinColumnWidth(0L);
        this.setColumnGapRule(0);
        this.ji = new int[columnCount];
        this.setColumnsAlignment(0, (long)this.ji.length & 0xFFFFFFFFL, 2);
        this.kg = new tna();
    }

    @Override
    public final int getColumnAlignment(int columnIndex) {
        if (columnIndex < 0) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if (columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        return this.ji[columnIndex];
    }

    @Override
    public final void setColumnAlignment(int columnIndex, int val) {
        this.setColumnsAlignment(columnIndex, 1L, val);
    }

    @Override
    public final void setColumnsAlignment(int columnIndex, long columnsCount, int val) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnIndex");
        }
        if ((columnsCount & 0xFFFFFFFFL) < 0L || ((long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL) > (long)this.getColumnCount()) {
            throw new ArgumentOutOfRangeException("columnsCount");
        }
        long l = (long)columnIndex + (columnsCount & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n = columnIndex;
        while ((long)n < l) {
            this.ji[n] = val;
            ++n;
        }
    }

    @Override
    public final void insertRowBefore(int rowIndex) {
        this.pb.insertItem(rowIndex, this.kg(this.getColumnCount()));
    }

    @Override
    public final void insertRowAfter(int rowIndex) {
        this.insertRowBefore(rowIndex + 1);
    }

    @Override
    public final void deleteRow(int rowIndex) {
        if (this.getRowCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing row in the matrix");
        }
        this.pb.removeAt(rowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void insertColumnBefore(int columnIndex) {
        IGenericEnumerator iGenericEnumerator = this.pb.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.insertItem(columnIndex, null);
            }
        }
        finally {
            if (com.aspose.slides.internal.po.k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    public final void insertColumnAfter(int columnIndex) {
        this.insertColumnBefore(columnIndex + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteColumn(int columnIndex) {
        if (this.getColumnCount() == 1) {
            throw new InvalidOperationException("It is not allowed to delete the last existing column in the matrix");
        }
        IGenericEnumerator iGenericEnumerator = this.pb.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                List list = (List)iGenericEnumerator.next();
                list.removeAt(columnIndex);
            }
        }
        finally {
            if (com.aspose.slides.internal.po.k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final IMathElement[] getChildren() {
        Object object;
        IGenericEnumerator iGenericEnumerator;
        IMathElement[] iMathElementArray;
        int n = 0;
        IGenericEnumerator iGenericEnumerator2 = this.pb.iterator();
        try {
            while (iGenericEnumerator2.hasNext()) {
                iMathElementArray = (IMathElement[])iGenericEnumerator2.next();
                iGenericEnumerator = iMathElementArray.iterator();
                try {
                    while (iGenericEnumerator.hasNext()) {
                        object = (IMathElement)iGenericEnumerator.next();
                        if (object == null) continue;
                        ++n;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.po.k7.kg(iGenericEnumerator, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        finally {
            if (com.aspose.slides.internal.po.k7.kg(iGenericEnumerator2, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator2).dispose();
            }
        }
        if (n == 0) {
            return k7;
        }
        iMathElementArray = new IMathElement[n];
        n = 0;
        iGenericEnumerator = this.pb.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                object = (List)iGenericEnumerator.next();
                IGenericEnumerator iGenericEnumerator3 = ((List)object).iterator();
                try {
                    while (iGenericEnumerator3.hasNext()) {
                        IMathElement iMathElement = (IMathElement)iGenericEnumerator3.next();
                        if (iMathElement == null) continue;
                        iMathElementArray[n++] = iMathElement;
                    }
                }
                finally {
                    if (com.aspose.slides.internal.po.k7.kg(iGenericEnumerator3, IDisposable.class) == false) continue;
                    ((IDisposable)iGenericEnumerator3).dispose();
                }
            }
            return iMathElementArray;
        }
        finally {
            if (com.aspose.slides.internal.po.k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    @Override
    void kg(wfg wfg2) {
        wfg2.kg(this);
    }

    private List<IMathElement> kg(int n) {
        List<IMathElement> list = new List<IMathElement>(n);
        for (int i = 0; i < n; ++i) {
            list.addItem(null);
        }
        return list;
    }
}

