/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.IChartDataPoint;
import com.aspose.slides.IChartDataPointCollection;
import com.aspose.slides.IChartSeriesGroup;
import com.aspose.slides.IPieSplitCustomPointCollection;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentOutOfRangeException;
import com.aspose.slides.internal.po.k7;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.m9;

public class PieSplitCustomPointCollection
implements IPieSplitCustomPointCollection {
    private final IChartSeriesGroup kg;
    private final List<IChartDataPoint> pr;

    @Override
    public final IChartDataPoint get_Item(int index) {
        return this.pr.get_Item(index);
    }

    @Override
    public final void add(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.kg.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(m9.kg("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        IChartDataPoint iChartDataPoint = iChartDataPointCollection.get_Item(dataPointIndex);
        if (this.pr.containsItem(iChartDataPoint)) {
            throw new ArgumentException("Data point is already added");
        }
        this.pr.addItem(iChartDataPoint);
    }

    @Override
    public void addItem(IChartDataPoint dataPoint) {
        this.kg(dataPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void kg(IChartDataPoint iChartDataPoint) {
        IChartDataPointCollection iChartDataPointCollection = this.kg.get_Item(0).getDataPoints();
        IGenericEnumerator iGenericEnumerator = iChartDataPointCollection.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IChartDataPoint iChartDataPoint2 = (IChartDataPoint)iGenericEnumerator.next();
                if (iChartDataPoint2 != iChartDataPoint) continue;
                this.pr.addItem(iChartDataPoint);
                return;
            }
        }
        finally {
            if (k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        throw new ArgumentException("Coudn't find dataPoint in parent series. Allowed adding dataPoint only from same chart and parent series");
    }

    @Override
    public boolean removeItem(IChartDataPoint dataPoint) {
        return this.pr(dataPoint);
    }

    final boolean pr(IChartDataPoint iChartDataPoint) {
        return this.pr.removeItem(iChartDataPoint);
    }

    @Override
    public final void remove(int dataPointIndex) {
        if (dataPointIndex < 0) {
            throw new ArgumentOutOfRangeException();
        }
        IChartDataPointCollection iChartDataPointCollection = this.kg.get_Item(0).getDataPoints();
        if (dataPointIndex >= iChartDataPointCollection.size()) {
            throw new ArgumentException(m9.kg("Point with index '{0}' was not found", new Object[]{dataPointIndex}), "dataPointIndex");
        }
        this.pr.removeItem(iChartDataPointCollection.get_Item(dataPointIndex));
    }

    @Override
    public final void clear() {
        this.pr.clear();
    }

    @Override
    public boolean containsItem(IChartDataPoint item) {
        return this.k7(item);
    }

    final boolean k7(IChartDataPoint iChartDataPoint) {
        return this.pr.containsItem(iChartDataPoint);
    }

    public void copyToTArray(IChartDataPoint[] array, int arrayIndex) {
        this.kg(array, arrayIndex);
    }

    final void kg(IChartDataPoint[] iChartDataPointArray, int n) {
        this.pr.copyToTArray((IChartDataPoint[])iChartDataPointArray, n);
    }

    @Override
    public final int size() {
        return this.pr.size();
    }

    @Override
    public final boolean isReadOnly() {
        return this.pr.isReadOnly();
    }

    public final boolean isSynchronized() {
        return false;
    }

    public final Object getSyncRoot() {
        return this;
    }

    @Override
    public final IGenericEnumerator<IChartDataPoint> iterator() {
        return this.pr.iterator();
    }

    public final IGenericEnumerator<IChartDataPoint> iteratorJava() {
        return this.pr.iteratorJava();
    }

    PieSplitCustomPointCollection(IChartSeriesGroup parentSeriesGroup) {
        this.kg = parentSeriesGroup;
        this.pr = new List();
    }
}

