/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Cell;
import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.List;
import com.aspose.slides.Collections.Generic.SortedDictionary;
import com.aspose.slides.GroupShape;
import com.aspose.slides.IAutoShape;
import com.aspose.slides.IBaseSlide;
import com.aspose.slides.IChart;
import com.aspose.slides.IFindResultCallback;
import com.aspose.slides.IGroupShape;
import com.aspose.slides.IParagraph;
import com.aspose.slides.IPresentation;
import com.aspose.slides.IShape;
import com.aspose.slides.IShapeCollection;
import com.aspose.slides.ISlide;
import com.aspose.slides.ISlideComponent;
import com.aspose.slides.ISmartArt;
import com.aspose.slides.ISmartArtNode;
import com.aspose.slides.ITable;
import com.aspose.slides.ITextFrame;
import com.aspose.slides.ITextSearchOptions;
import com.aspose.slides.PortionFormat;
import com.aspose.slides.Presentation;
import com.aspose.slides.Row;
import com.aspose.slides.TextFrame;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.po.k7;
import com.aspose.slides.internal.t2.lc;
import com.aspose.slides.internal.we.u5;
import com.aspose.slides.j6u;
import com.aspose.slides.l1z;
import com.aspose.slides.lzx;
import com.aspose.slides.ms.System.IDisposable;
import com.aspose.slides.ms.System.m9;

public class SlideUtil {
    public static IShape findShape(IPresentation pres, String altText) {
        IShape iShape;
        int n;
        for (n = 0; n < pres.getMasters().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getMasters().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            iShape = SlideUtil.findShape(pres.getSlides().get_Item(n), altText);
            if (iShape == null) continue;
            return iShape;
        }
        return null;
    }

    public static IShape findShape(IBaseSlide slide, String altText) {
        return SlideUtil.kg(slide.getShapes(), altText);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide) {
        int[] nArray = new int[slide.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.kg(alignmentType, alignToSlide, slide.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IBaseSlide slide, int[] shapeIndexes) {
        SlideUtil.kg(alignmentType, alignToSlide, slide.getShapes(), shapeIndexes);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape) {
        int[] nArray = new int[groupShape.getShapes().size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = i;
        }
        SlideUtil.kg(alignmentType, alignToSlide, groupShape.getShapes(), nArray);
    }

    public static void alignShapes(int alignmentType, boolean alignToSlide, IGroupShape groupShape, int[] shapeIndexes) {
        SlideUtil.kg(alignmentType, alignToSlide, groupShape.getShapes(), shapeIndexes);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace) {
        SlideUtil.findAndReplaceText(presentation, withMasters, find, replace, null);
    }

    public static void findAndReplaceText(IPresentation presentation, boolean withMasters, String find, String replace, PortionFormat format) {
        if (presentation == null) {
            throw new ArgumentNullException("presentation");
        }
        if (m9.kg(find)) {
            throw new ArgumentException("String to find can not be null or empty", "find");
        }
        if (replace == null) {
            throw new ArgumentNullException("replace");
        }
        if (m9.b0(find, replace)) {
            throw new ArgumentException("String to find can not be equal to string to find");
        }
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, withMasters)) {
            SlideUtil.kg(iTextFrame, find, replace, format);
            iTextFrame.joinPortionsWithSameFormatting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void kg(ITextFrame iTextFrame, String string, String string2, PortionFormat portionFormat) {
        IGenericEnumerator iGenericEnumerator = iTextFrame.getParagraphs().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IParagraph iParagraph = (IParagraph)iGenericEnumerator.next();
                SlideUtil.kg(iParagraph, string, string2, portionFormat);
            }
        }
        finally {
            if (k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    private static void kg(IParagraph iParagraph, String string, String string2, PortionFormat portionFormat) {
        if (m9.b0(string, string2)) {
            return;
        }
        j6u j6u2 = j6u.kg(iParagraph);
        while (j6u2.kg(string, string2, portionFormat)) {
        }
        iParagraph.getPortions().clear();
        j6u2.pr(iParagraph);
    }

    public static ITextFrame[] getAllTextBoxes(IBaseSlide slide) {
        List<ITextFrame> list = new List<ITextFrame>();
        SlideUtil.kg(slide.getShapes(), list);
        return list.toArray((ITextFrame[])new ITextFrame[0]);
    }

    public static ITextFrame[] getAllTextFrames(IPresentation pres, boolean withMasters) {
        int n;
        List<ITextFrame> list = new List<ITextFrame>();
        if (withMasters) {
            for (n = 0; n < pres.getMasters().size(); ++n) {
                SlideUtil.kg(pres.getMasters().get_Item(n).getShapes(), list);
            }
        }
        for (n = 0; n < pres.getSlides().size(); ++n) {
            SlideUtil.kg(pres.getSlides().get_Item(n).getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static ITextFrame[] kg(IPresentation iPresentation, int[] nArray, boolean bl2) {
        List<ITextFrame> list = new List<ITextFrame>();
        for (int n : nArray) {
            SlideUtil.kg(iPresentation.getSlides().get_Item(n - 1).getShapes(), list);
            if (!bl2) continue;
            SlideUtil.kg(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getShapes(), list);
            SlideUtil.kg(iPresentation.getSlides().get_Item(n - 1).getLayoutSlide().getMasterSlide().getShapes(), list);
        }
        return list.toArray(new ITextFrame[0]);
    }

    static String kg(IPresentation iPresentation, int[] nArray) {
        u5 u52 = new u5();
        for (int n : nArray) {
            ITextFrame[] iTextFrameArray;
            ISlide iSlide = iPresentation.getSlides().get_Item(n - 1);
            for (ITextFrame iTextFrame : iTextFrameArray = SlideUtil.getAllTextBoxes(iSlide)) {
                u52.kg(iTextFrame.getText());
            }
        }
        return u52.toString();
    }

    private static void kg(int n, boolean bl2, IShapeCollection iShapeCollection, int[] nArray) {
        int n10;
        if (nArray == null) {
            throw new ArgumentNullException("shapeIndexes");
        }
        if (nArray.length == 0) {
            throw new ArgumentException("Indexes of shapes to be aligned should not be empty", "shapeIndexes");
        }
        SortedDictionary<Integer, Integer> sortedDictionary = new SortedDictionary<Integer, Integer>();
        int[] objectArray = nArray;
        int list = objectArray.length;
        for (n10 = 0; n10 < list; ++n10) {
            int n11 = objectArray[n10];
            if (n11 < 0) {
                throw new ArgumentException("Indexes of shapes to be aligned should be positive", "shapeIndexes");
            }
            if (sortedDictionary.containsKey(n11)) continue;
            sortedDictionary.addItem(n11, n11);
        }
        Integer[] integerArray = new Integer[sortedDictionary.size()];
        ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).copyTo(integerArray, 0);
        if (integerArray[integerArray.length - 1] > iShapeCollection.size() - 1) {
            throw new ArgumentException("Indexes of shapes to be aligned should correspond to slide shape indexes", "shapeIndexes");
        }
        List<IShape> list2 = new List<IShape>(((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size());
        for (n10 = 0; n10 < ((SortedDictionary.KeyCollection)sortedDictionary.getKeys()).size(); ++n10) {
            list2.addItem(iShapeCollection.get_Item(nArray[n10]));
        }
        l1z.kg(n, bl2, list2);
    }

    private static IShape kg(IShapeCollection iShapeCollection, String string) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            IShape iShape;
            IShape iShape2 = iShapeCollection.get_Item(i);
            if (m9.sk(iShape2.getAlternativeText(), string) == 0) {
                return iShape2;
            }
            if (!k7.pr((Object)iShape2, GroupShape.class) || (iShape = SlideUtil.kg(((GroupShape)iShape2).getShapes(), string)) == null) continue;
            return iShape;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void kg(IShapeCollection iShapeCollection, List<ITextFrame> list) {
        for (int i = 0; i < iShapeCollection.size(); ++i) {
            Object object;
            ISlideComponent iSlideComponent;
            if (k7.pr((Object)iShapeCollection.get_Item(i), IGroupShape.class)) {
                SlideUtil.kg(((IGroupShape)iShapeCollection.get_Item(i)).getShapes(), list);
                continue;
            }
            IAutoShape iAutoShape = (IAutoShape)((Object)k7.kg(iShapeCollection.get_Item(i), IAutoShape.class));
            if (iAutoShape != null) {
                iSlideComponent = iAutoShape.getTextFrame();
                if (iSlideComponent == null) continue;
                list.addItem((ITextFrame)iSlideComponent);
                continue;
            }
            iSlideComponent = (ITable)((Object)k7.kg(iShapeCollection.get_Item(i), ITable.class));
            if (iSlideComponent != null) {
                for (int j = 0; j < iSlideComponent.getRows().size(); ++j) {
                    for (int k = 0; k < iSlideComponent.getColumns().size(); ++k) {
                        object = ((Row)iSlideComponent.getRows().get_Item(j)).kg(k);
                        if (((Cell)object).getTextFrame() == null) continue;
                        list.addItem(((Cell)object).getTextFrame());
                    }
                }
                continue;
            }
            IChart iChart = (IChart)((Object)k7.kg(iShapeCollection.get_Item(i), IChart.class));
            if (iChart != null && iChart.getUserShapes() != null) {
                SlideUtil.kg(iChart.getUserShapes().getShapes(), list);
                continue;
            }
            ISmartArt iSmartArt = (ISmartArt)((Object)k7.kg(iShapeCollection.get_Item(i), ISmartArt.class));
            if (iSmartArt == null) continue;
            object = iSmartArt.getAllNodes();
            IGenericEnumerator iGenericEnumerator = object.iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    ISmartArtNode iSmartArtNode = (ISmartArtNode)iGenericEnumerator.next();
                    list.addItem(iSmartArtNode.getTextFrame());
                }
                continue;
            }
            finally {
                if (k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
    }

    private static lzx kg(Presentation presentation, String string, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        if (m9.kg(string)) {
            throw new ArgumentException("Text to highlight can not be null or empty", "text");
        }
        int n = 0;
        if (iTextSearchOptions != null && !iTextSearchOptions.getCaseSensitive()) {
            n |= 0x42;
        }
        com.aspose.slides.internal.s3.lc lc2 = new com.aspose.slides.internal.s3.lc("\\-\\[\\]\\{\\}\\(\\)\\*\\+\\?\\.\\,\\\\\\^\\$\\|#\\s");
        String string2 = lc2.k7(string, "\\$0");
        if (iTextSearchOptions != null && iTextSearchOptions.getWholeWordsOnly()) {
            string2 = m9.kg(new String[]{"\\b", string2, "\\b"});
        }
        com.aspose.slides.internal.s3.lc lc4 = new com.aspose.slides.internal.s3.lc(string2, n);
        return SlideUtil.pr(presentation, lc4, iFindResultCallback);
    }

    private static lzx kg(Presentation presentation, com.aspose.slides.internal.s3.lc lc2, IFindResultCallback iFindResultCallback) {
        if (lc2 == null) {
            throw new ArgumentException("Regex to highlight can not be null", "regex");
        }
        return SlideUtil.pr(presentation, lc2, iFindResultCallback);
    }

    private static lzx pr(Presentation presentation, com.aspose.slides.internal.s3.lc lc2, IFindResultCallback iFindResultCallback) {
        lzx lzx2 = new lzx(lc2);
        for (ITextFrame iTextFrame : SlideUtil.getAllTextFrames(presentation, false)) {
            TextFrame textFrame = (TextFrame)iTextFrame;
            textFrame.kg(lc2, iFindResultCallback);
            if (textFrame.k7.b0() <= 0) continue;
            lzx2.kg(textFrame);
        }
        return lzx2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void kg(Presentation presentation, String string, lc lc2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        lzx lzx2 = SlideUtil.kg(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzx2.pr().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.kg(lzx2.kg(), lc2.h2());
            }
        }
        finally {
            if (k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void kg(Presentation presentation, com.aspose.slides.internal.s3.lc lc2, lc lc4, IFindResultCallback iFindResultCallback) {
        lzx lzx2 = SlideUtil.kg(presentation, lc2, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzx2.pr().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.kg(lzx2.kg(), lc4.h2());
            }
        }
        finally {
            if (k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void kg(Presentation presentation, String string, String string2, ITextSearchOptions iTextSearchOptions, IFindResultCallback iFindResultCallback) {
        lzx lzx2 = SlideUtil.kg(presentation, string, iTextSearchOptions, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzx2.pr().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.kg(lzx2.kg(), string2);
            }
        }
        finally {
            if (k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void kg(Presentation presentation, com.aspose.slides.internal.s3.lc lc2, String string, IFindResultCallback iFindResultCallback) {
        lzx lzx2 = SlideUtil.kg(presentation, lc2, iFindResultCallback);
        IGenericEnumerator iGenericEnumerator = lzx2.pr().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                TextFrame textFrame = (TextFrame)iGenericEnumerator.next();
                textFrame.kg(lzx2.kg(), string);
            }
        }
        finally {
            if (k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }
}

