/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides;

import com.aspose.slides.Collections.Generic.IGenericEnumerator;
import com.aspose.slides.Collections.Generic.KeyValuePair;
import com.aspose.slides.IOutputFile;
import com.aspose.slides.Input;
import com.aspose.slides.Output;
import com.aspose.slides.Storage;
import com.aspose.slides.WebDocumentOptions;
import com.aspose.slides.exceptions.ArgumentException;
import com.aspose.slides.exceptions.ArgumentNullException;
import com.aspose.slides.internal.po.k7;
import com.aspose.slides.ms.System.IDisposable;

public class WebDocument {
    private final WebDocumentOptions kg;
    private final Input pr;
    private final Output k7;
    private final Storage a5 = new Storage();

    public WebDocument(WebDocumentOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        if (options.getTemplateEngine() == null) {
            throw new ArgumentException("TemplateEngine should not be null", "options");
        }
        if (options.getOutputSaver() == null) {
            throw new ArgumentException("OutputSaver should not be null", "options");
        }
        this.kg = options;
        this.pr = new Input(this.kg.getTemplateEngine());
        this.k7 = new Output(this.kg.getTemplateEngine(), this.a5);
    }

    public final void save() {
        IGenericEnumerator iGenericEnumerator = this.k7.kg().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                this.kg.getOutputSaver().save((String)keyValuePair.getKey(), (IOutputFile)keyValuePair.getValue());
            }
        }
        finally {
            if (com.aspose.slides.internal.po.k7.kg(iGenericEnumerator, IDisposable.class) != false) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
    }

    public final Input getInput() {
        return this.pr;
    }

    public final Output getOutput() {
        return this.k7;
    }

    public final Storage getGlobal() {
        return this.a5;
    }
}

