/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.slides.internal.zp;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class k7
implements BufferedImageOp,
RasterOp {
    private AffineTransform kg;
    private RenderingHints pr;

    public k7(AffineTransform affineTransform, int n) {
        this.kg = affineTransform;
        if (affineTransform.getDeterminant() == 0.0) {
            throw new ImagingOpException(null);
        }
        switch (n) {
            case 2: {
                this.pr = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                break;
            }
            case 3: {
                this.pr = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                break;
            }
            default: {
                this.pr = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
        }
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM != null) {
            return new BufferedImage(destCM, this.createCompatibleDestRaster(src.getRaster()), src.isAlphaPremultiplied(), null);
        }
        if (src.getType() == 3 || src.getType() == 6 || src.getType() == 7) {
            return new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        }
        return new BufferedImage(src.getWidth(), src.getHeight(), 2);
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        Rectangle2D rectangle2D = this.getBounds2D(src);
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            throw new RasterFormatException("width or height is 0");
        }
        return src.createCompatibleWritableRaster((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == src) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
        }
        Graphics2D graphics2D = dst.createGraphics();
        graphics2D.setRenderingHints(this.pr);
        graphics2D.drawImage(src, this.kg, null);
        return dst;
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        if (dst == src) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        }
        if (src.getNumBands() != dst.getNumBands()) {
            throw new IllegalArgumentException("src and dst must have same number of bands");
        }
        if (ColorModel.getRGBdefault().isCompatibleSampleModel(src.getSampleModel()) && ColorModel.getRGBdefault().isCompatibleSampleModel(dst.getSampleModel())) {
            WritableRaster writableRaster = Raster.createWritableRaster(src.getSampleModel(), src.getDataBuffer(), new Point(src.getMinX(), src.getMinY()));
            BufferedImage bufferedImage = new BufferedImage(ColorModel.getRGBdefault(), writableRaster, false, null);
            BufferedImage bufferedImage2 = new BufferedImage(ColorModel.getRGBdefault(), dst, false, null);
            return this.filter(bufferedImage, bufferedImage2).getRaster();
        }
        double[] dArray = new double[dst.getHeight() * dst.getWidth() * 2];
        double[] dArray2 = new double[dst.getHeight() * dst.getWidth() * 2];
        int n = 0;
        for (int i = 0; i < dst.getWidth(); ++i) {
            for (int j = 0; j < dst.getHeight(); ++j) {
                dArray[n++] = i;
                dArray[n++] = j;
            }
        }
        Rectangle rectangle = src.getBounds();
        try {
            AffineTransform affineTransform = this.kg.createInverse();
            affineTransform.transform(dArray, 0, dArray2, 0, dArray.length / 2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new ImagingOpException(noninvertibleTransformException.getMessage());
        }
        if (this.pr.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
            this.kg(src, dst, dArray, dArray2);
        } else if (this.pr.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            this.pr(src, dst, dArray, dArray2);
        } else {
            this.k7(src, dst, dArray, dArray2);
        }
        return dst;
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return this.kg.createTransformedShape(src.getBounds()).getBounds2D();
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.kg.transform(srcPt, dstPt);
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.pr;
    }

    private void kg(Raster raster, WritableRaster writableRaster, double[] dArray, double[] dArray2) {
        Rectangle rectangle = raster.getBounds();
        for (int i = 0; i < dArray.length; i += 2) {
            int n;
            int n10 = (int)Math.round(dArray2[i]) + raster.getMinX();
            if (!rectangle.contains(n10, n = (int)Math.round(dArray2[i + 1]) + raster.getMinY())) continue;
            writableRaster.setDataElements((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), raster.getDataElements(n10, n, null));
        }
    }

    private void pr(Raster raster, WritableRaster writableRaster, double[] dArray, double[] dArray2) {
        Rectangle rectangle = raster.getBounds();
        Object[] objectArray = null;
        Object[] objectArray2 = null;
        Object[] objectArray3 = null;
        Object[] objectArray4 = null;
        double[] dArray3 = new double[raster.getNumBands()];
        for (int i = 0; i < dArray.length; i += 2) {
            int n;
            int n10 = (int)Math.round(dArray2[i]) + raster.getMinX();
            if (!rectangle.contains(n10, n = (int)Math.round(dArray2[i + 1]) + raster.getMinY())) continue;
            if (dArray2[i] >= (double)(raster.getWidth() - 1) || dArray2[i + 1] >= (double)(raster.getHeight() - 1)) {
                writableRaster.setDataElements((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), raster.getDataElements(n10, n, null));
                continue;
            }
            int n11 = (int)Math.floor(dArray2[i] + (double)raster.getMinX());
            int n12 = (int)Math.floor(dArray2[i + 1] + (double)raster.getMinY());
            double d = dArray2[i] + (double)raster.getMinX() - (double)n11;
            double d10 = dArray2[i + 1] + (double)raster.getMinY() - (double)n12;
            if (raster.getTransferType() == 5 || raster.getTransferType() == 4) {
                objectArray = raster.getPixel(n11, n12, (double[])objectArray);
                objectArray2 = raster.getPixel(n11 + 1, n12, (double[])objectArray2);
                objectArray3 = raster.getPixel(n11, n12 + 1, (double[])objectArray3);
                objectArray4 = raster.getPixel(n11 + 1, n12 + 1, (double[])objectArray4);
            } else {
                objectArray = raster.getPixel(n11, n12, (int[])objectArray);
                objectArray2 = raster.getPixel(n11 + 1, n12, (int[])objectArray2);
                objectArray3 = raster.getPixel(n11, n12 + 1, (int[])objectArray3);
                objectArray4 = raster.getPixel(n11 + 1, n12 + 1, (int[])objectArray4);
            }
            for (int j = 0; j < raster.getNumBands(); ++j) {
                double d11;
                double d12;
                double d13;
                double d14;
                if (raster.getTransferType() == 5 || raster.getTransferType() == 4) {
                    d14 = objectArray[j];
                    d13 = objectArray2[j];
                    d12 = objectArray3[j];
                    d11 = objectArray4[j];
                } else {
                    d14 = ((int[])objectArray)[j];
                    d13 = ((int[])objectArray2)[j];
                    d12 = ((int[])objectArray3)[j];
                    d11 = ((int[])objectArray4)[j];
                }
                dArray3[j] = d14 == d13 && d14 == d12 && d14 == d11 ? d14 : (d14 * (1.0 - d) + d13 * d) * (1.0 - d10) + (d12 * (1.0 - d) + d11 * d) * d10;
            }
            writableRaster.setPixel((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), dArray3);
        }
    }

    private void k7(Raster raster, WritableRaster writableRaster, double[] dArray, double[] dArray2) {
        Rectangle rectangle = raster.getBounds();
        double[] dArray3 = new double[raster.getNumBands()];
        Object[] objectArray = null;
        for (int i = 0; i < dArray.length; i += 2) {
            if (!rectangle.contains((int)Math.round(dArray2[i]) + raster.getMinX(), (int)Math.round(dArray2[i + 1]) + raster.getMinY())) continue;
            int n = (int)Math.floor(dArray2[i] + (double)raster.getMinX());
            int n10 = (int)Math.floor(dArray2[i + 1] + (double)raster.getMinY());
            double d = dArray2[i] + (double)raster.getMinX() - (double)n;
            double d10 = dArray2[i + 1] + (double)raster.getMinY() - (double)n10;
            Arrays.fill(dArray3, 0.0);
            for (int j = -1; j < 3; ++j) {
                for (int k = -1; k < 3; ++k) {
                    int n11;
                    double d11 = 0.0;
                    double d12 = 0.0;
                    double d13 = (double)j - d + 2.0;
                    d11 += d13 * d13 * d13;
                    d13 = (double)j - d + 1.0;
                    if (d13 > 0.0) {
                        d11 -= 4.0 * d13 * d13 * d13;
                    }
                    if ((d13 = (double)j - d) > 0.0) {
                        d11 += 6.0 * d13 * d13 * d13;
                    }
                    if ((d13 = (double)j - d - 1.0) > 0.0) {
                        d11 -= 4.0 * d13 * d13 * d13;
                    }
                    d11 /= 6.0;
                    d13 = d10 - (double)k + 2.0;
                    if (d13 > 0.0) {
                        d12 += d13 * d13 * d13;
                    }
                    if ((d13 = d10 - (double)k + 1.0) > 0.0) {
                        d12 -= 4.0 * d13 * d13 * d13;
                    }
                    if ((d13 = d10 - (double)k) > 0.0) {
                        d12 += 6.0 * d13 * d13 * d13;
                    }
                    if ((d13 = d10 - (double)k - 1.0) > 0.0) {
                        d12 -= 4.0 * d13 * d13 * d13;
                    }
                    d12 /= 6.0;
                    int n12 = n + j;
                    if (n12 >= raster.getMinX() + raster.getWidth()) {
                        n12 = raster.getMinX() + raster.getWidth() - 1;
                    } else if (n12 < raster.getMinX()) {
                        n12 = raster.getMinX();
                    }
                    int n13 = n10 + k;
                    if (n13 >= raster.getMinY() + raster.getHeight()) {
                        n13 = raster.getMinY() + raster.getHeight() - 1;
                    } else if (n13 < raster.getMinY()) {
                        n13 = raster.getMinY();
                    }
                    if (raster.getTransferType() == 5 || raster.getTransferType() == 4) {
                        objectArray = raster.getPixel(n12, n13, (double[])objectArray);
                        for (n11 = 0; n11 < dArray3.length; ++n11) {
                            int n14 = n11;
                            dArray3[n14] = dArray3[n14] + objectArray[n11] * d11 * d12;
                        }
                        continue;
                    }
                    objectArray = raster.getPixel(n12, n13, (int[])objectArray);
                    for (n11 = 0; n11 < dArray3.length; ++n11) {
                        int n15 = n11;
                        dArray3[n15] = dArray3[n15] + (double)((int[])objectArray)[n11] * d11 * d12;
                    }
                }
            }
            writableRaster.setPixel((int)dArray[i] + writableRaster.getMinX(), (int)dArray[i + 1] + writableRaster.getMinY(), dArray3);
        }
    }
}

