/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.servlet;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.io.download.PublicDownloadHelper;
import org.nuxeo.ecm.platform.ui.web.download.DownloadServlet;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.NuxeoLoginContext;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PublicDownloadServlet
extends DownloadServlet {
    private static final Log log = LogFactory.getLog(PublicDownloadServlet.class);

    protected void handleDownload(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        URL url;
        try {
            url = new URL(httpRequest.getRequestURL().toString());
        }
        catch (MalformedURLException e) {
            httpResponse.setStatus(400);
            return;
        }
        String baseUrl = VirtualHostHelper.getBaseURL((ServletRequest)httpRequest);
        String fullPath = url.getPath();
        String path = fullPath.substring(fullPath.indexOf("nxpublicfile") + "nxpublicfile".length() + 1);
        String token = httpRequest.getParameter("download_token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            httpResponse.setStatus(400);
            return;
        }
        try (NuxeoLoginContext loginContext = Framework.loginUser((String)("transient/" + token));){
            boolean isValid = (Boolean)TransactionHelper.runInTransaction(() -> PublicDownloadHelper.isValidPublicDownloadRequest(path, token));
            if (isValid) {
                DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
                downloadService.handleDownload(httpRequest, httpResponse, baseUrl, "nxfile/" + path);
            } else {
                httpResponse.setStatus(404);
            }
        }
        catch (LoginException | DocumentSecurityException e) {
            log.warn((Object)e);
            httpResponse.setStatus(404);
        }
    }
}

