/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.automation;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkService;

@Operation(id="RevokePublicDownloadLink", category="Document", label="Revoke a public download url", description="Revoke a public download url")
public class RevokePublicDownloadLinkOp {
    public static final String ID = "RevokePublicDownloadLink";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Context
    protected PublicDownloadLinkService publicDownloadLinkService;
    @Param(name="xpath", required=false, description="File xpath")
    protected String xpath = "file:content";
    @Param(name="all", required=false, description="Set to true to revoke all links")
    protected boolean all = false;
    @Param(name="save", required=false, description="Set to true to save the document")
    protected boolean save = true;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        boolean changed = false;
        if (this.all) {
            this.publicDownloadLinkService.removePublicDownloadPermissions(doc);
            changed = true;
        } else if (this.publicDownloadLinkService.hasPublicDownloadPermission(doc, this.xpath)) {
            this.publicDownloadLinkService.removePublicDownloadPermission(doc, this.xpath);
            changed = true;
        }
        if (changed && this.save) {
            this.session.saveDocument(doc);
        }
        return doc;
    }
}

