/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.automation;

import java.util.Calendar;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkService;

@Operation(id="CreatePublicDownloadLink", category="Document", label="Get a public download url", description="Get a public download url")
public class CreatePublicDownloadLinkOp {
    public static final String ID = "CreatePublicDownloadLink";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Context
    protected PublicDownloadLinkService publicDownloadLinkService;
    @Param(name="xpath", required=false, description="File xpath")
    protected String xpath = "file:content";
    @Param(name="begin", required=false, description="Public link start date")
    protected Calendar begin;
    @Param(name="end", required=false, description="Public link end date")
    protected Calendar end;
    @Param(name="replace", required=false, description="Replace an existing eprmission, if any")
    protected boolean replace = false;
    @Param(name="save", required=false, description="Set to true to save the document")
    protected boolean save = true;

    @OperationMethod
    public Blob run(DocumentModel doc) {
        boolean hasPermission = this.publicDownloadLinkService.hasPublicDownloadPermission(doc, this.xpath);
        boolean addPermission = true;
        if (hasPermission) {
            if (this.replace) {
                this.publicDownloadLinkService.removePublicDownloadPermission(doc, this.xpath);
            } else {
                addPermission = false;
            }
        }
        if (addPermission) {
            this.publicDownloadLinkService.setPublicDownloadPermission(doc, this.xpath, this.begin, this.end);
            if (this.save) {
                this.session.saveDocument(doc);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(this.xpath, (Object)this.publicDownloadLinkService.getPublicDownloadLink(doc, this.xpath));
        return new StringBlob(jsonObject.toString(), "application/json");
    }
}

