/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.download.link.aws;

import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.labs.download.link.service.PublicDownloadLinkBuilder;
import org.nuxeo.runtime.api.Framework;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.services.cloudfront.CloudFrontClient;
import software.amazon.awssdk.services.cloudfront.CloudFrontClientBuilder;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.InvalidationBatch;
import software.amazon.awssdk.services.cloudfront.model.Paths;

public class CloudfrontPublicDownloadLinkBuilder
implements PublicDownloadLinkBuilder {
    public static final String CLOUDFRONT_DISTRIB_NAME_PROPERTY = "nuxeo.s3storage.cloudfront.distribDomain";
    public static final String CLOUDFRONT_DISTRIB_ID_PROPERTY = "nuxeo.s3storage.cloudfront.distribId";
    public static final String CLOUDFRONT_PREFIX = "public";

    public String getPublicDownloadLink(DocumentModel doc, String xpath, String token) {
        String distributionName = Framework.getProperty((String)CLOUDFRONT_DISTRIB_NAME_PROPERTY);
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        Blob blob = downloadService.resolveBlob(doc, xpath);
        String downloadPath = downloadService.getDownloadUrl(doc, xpath, blob.getFilename()).replace("nxfile", "nxpublicfile");
        return String.format("https://%s/%s/%s/%s", distributionName, CLOUDFRONT_PREFIX, token, downloadPath);
    }

    public void publicDownloadPermissionRevoked(DocumentModel doc, String xpath, String link) {
        String distributionId = Framework.getProperty((String)CLOUDFRONT_DISTRIB_ID_PROPERTY);
        CloudFrontClient cloudFrontClient = (CloudFrontClient)((CloudFrontClientBuilder)CloudFrontClient.builder().credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create())).build();
        InvalidationBatch invalidationBatch = (InvalidationBatch)InvalidationBatch.builder().paths((Paths)Paths.builder().quantity(Integer.valueOf(1)).items(new String[]{link}).build()).callerReference(String.valueOf(System.currentTimeMillis())).build();
        CreateInvalidationRequest invalidationRequest = (CreateInvalidationRequest)CreateInvalidationRequest.builder().distributionId(distributionId).invalidationBatch(invalidationBatch).build();
        CreateInvalidationResponse response = cloudFrontClient.createInvalidation(invalidationRequest);
    }
}

