/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FunctionRuntime {
    CLOUDFRONT_JS_1_0("cloudfront-js-1.0"),
    CLOUDFRONT_JS_2_0("cloudfront-js-2.0"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FunctionRuntime> VALUE_MAP;
    private final String value;

    private FunctionRuntime(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FunctionRuntime fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FunctionRuntime> knownValues() {
        EnumSet<FunctionRuntime> knownValues = EnumSet.allOf(FunctionRuntime.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FunctionRuntime.class, FunctionRuntime::toString);
    }
}

