/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudfront.model.OriginProtocolPolicy;
import software.amazon.awssdk.services.cloudfront.model.OriginSslProtocols;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VpcOriginEndpointConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VpcOriginEndpointConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(VpcOriginEndpointConfig.getter(VpcOriginEndpointConfig::name)).setter(VpcOriginEndpointConfig.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(VpcOriginEndpointConfig.getter(VpcOriginEndpointConfig::arn)).setter(VpcOriginEndpointConfig.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").unmarshallLocationName("Arn").build()}).build();
    private static final SdkField<Integer> HTTP_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HTTPPort").getter(VpcOriginEndpointConfig.getter(VpcOriginEndpointConfig::httpPort)).setter(VpcOriginEndpointConfig.setter(Builder::httpPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPPort").unmarshallLocationName("HTTPPort").build()}).build();
    private static final SdkField<Integer> HTTPS_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HTTPSPort").getter(VpcOriginEndpointConfig.getter(VpcOriginEndpointConfig::httpsPort)).setter(VpcOriginEndpointConfig.setter(Builder::httpsPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HTTPSPort").unmarshallLocationName("HTTPSPort").build()}).build();
    private static final SdkField<String> ORIGIN_PROTOCOL_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginProtocolPolicy").getter(VpcOriginEndpointConfig.getter(VpcOriginEndpointConfig::originProtocolPolicyAsString)).setter(VpcOriginEndpointConfig.setter(Builder::originProtocolPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginProtocolPolicy").unmarshallLocationName("OriginProtocolPolicy").build()}).build();
    private static final SdkField<OriginSslProtocols> ORIGIN_SSL_PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OriginSslProtocols").getter(VpcOriginEndpointConfig.getter(VpcOriginEndpointConfig::originSslProtocols)).setter(VpcOriginEndpointConfig.setter(Builder::originSslProtocols)).constructor(OriginSslProtocols::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginSslProtocols").unmarshallLocationName("OriginSslProtocols").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, HTTP_PORT_FIELD, HTTPS_PORT_FIELD, ORIGIN_PROTOCOL_POLICY_FIELD, ORIGIN_SSL_PROTOCOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VpcOriginEndpointConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final Integer httpPort;
    private final Integer httpsPort;
    private final String originProtocolPolicy;
    private final OriginSslProtocols originSslProtocols;

    private VpcOriginEndpointConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.httpPort = builder.httpPort;
        this.httpsPort = builder.httpsPort;
        this.originProtocolPolicy = builder.originProtocolPolicy;
        this.originSslProtocols = builder.originSslProtocols;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer httpPort() {
        return this.httpPort;
    }

    public final Integer httpsPort() {
        return this.httpsPort;
    }

    public final OriginProtocolPolicy originProtocolPolicy() {
        return OriginProtocolPolicy.fromValue(this.originProtocolPolicy);
    }

    public final String originProtocolPolicyAsString() {
        return this.originProtocolPolicy;
    }

    public final OriginSslProtocols originSslProtocols() {
        return this.originSslProtocols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpsPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.originProtocolPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originSslProtocols());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcOriginEndpointConfig)) {
            return false;
        }
        VpcOriginEndpointConfig other = (VpcOriginEndpointConfig)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.httpPort(), other.httpPort()) && Objects.equals(this.httpsPort(), other.httpsPort()) && Objects.equals(this.originProtocolPolicyAsString(), other.originProtocolPolicyAsString()) && Objects.equals(this.originSslProtocols(), other.originSslProtocols());
    }

    public final String toString() {
        return ToString.builder((String)"VpcOriginEndpointConfig").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("HTTPPort", (Object)this.httpPort()).add("HTTPSPort", (Object)this.httpsPort()).add("OriginProtocolPolicy", (Object)this.originProtocolPolicyAsString()).add("OriginSslProtocols", (Object)this.originSslProtocols()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "HTTPPort": {
                return Optional.ofNullable(clazz.cast(this.httpPort()));
            }
            case "HTTPSPort": {
                return Optional.ofNullable(clazz.cast(this.httpsPort()));
            }
            case "OriginProtocolPolicy": {
                return Optional.ofNullable(clazz.cast(this.originProtocolPolicyAsString()));
            }
            case "OriginSslProtocols": {
                return Optional.ofNullable(clazz.cast(this.originSslProtocols()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("HTTPPort", HTTP_PORT_FIELD);
        map.put("HTTPSPort", HTTPS_PORT_FIELD);
        map.put("OriginProtocolPolicy", ORIGIN_PROTOCOL_POLICY_FIELD);
        map.put("OriginSslProtocols", ORIGIN_SSL_PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcOriginEndpointConfig, T> g) {
        return obj -> g.apply((VpcOriginEndpointConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private Integer httpPort;
        private Integer httpsPort;
        private String originProtocolPolicy;
        private OriginSslProtocols originSslProtocols;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcOriginEndpointConfig model) {
            this.name(model.name);
            this.arn(model.arn);
            this.httpPort(model.httpPort);
            this.httpsPort(model.httpsPort);
            this.originProtocolPolicy(model.originProtocolPolicy);
            this.originSslProtocols(model.originSslProtocols);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getHttpPort() {
            return this.httpPort;
        }

        public final void setHttpPort(Integer httpPort) {
            this.httpPort = httpPort;
        }

        @Override
        public final Builder httpPort(Integer httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public final Integer getHttpsPort() {
            return this.httpsPort;
        }

        public final void setHttpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
        }

        @Override
        public final Builder httpsPort(Integer httpsPort) {
            this.httpsPort = httpsPort;
            return this;
        }

        public final String getOriginProtocolPolicy() {
            return this.originProtocolPolicy;
        }

        public final void setOriginProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
        }

        @Override
        public final Builder originProtocolPolicy(String originProtocolPolicy) {
            this.originProtocolPolicy = originProtocolPolicy;
            return this;
        }

        @Override
        public final Builder originProtocolPolicy(OriginProtocolPolicy originProtocolPolicy) {
            this.originProtocolPolicy(originProtocolPolicy == null ? null : originProtocolPolicy.toString());
            return this;
        }

        public final OriginSslProtocols.Builder getOriginSslProtocols() {
            return this.originSslProtocols != null ? this.originSslProtocols.toBuilder() : null;
        }

        public final void setOriginSslProtocols(OriginSslProtocols.BuilderImpl originSslProtocols) {
            this.originSslProtocols = originSslProtocols != null ? originSslProtocols.build() : null;
        }

        @Override
        public final Builder originSslProtocols(OriginSslProtocols originSslProtocols) {
            this.originSslProtocols = originSslProtocols;
            return this;
        }

        public VpcOriginEndpointConfig build() {
            return new VpcOriginEndpointConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VpcOriginEndpointConfig> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder httpPort(Integer var1);

        public Builder httpsPort(Integer var1);

        public Builder originProtocolPolicy(String var1);

        public Builder originProtocolPolicy(OriginProtocolPolicy var1);

        public Builder originSslProtocols(OriginSslProtocols var1);

        default public Builder originSslProtocols(Consumer<OriginSslProtocols.Builder> originSslProtocols) {
            return this.originSslProtocols((OriginSslProtocols)((OriginSslProtocols.Builder)OriginSslProtocols.builder().applyMutation(originSslProtocols)).build());
        }
    }
}

