/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.quota.webui.operations;

import nuxeo.quota.webui.QuotaConfigInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.quota.size.QuotaAware;

@Operation(id="Quota.GetContainerQuota", category="Quotas", label="Quota: Get Container Quota", description="Return the quota info on the input container. quotaValue <= 0 means no quota is set. Also return info on the max possible size.")
public class QuotaGetOnContainer {
    private static final Logger log = LogManager.getLogger(QuotaGetOnContainer.class);
    public static final String ID = "Quota.GetContainerQuota";
    @Context
    protected CoreSession session;

    @OperationMethod
    public Blob run(DocumentModel input) {
        JSONObject jsonObj = new JSONObject();
        if (input == null) {
            throw new IllegalArgumentException("An input document isrequired");
        }
        long maxSize = -1L;
        if ("UserWorkspacesRoot".equals(input.getType())) {
            maxSize = -1L;
        } else {
            QuotaAware qa = (QuotaAware)input.getAdapter(QuotaAware.class);
            if (qa != null) {
                maxSize = qa.getMaxQuota();
            }
        }
        jsonObj.put("quotaValue", maxSize);
        JSONObject maxSizeJson = QuotaConfigInfo.getMaxQuotaSize();
        jsonObj.put("maxQuotaSize", maxSizeJson.get("maxQuotaSize"));
        jsonObj.put("maxQuotaSizeStr", maxSizeJson.get("maxQuotaSizeStr"));
        return Blobs.createJSONBlob((String)jsonObj.toString());
    }
}

