/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;
import org.nuxeo.ecm.quota.size.QuotaExceededException;

public abstract class AbstractQuotaStatsUpdater
implements QuotaStatsUpdater {
    private static final Logger log = LogManager.getLogger(AbstractQuotaStatsUpdater.class);
    protected String name;
    protected String label;
    protected String descriptionLabel;

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setDescriptionLabel(String descriptionLabel) {
        this.descriptionLabel = descriptionLabel;
    }

    @Override
    public String getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @Override
    public void updateStatistics(CoreSession session, DocumentEventContext docCtx, Event event) {
        DocumentModel doc = docCtx.getSourceDocument();
        if (!this.needToProcessEventOnDocument(event, doc)) {
            log.debug("Exit Listener !!!!");
            return;
        }
        try {
            switch (event.getName()) {
                case "documentCreated": {
                    this.processDocumentCreated(session, doc);
                    break;
                }
                case "aboutToRemove": 
                case "aboutToRemoveVersion": {
                    this.processDocumentAboutToBeRemoved(session, doc);
                    break;
                }
                case "documentCreatedByCopy": {
                    this.processDocumentCopied(session, doc);
                    break;
                }
                case "documentMoved": {
                    DocumentModel parent;
                    DocumentRef sourceParentRef = (DocumentRef)docCtx.getProperty("parentPath");
                    DocumentRef destinationRef = (DocumentRef)docCtx.getProperty("destinationRef");
                    DocumentModel sourceParent = sourceParentRef == null ? null : session.getDocument(sourceParentRef);
                    DocumentModel documentModel = parent = destinationRef == null ? null : session.getDocument(destinationRef);
                    if (sourceParent == null && parent == null || sourceParent != null && parent != null && sourceParent.getId().equals(parent.getId())) break;
                    this.processDocumentMoved(session, doc, sourceParent);
                    break;
                }
                case "documentModified": {
                    this.processDocumentUpdated(session, doc);
                    break;
                }
                case "beforeDocumentModification": {
                    this.processDocumentBeforeUpdate(session, doc);
                    break;
                }
                case "lifecycle_transition_event": {
                    String transition = (String)((Object)docCtx.getProperty("transition"));
                    if (!"delete".equals(transition) && !"undelete".equals(transition)) break;
                    this.processDocumentTrashOp(session, doc, "delete".equals(transition));
                    break;
                }
                case "documentCheckedIn": {
                    this.processDocumentCheckedIn(session, doc);
                    break;
                }
                case "aboutToCheckIn": {
                    this.processDocumentBeforeCheckedIn(session, doc);
                    break;
                }
                case "documentCheckedOut": {
                    this.processDocumentCheckedOut(session, doc);
                    break;
                }
                case "aboutToCheckout": {
                    this.processDocumentBeforeCheckedOut(session, doc);
                    break;
                }
                case "beforeRestoringDocument": {
                    this.processDocumentBeforeRestore(session, doc);
                    break;
                }
                case "documentRestored": {
                    this.processDocumentRestored(session, doc);
                    break;
                }
                case "documentTrashed": {
                    this.processDocumentTrashOp(session, doc, true);
                    break;
                }
                case "documentUntrashed": {
                    this.processDocumentTrashOp(session, doc, false);
                }
            }
        }
        catch (QuotaExceededException e) {
            this.handleQuotaExceeded(e, event);
            throw e;
        }
    }

    protected List<DocumentModel> getAncestors(CoreSession session, DocumentModel doc) {
        ArrayList<DocumentModel> ancestors = new ArrayList<DocumentModel>();
        for (DocumentRef documentRef : session.getParentDocumentRefs(doc.getRef())) {
            ancestors.add(session.getDocument(documentRef));
        }
        return ancestors;
    }

    protected abstract void handleQuotaExceeded(QuotaExceededException var1, Event var2);

    protected abstract boolean needToProcessEventOnDocument(Event var1, DocumentModel var2);

    protected abstract void processDocumentCreated(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentCopied(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentCheckedIn(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentBeforeCheckedIn(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentCheckedOut(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentBeforeCheckedOut(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentUpdated(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentMoved(CoreSession var1, DocumentModel var2, DocumentModel var3);

    protected abstract void processDocumentAboutToBeRemoved(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentBeforeUpdate(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentTrashOp(CoreSession var1, DocumentModel var2, boolean var3);

    protected abstract void processDocumentRestored(CoreSession var1, DocumentModel var2);

    protected abstract void processDocumentBeforeRestore(CoreSession var1, DocumentModel var2);
}

