/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.runtime.api.Framework;

public class QuotaStatsInitialWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final String CATEGORY_QUOTA_INITIAL = "quotaInitialStatistics";
    private final String updaterName;
    protected final String path;

    public QuotaStatsInitialWork(String updaterName, String repositoryName, String path) {
        super(repositoryName + ":quotaInitialStatistics:" + updaterName);
        this.setDocument(repositoryName, null);
        this.updaterName = updaterName;
        this.path = path;
    }

    public String getCategory() {
        return CATEGORY_QUOTA_INITIAL;
    }

    public String getTitle() {
        return "Quota Statistics " + this.updaterName;
    }

    public void notifyProgress(float percent) {
        this.setProgress(new Work.Progress(percent));
    }

    public void notifyProgress(long current, long total) {
        this.setProgress(new Work.Progress(current, total));
    }

    public boolean isIdempotent() {
        return false;
    }

    public void work() {
        final QuotaStatsInitialWork currentWorker = this;
        new UnrestrictedSessionRunner(this.repositoryName){

            public void run() {
                QuotaStatsService service = (QuotaStatsService)Framework.getService(QuotaStatsService.class);
                service.computeInitialStatistics(QuotaStatsInitialWork.this.updaterName, this.session, currentWorker, QuotaStatsInitialWork.this.path);
            }
        }.runUnrestricted();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("updaterName", (Object)this.updaterName).append("repositoryName", (Object)this.repositoryName).toString();
    }
}

