/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.quota.QuotaMaxSizeSetterWork;
import org.nuxeo.ecm.quota.QuotaStatsInitialWork;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;
import org.nuxeo.ecm.quota.QuotaStatsUpdaterDescriptor;
import org.nuxeo.ecm.quota.QuotaStatsUpdaterRegistry;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaAwareDocumentFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class QuotaStatsServiceImpl
extends DefaultComponent
implements QuotaStatsService {
    private static final Logger log = LogManager.getLogger(QuotaStatsServiceImpl.class);
    public static final String STATUS_INITIAL_COMPUTATION_QUEUED = "status.quota.initialComputationQueued";
    public static final String STATUS_INITIAL_COMPUTATION_PENDING = "status.quota.initialComputationInProgress";
    public static final String STATUS_INITIAL_COMPUTATION_COMPLETED = "status.quota.initialComputationCompleted";
    public static final int DEFAULT_BATCH_SIZE = 1000;
    public static final String QUOTA_STATS_UPDATERS_EP = "quotaStatsUpdaters";
    protected QuotaStatsUpdaterRegistry quotaStatsUpdaterRegistry;

    public void activate(ComponentContext context) {
        this.quotaStatsUpdaterRegistry = new QuotaStatsUpdaterRegistry();
    }

    @Override
    public List<QuotaStatsUpdater> getQuotaStatsUpdaters() {
        return this.quotaStatsUpdaterRegistry.getQuotaStatsUpdaters();
    }

    public QuotaStatsUpdater getQuotaStatsUpdaters(String updaterName) {
        return this.quotaStatsUpdaterRegistry.getQuotaStatsUpdater(updaterName);
    }

    @Override
    public void updateStatistics(final DocumentEventContext docCtx, final Event event) {
        new UnrestrictedSessionRunner(docCtx.getCoreSession()){

            public void run() {
                List<QuotaStatsUpdater> quotaStatsUpdaters = QuotaStatsServiceImpl.this.quotaStatsUpdaterRegistry.getQuotaStatsUpdaters();
                for (QuotaStatsUpdater updater : quotaStatsUpdaters) {
                    DocumentModel doc = docCtx.getSourceDocument();
                    log.trace("Calling updateStatistics of: {} for: {} on: {} ({})", (Object)updater.getName(), (Object)event.getName(), (Object)doc.getId(), (Object)doc.getPathAsString());
                    updater.updateStatistics(this.session, docCtx, event);
                }
            }
        }.runUnrestricted();
    }

    @Override
    public void computeInitialStatistics(String updaterName, CoreSession session, QuotaStatsInitialWork currentWorker, String path) {
        QuotaStatsUpdater updater = this.quotaStatsUpdaterRegistry.getQuotaStatsUpdater(updaterName);
        if (updater != null) {
            updater.computeInitialStatistics(session, currentWorker, path);
        }
    }

    @Override
    public void launchInitialStatisticsComputation(String updaterName, String repositoryName, String path) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        if (workManager == null) {
            throw new RuntimeException("No WorkManager available");
        }
        QuotaStatsInitialWork work = new QuotaStatsInitialWork(updaterName, repositoryName, path);
        workManager.schedule((Work)work, true);
    }

    @Override
    public String getProgressStatus(String updaterName, String repositoryName) {
        QuotaStatsInitialWork work;
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        Work.State state = workManager.getWorkState((work = new QuotaStatsInitialWork(updaterName, repositoryName, null)).getId());
        if (state == null) {
            return null;
        }
        if (state == Work.State.SCHEDULED) {
            return STATUS_INITIAL_COMPUTATION_QUEUED;
        }
        if (state == Work.State.RUNNING) {
            return STATUS_INITIAL_COMPUTATION_PENDING;
        }
        return STATUS_INITIAL_COMPUTATION_COMPLETED;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUOTA_STATS_UPDATERS_EP.equals(extensionPoint)) {
            this.quotaStatsUpdaterRegistry.addContribution((QuotaStatsUpdaterDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUOTA_STATS_UPDATERS_EP.equals(extensionPoint)) {
            this.quotaStatsUpdaterRegistry.removeContribution((QuotaStatsUpdaterDescriptor)contribution);
        }
    }

    @Override
    public long getQuotaFromParent(DocumentModel doc, CoreSession session) {
        List<DocumentModel> parents = this.getParentsInReverseOrder(doc, session);
        if (parents.size() > 0 && "UserWorkspacesRoot".equals(parents.get(0).getType())) {
            QuotaAware qa = (QuotaAware)parents.get(0).getAdapter(QuotaAware.class);
            return qa != null ? qa.getMaxQuota() : -1L;
        }
        for (DocumentModel documentModel : parents) {
            QuotaAware qa = (QuotaAware)documentModel.getAdapter(QuotaAware.class);
            if (qa == null || qa.getMaxQuota() <= 0L) continue;
            return qa.getMaxQuota();
        }
        return -1L;
    }

    @Override
    public void activateQuotaOnUserWorkspaces(final long maxQuota, CoreSession session) {
        final String userWorkspacesRootId = this.getUserWorkspaceRootId(session.getRootDocument(), session);
        new UnrestrictedSessionRunner(session){

            public void run() {
                DocumentModel uwRoot = this.session.getDocument((DocumentRef)new IdRef(userWorkspacesRootId));
                QuotaAware qa = QuotaAwareDocumentFactory.make(uwRoot);
                qa.setMaxQuota(maxQuota);
                qa.save();
            }
        }.runUnrestricted();
    }

    @Override
    public long getQuotaSetOnUserWorkspaces(CoreSession session) {
        final String userWorkspacesRootId = this.getUserWorkspaceRootId(session.getRootDocument(), session);
        return new UnrestrictedSessionRunner(session){
            long quota;
            {
                super(session);
                this.quota = -1L;
            }

            public long getsQuotaSetOnUserWorkspaces() {
                this.runUnrestricted();
                return this.quota;
            }

            public void run() {
                DocumentModel uwRoot = this.session.getDocument((DocumentRef)new IdRef(userWorkspacesRootId));
                QuotaAware qa = (QuotaAware)uwRoot.getAdapter(QuotaAware.class);
                this.quota = qa == null ? -1L : qa.getMaxQuota();
            }
        }.getsQuotaSetOnUserWorkspaces();
    }

    protected List<DocumentModel> getParentsInReverseOrder(DocumentModel doc, CoreSession session) {
        UnrestrictedParentsFetcher parentsFetcher = new UnrestrictedParentsFetcher(doc, session);
        return parentsFetcher.getParents();
    }

    @Override
    public void launchSetMaxQuotaOnUserWorkspaces(final long maxSize, DocumentModel context, CoreSession session) {
        final String userWorkspacesId = this.getUserWorkspaceRootId(context, session);
        new UnrestrictedSessionRunner(session){

            public void run() {
                try (IterableQueryResult results = this.session.queryAndFetch(String.format("Select ecm:uuid from Workspace where ecm:parentId = '%s'  AND ecm:isVersion = 0 AND ecm:isTrashed = 0", userWorkspacesId), "NXQL", new Object[0]);){
                    int size = 0;
                    ArrayList<String> allIds = new ArrayList<String>();
                    for (Map map : results) {
                        allIds.add((String)map.get("ecm:uuid"));
                    }
                    ArrayList<String> ids = new ArrayList<String>();
                    WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
                    for (String id : allIds) {
                        ids.add(id);
                        if (++size % 1000 != 0) continue;
                        QuotaMaxSizeSetterWork work = new QuotaMaxSizeSetterWork(maxSize, ids, this.session.getRepositoryName());
                        workManager.schedule((Work)work, true);
                        ids = new ArrayList();
                    }
                    if (ids.size() > 0) {
                        QuotaMaxSizeSetterWork work = new QuotaMaxSizeSetterWork(maxSize, ids, this.session.getRepositoryName());
                        workManager.schedule((Work)work, true);
                    }
                }
            }
        }.runUnrestricted();
    }

    public String getUserWorkspaceRootId(DocumentModel context, CoreSession session) {
        DocumentModel currentUserWorkspace = ((UserWorkspaceService)Framework.getService(UserWorkspaceService.class)).getUserPersonalWorkspace(session.getPrincipal().getName(), context);
        return ((IdRef)currentUserWorkspace.getParentRef()).value;
    }

    @Override
    public boolean canSetMaxQuota(long maxQuota, DocumentModel doc, CoreSession session) {
        QuotaAware qa = null;
        DocumentModel parent = null;
        if ("UserWorkspacesRoot".equals(doc.getType())) {
            return true;
        }
        List<DocumentModel> parents = this.getParentsInReverseOrder(doc, session);
        if (!parents.isEmpty() && "UserWorkspacesRoot".equals(parents.get(0).getType())) {
            return true;
        }
        for (DocumentModel p : parents) {
            qa = (QuotaAware)p.getAdapter(QuotaAware.class);
            if (qa == null || qa.getMaxQuota() <= 0L) continue;
            parent = p;
            break;
        }
        if (qa == null || qa.getMaxQuota() < 0L) {
            return true;
        }
        long maxAllowedOnChildrenToSetQuota = qa.getMaxQuota() - maxQuota;
        if (maxAllowedOnChildrenToSetQuota < 0L) {
            return false;
        }
        Long quotaOnChildren = new UnrestrictedQuotaOnChildrenCalculator(parent, maxAllowedOnChildrenToSetQuota, doc.getId(), session).quotaOnChildren();
        return quotaOnChildren <= 0L || quotaOnChildren <= maxAllowedOnChildrenToSetQuota;
    }

    class UnrestrictedParentsFetcher
    extends UnrestrictedSessionRunner {
        DocumentModel doc;
        List<DocumentModel> parents;

        protected UnrestrictedParentsFetcher(DocumentModel doc, CoreSession session) {
            super(session);
            this.doc = doc;
        }

        public void run() {
            this.parents = new ArrayList<DocumentModel>();
            DocumentRef[] parentRefs = this.session.getParentDocumentRefs(this.doc.getRef());
            for (DocumentRef documentRef : parentRefs) {
                this.parents.add(this.session.getDocument(documentRef));
            }
            for (DocumentModel parent : this.parents) {
                parent.detach(true);
            }
        }

        public List<DocumentModel> getParents() {
            this.runUnrestricted();
            return this.parents;
        }
    }

    class UnrestrictedQuotaOnChildrenCalculator
    extends UnrestrictedSessionRunner {
        DocumentModel parent;
        Long maxAllowedOnChildrenToSetQuota;
        long quotaOnChildren;
        String currentDocIdToIgnore;

        protected UnrestrictedQuotaOnChildrenCalculator(DocumentModel parent, Long maxAllowedOnChildrenToSetQuota, String currentDocIdToIgnore, CoreSession session) {
            super(session);
            this.quotaOnChildren = -1L;
            this.parent = parent;
            this.maxAllowedOnChildrenToSetQuota = maxAllowedOnChildrenToSetQuota;
            this.currentDocIdToIgnore = currentDocIdToIgnore;
        }

        public void run() {
            this.quotaOnChildren = this.canSetMaxQuotaOnChildrenTree(this.maxAllowedOnChildrenToSetQuota, this.quotaOnChildren, this.parent, this.currentDocIdToIgnore, this.session);
        }

        public long quotaOnChildren() {
            this.runUnrestricted();
            return this.quotaOnChildren;
        }

        protected Long canSetMaxQuotaOnChildrenTree(Long maxAllowedOnChildrenToSetQuota, Long quotaOnChildren, DocumentModel doc, String currentDocIdToIgnore, CoreSession session) {
            if (quotaOnChildren > 0L && quotaOnChildren > maxAllowedOnChildrenToSetQuota) {
                return quotaOnChildren;
            }
            DocumentModelIterator childrenIterator = null;
            childrenIterator = session.getChildrenIterator(doc.getRef(), null, null, (Filter)new QuotaFilter());
            while (childrenIterator.hasNext()) {
                DocumentModel child = (DocumentModel)childrenIterator.next();
                QuotaAware qac = (QuotaAware)child.getAdapter(QuotaAware.class);
                if (qac == null) continue;
                if (qac.getMaxQuota() > 0L && !currentDocIdToIgnore.equals(child.getId())) {
                    quotaOnChildren = (quotaOnChildren == -1L ? 0L : quotaOnChildren) + qac.getMaxQuota();
                }
                if (quotaOnChildren > 0L && quotaOnChildren > maxAllowedOnChildrenToSetQuota) {
                    return quotaOnChildren;
                }
                if (qac.getMaxQuota() == -1L) {
                    quotaOnChildren = this.canSetMaxQuotaOnChildrenTree(maxAllowedOnChildrenToSetQuota, quotaOnChildren, child, currentDocIdToIgnore, session);
                }
                if (quotaOnChildren <= 0L || quotaOnChildren <= maxAllowedOnChildrenToSetQuota) continue;
                return quotaOnChildren;
            }
            return quotaOnChildren;
        }
    }

    class QuotaFilter
    implements Filter {
        QuotaFilter() {
        }

        public boolean accept(DocumentModel doc) {
            return !"UserWorkspacesRoot".equals(doc.getType());
        }
    }
}

