/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.automation;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.quota.size.QuotaAware;
import org.nuxeo.ecm.quota.size.QuotaInfo;

@Operation(id="Quotas.GetStatistics", category="Quotas", label="Get Quota statistics", description="Returns the Quota Infos (innerSize, totalSize and maxQuota) for a DocumentModel")
public class GetQuotaStatisticsOperation {
    public static final String ID = "Quotas.GetStatistics";
    @Context
    protected CoreSession session;
    @Param(name="documentRef", required=true)
    protected DocumentRef documentRef;
    @Param(name="language", required=false)
    protected String language;

    @OperationMethod
    public Blob run() {
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        DocumentModel doc = this.session.getDocument(this.documentRef);
        QuotaAware qa = (QuotaAware)doc.getAdapter(QuotaAware.class);
        if (qa == null) {
            throw new NuxeoException("Quota not activated on doc");
        }
        String string = this.toJSON(qa.getQuotaInfo(), locale);
        return Blobs.createJSONBlob((String)string);
    }

    public String toJSON(QuotaInfo quotaInfo, Locale locale) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        ArrayList<QuotaStat> stats = new ArrayList<QuotaStat>();
        stats.add(new QuotaStat(quotaInfo.getLiveSize().getValue(), this.getI18nLabel("label.quota.liveSize", locale) + ":" + nf.format(quotaInfo.getLiveSize().getValueInUnit()) + " " + this.getI18nLabel(quotaInfo.getLiveSize().getUnit(), locale)));
        stats.add(new QuotaStat(quotaInfo.getTrashSize().getValue(), this.getI18nLabel("label.quota.trashSize", locale) + ":" + nf.format(quotaInfo.getTrashSize().getValueInUnit()) + " " + this.getI18nLabel(quotaInfo.getTrashSize().getUnit(), locale)));
        stats.add(new QuotaStat(quotaInfo.getSizeVersions().getValue(), this.getI18nLabel("label.quota.versionsSize", locale) + ":" + nf.format(quotaInfo.getSizeVersions().getValueInUnit()) + " " + this.getI18nLabel(quotaInfo.getSizeVersions().getUnit(), locale)));
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        try {
            mapper.writeValue((Writer)writer, stats);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        return writer.toString();
    }

    protected String getI18nLabel(String label, Locale locale) {
        if (label == null) {
            label = "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)label, null, (Locale)locale);
    }

    class QuotaStat {
        private String label;
        private long data;

        QuotaStat(long data, String label) {
            this.data = data;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public long getData() {
            return this.data;
        }
    }
}

