/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.quota.webui.operations;

import nuxeo.quota.webui.QuotaConfigInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.ecm.quota.QuotaStatsService;

@Operation(id="Quota.GetConfigurationAndInfo", category="Quotas", label="Quota: Get Configuration", description="Return the misc configuration settings")
public class QuotaGetConfigurationAndInfo {
    private static final Logger log = LogManager.getLogger(QuotaGetConfigurationAndInfo.class);
    public static final String ID = "Quota.GetConfigurationAndInfo";
    public static final String QUOTA_MAX_SIZE_PROP = "nuxeo.quota.maxsize";
    public static final String QUOTA_MAX_SIZE_DEFAULT = "999 GB";
    @Context
    protected CoreSession session;
    @Context
    WorkManager workManager;
    @Context
    QuotaStatsService quotaStatsService;

    @OperationMethod
    public Blob run() {
        JSONObject jsonObj = new JSONObject();
        JSONObject maxSizeJson = QuotaConfigInfo.getMaxQuotaSize();
        jsonObj.put("maxQuotaSize", maxSizeJson.get("maxQuotaSize"));
        jsonObj.put("maxQuotaSizeStr", maxSizeJson.get("maxQuotaSizeStr"));
        boolean running = false;
        WorkQueueMetrics metrics = this.workManager.getMetrics("quota");
        if (metrics != null) {
            running = metrics.getRunning().longValue() + metrics.getScheduled().longValue() > 0L;
        }
        jsonObj.put("hasWorkInProgress", running);
        jsonObj.put("quotaSetOnUserWS", this.quotaStatsService.getQuotaSetOnUserWorkspaces(this.session));
        return Blobs.createJSONBlob((String)jsonObj.toString());
    }
}

