/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.quota.webui.operations;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;

@Operation(id="Quota.GetStatsUpdaters", category="Quotas", label="Quota: Get Stats Updaters", description="Get the updaters (to display in the UI)")
public class QuotaGetStatsUpdaters {
    public static final String ID = "Quota.GetStatsUpdaters";
    @Context
    QuotaStatsService quotaStatsService;

    @OperationMethod
    public Blob run() {
        List updaters = this.quotaStatsService.getQuotaStatsUpdaters();
        JSONArray jsonArr = new JSONArray();
        for (QuotaStatsUpdater updater : updaters) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("name", (Object)updater.getName());
            jsonObj.put("label", (Object)updater.getLabel());
            jsonObj.put("description", (Object)updater.getDescriptionLabel());
            jsonArr.put((Object)jsonObj);
        }
        return Blobs.createJSONBlob((String)jsonArr.toString());
    }
}

