/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.quota.webui.operations;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.ecm.quota.QuotaStatsUpdater;

@Operation(id="Quota.GetStatus", category="Quotas", label="Quota: Get Status", description="Get status of quotas, returns a JSON array of updater label and status.")
public class QuotaGetStatus {
    public static final String ID = "Quota.GetStatus";
    public static final String NO_STATUS = "Not running";
    @Context
    protected CoreSession session;
    @Context
    QuotaStatsService quotaStatsService;

    @OperationMethod
    public Blob run() {
        List updaters = this.quotaStatsService.getQuotaStatsUpdaters();
        JSONArray jsonArr = new JSONArray();
        for (QuotaStatsUpdater updater : updaters) {
            String status = this.quotaStatsService.getProgressStatus(updater.getName(), this.session.getRepositoryName());
            if (status == null) {
                status = NO_STATUS;
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("updaterName", (Object)updater.getName());
            jsonObj.put("updaterLabel", (Object)updater.getLabel());
            jsonObj.put("status", (Object)status);
            jsonArr.put((Object)jsonObj);
        }
        return Blobs.createJSONBlob((String)jsonArr.toString());
    }
}

