/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.quota.webui.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.quota.QuotaStatsService;

@Operation(id="Quota.SetOnUserWorkspaces", category="Quotas", label="Quota: Set on User Workspaces", description="Activate quota on all user workspaces.")
public class QuotaSetOnUserWorkspaces {
    public static final String ID = "Quota.SetOnUserWorkspaces";
    @Context
    protected CoreSession session;
    @Context
    QuotaStatsService quotaStatsService;
    @Param(name="maxSize", required=true)
    protected Long maxSize;

    @OperationMethod
    public Blob run() {
        this.quotaStatsService.activateQuotaOnUserWorkspaces(this.maxSize.longValue(), this.session);
        this.quotaStatsService.launchSetMaxQuotaOnUserWorkspaces(this.maxSize.longValue(), this.session.getRootDocument(), this.session);
        return Blobs.createJSONBlob((String)"{\"status\": \"started\"}");
    }
}

