/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.quota.webui;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import org.nuxeo.common.utils.SizeUtils;
import org.nuxeo.runtime.api.Framework;

public class QuotaConfigInfo {
    private static final Logger log = LogManager.getLogger(QuotaConfigInfo.class);
    public static final String QUOTA_MAX_SIZE_PROP = "nuxeo.quota.maxsize";
    public static final String QUOTA_MAX_SIZE_DEFAULT = "999 GB";

    public static JSONObject getMaxQuotaSize() {
        long configuredMaxQuotaSize;
        JSONObject maxSizeJson = new JSONObject();
        String maxSizeStr = Framework.getProperty((String)QUOTA_MAX_SIZE_PROP, (String)QUOTA_MAX_SIZE_DEFAULT);
        try {
            configuredMaxQuotaSize = SizeUtils.parseSizeInBytes((String)maxSizeStr);
        }
        catch (NumberFormatException e) {
            log.error("Invalid value for configuration property nuxeo.quota.maxsize: " + maxSizeStr + "; using default: 999 GB");
            configuredMaxQuotaSize = SizeUtils.parseSizeInBytes((String)QUOTA_MAX_SIZE_DEFAULT);
        }
        maxSizeJson.put("maxQuotaSize", configuredMaxQuotaSize);
        maxSizeJson.put("maxQuotaSizeStr", (Object)maxSizeStr);
        return maxSizeJson;
    }
}

