/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.quota.automation;

import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.quota.QuotaStatsService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Quotas.RecomputeStatistics", category="Quotas", label="Recompute quota statistics on documents, optionally only for a tenant, user or path")
public class RecomputeQuotaStatistics {
    public static final String ID = "Quotas.RecomputeStatistics";
    public static final String SIZE_UPDATER = "documentsSizeUpdater";
    @Param(name="tenantId", required=false)
    protected String tenantId;
    @Param(name="username", required=false)
    protected String username;
    @Param(name="path", required=false)
    protected String path;
    @Param(name="updaterName", required=false)
    protected String updaterName;
    @Context
    protected CoreSession session;
    @Context
    protected QuotaStatsService quotaStatsService;

    @OperationMethod
    public String run() throws OperationException {
        String docPath;
        if (this.tenantId != null) {
            if (this.username != null || this.path != null) {
                throw new OperationException("Only one of tenantId, username or path can be defined");
            }
            docPath = this.getTenantPath();
        } else if (this.username != null) {
            if (this.path != null) {
                throw new OperationException("Only one of tenantId, username or path can be defined");
            }
            docPath = this.getUserPersonalWorkspacePath();
        } else {
            docPath = this.path;
        }
        if (this.updaterName == null) {
            this.updaterName = SIZE_UPDATER;
        }
        String repositoryName = this.session.getRepositoryName();
        this.quotaStatsService.launchInitialStatisticsComputation(this.updaterName, repositoryName, docPath);
        return this.quotaStatsService.getProgressStatus(this.updaterName, repositoryName);
    }

    protected String getTenantPath() throws OperationException {
        if (this.tenantId.contains("/")) {
            throw new OperationException("Invalid tenantId: " + this.tenantId);
        }
        return "/" + this.tenantId;
    }

    protected String getUserPersonalWorkspacePath() throws OperationException {
        UserWorkspaceService uws = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        DocumentModel userWorkspace = uws.getUserPersonalWorkspace(this.username, this.session.getRootDocument());
        if (userWorkspace == null) {
            throw new OperationException("Invalid username or missing user workspace: " + this.username);
        }
        return userWorkspace.getPathAsString();
    }
}

